/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.CalendarUnit;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.MonthBasedCalendarSystem;
import net.time4j.calendar.PersianEra;
import net.time4j.calendar.PersianMonth;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="persian")
public final class PersianCalendar
extends Calendrical<Unit, PersianCalendar>
implements LocalizedPatternSupport {
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<PersianEra> ERA = new StdEnumDateElement<PersianEra, PersianCalendar>("ERA", PersianCalendar.class, PersianEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, PersianCalendar> YEAR_OF_ERA = new StdIntegerDateElement<PersianCalendar>("YEAR_OF_ERA", PersianCalendar.class, 1, 3000, 'y', null, null);
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<PersianMonth, PersianCalendar> MONTH_OF_YEAR = new StdEnumDateElement<PersianMonth, PersianCalendar>("MONTH_OF_YEAR", PersianCalendar.class, PersianMonth.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, PersianCalendar> DAY_OF_MONTH = new StdIntegerDateElement<PersianCalendar>("DAY_OF_MONTH", PersianCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, PersianCalendar> DAY_OF_YEAR = new StdIntegerDateElement<PersianCalendar>("DAY_OF_YEAR", PersianCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, PersianCalendar> DAY_OF_WEEK = new StdWeekdayElement<PersianCalendar>(PersianCalendar.class);
    private static final MonthBasedCalendarSystem<PersianCalendar> CALSYS = new Transformer();
    private static final TimeAxis<Unit, PersianCalendar> ENGINE;
    private static final long serialVersionUID = -411339992208638290L;
    private final transient int pyear;
    private final transient int pmonth;
    private final transient int pdom;

    private PersianCalendar(int n, int n2, int n3) {
        this.pyear = n;
        this.pmonth = n2;
        this.pdom = n3;
    }

    public static PersianCalendar of(int n, PersianMonth persianMonth, int n2) {
        return PersianCalendar.of(n, persianMonth.getValue(), n2);
    }

    public static PersianCalendar of(int n, int n2, int n3) {
        if (!CALSYS.isValid(PersianEra.ANNO_PERSICO, n, n2, n3)) {
            throw new IllegalArgumentException("Invalid Persian date: year=" + n + ", month=" + n2 + ", day=" + n3);
        }
        return new PersianCalendar(n, n2, n3);
    }

    public PersianEra getEra() {
        return PersianEra.ANNO_PERSICO;
    }

    public int getYear() {
        return this.pyear;
    }

    public PersianMonth getMonth() {
        return PersianMonth.valueOf(this.pmonth);
    }

    public int getDayOfMonth() {
        return this.pdom;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform((Object)this);
        return Weekday.valueOf((int)(MathUtils.floorModulo((long)(l + 5L), (int)7) + 1));
    }

    public int getDayOfYear() {
        return (Integer)this.get(DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, this.pyear, this.pmonth);
    }

    public int lengthOfYear() {
        return CALSYS.getLengthOfYear(PersianEra.ANNO_PERSICO, this.pyear);
    }

    public boolean isLeapYear() {
        return this.lengthOfYear() > 365;
    }

    public GeneralTimestamp<PersianCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of((Calendrical)this, (PlainTime)plainTime);
    }

    public GeneralTimestamp<PersianCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of((int)n, (int)n2));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PersianCalendar) {
            PersianCalendar persianCalendar = (PersianCalendar)((Object)object);
            return this.pdom == persianCalendar.pdom && this.pmonth == persianCalendar.pmonth && this.pyear == persianCalendar.pyear;
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.pdom + 31 * this.pmonth + 37 * this.pyear;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("AP-");
        String string = String.valueOf(this.pyear);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (this.pmonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.pmonth);
        stringBuilder.append('-');
        if (this.pdom < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.pdom);
        return stringBuilder.toString();
    }

    public static TimeAxis<Unit, PersianCalendar> axis() {
        return ENGINE;
    }

    protected TimeAxis<Unit, PersianCalendar> getChronology() {
        return ENGINE;
    }

    protected PersianCalendar getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX((Object)this, 2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        TimeAxis.Builder builder = TimeAxis.Builder.setUp(Unit.class, PersianCalendar.class, (ChronoMerger)new Merger(), CALSYS).appendElement(ERA, (ElementRule)new EraRule()).appendElement(YEAR_OF_ERA, (ElementRule)new IntegerRule(0), (Object)Unit.YEARS).appendElement(MONTH_OF_YEAR, (ElementRule)new MonthRule(), (Object)Unit.MONTHS).appendElement(DAY_OF_MONTH, (ElementRule)new IntegerRule(2), (Object)Unit.DAYS).appendElement(DAY_OF_YEAR, (ElementRule)new IntegerRule(3), (Object)Unit.DAYS).appendElement(DAY_OF_WEEK, (ElementRule)new WeekdayRule(), (Object)Unit.DAYS).appendElement(CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<PersianCalendar>(CALSYS, DAY_OF_YEAR)).appendUnit((Object)Unit.YEARS, (UnitRule)new PersianUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit((Object)Unit.MONTHS, (UnitRule)new PersianUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit((Object)Unit.WEEKS, (UnitRule)new PersianUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit((Object)Unit.DAYS, (UnitRule)new PersianUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS));
        ENGINE = builder.build();
    }

    private static class PersianUnitRule
    implements UnitRule<PersianCalendar> {
        private final Unit unit;

        PersianUnitRule(Unit unit) {
            this.unit = unit;
        }

        public PersianCalendar addTo(PersianCalendar persianCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    l = MathUtils.safeMultiply((long)l, (long)12L);
                }
                case MONTHS: {
                    long l2 = MathUtils.safeAdd((long)PersianUnitRule.ymValue(persianCalendar), (long)l);
                    int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)l2, (int)12));
                    int n2 = MathUtils.floorModulo((long)l2, (int)12) + 1;
                    int n3 = Math.min(persianCalendar.pdom, CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, n, n2));
                    return PersianCalendar.of(n, n2, n3);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply((long)l, (long)7L);
                }
                case DAYS: {
                    long l3 = MathUtils.safeAdd((long)CALSYS.transform((Object)persianCalendar), (long)l);
                    return (PersianCalendar)((Object)CALSYS.transform(l3));
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        public long between(PersianCalendar persianCalendar, PersianCalendar persianCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    return Unit.MONTHS.between(persianCalendar, persianCalendar2) / 12;
                }
                case MONTHS: {
                    long l = PersianUnitRule.ymValue(persianCalendar2) - PersianUnitRule.ymValue(persianCalendar);
                    if (l > 0L && persianCalendar2.pdom < persianCalendar.pdom) {
                        --l;
                    } else if (l < 0L && persianCalendar2.pdom > persianCalendar.pdom) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(persianCalendar, persianCalendar2) / 7;
                }
                case DAYS: {
                    return CALSYS.transform((Object)persianCalendar2) - CALSYS.transform((Object)persianCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int ymValue(PersianCalendar persianCalendar) {
            return persianCalendar.pyear * 12 + persianCalendar.pmonth - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<PersianCalendar> {
        private Merger() {
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("persian", displayStyle, locale);
        }

        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        public PersianCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)this.getDefaultStartOfDay());
            return (PersianCalendar)Moment.from((UnixTime)timeSource.currentTime()).toGeneralTimestamp((Chronology)ENGINE, tZID, startOfDay).toDate();
        }

        @Deprecated
        public PersianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public PersianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Persian year.");
                return null;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2 = ((PersianMonth)((Object)chronoEntity.get(MONTH_OF_YEAR))).getValue();
                int n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(PersianEra.ANNO_PERSICO, n, n2, n3)) {
                        return PersianCalendar.of(n, n2, n3);
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Persian date.");
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 > 0) {
                        int n5 = 1;
                        int n6 = 0;
                        while (n5 <= 12) {
                            int n7 = CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, n, n5);
                            if (n4 > n6 + n7) {
                                ++n5;
                                n6 += n7;
                                continue;
                            }
                            int n8 = n4 - n6;
                            return PersianCalendar.of(n, n5, n8);
                        }
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Persian date.");
                }
            }
            return null;
        }

        public ChronoDisplay preformat(PersianCalendar persianCalendar, AttributeQuery attributeQuery) {
            return persianCalendar;
        }

        public Chronology<?> preparser() {
            return null;
        }
    }

    private static class WeekdayRule
    implements ElementRule<PersianCalendar, Weekday> {
        private WeekdayRule() {
        }

        public Weekday getValue(PersianCalendar persianCalendar) {
            return persianCalendar.getDayOfWeek();
        }

        public Weekday getMinimum(PersianCalendar persianCalendar) {
            return Weekday.SATURDAY;
        }

        public Weekday getMaximum(PersianCalendar persianCalendar) {
            return Weekday.FRIDAY;
        }

        public boolean isValid(PersianCalendar persianCalendar, Weekday weekday) {
            return weekday != null;
        }

        public PersianCalendar withValue(PersianCalendar persianCalendar, Weekday weekday, boolean bl) {
            Weekmodel weekmodel = Weekmodel.of((Weekday)Weekday.SATURDAY, (int)1);
            int n = persianCalendar.getDayOfWeek().getValue(weekmodel);
            int n2 = weekday.getValue(weekmodel);
            return (PersianCalendar)persianCalendar.plus(CalendarDays.of((long)(n2 - n)));
        }

        public ChronoElement<?> getChildAtFloor(PersianCalendar persianCalendar) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(PersianCalendar persianCalendar) {
            return null;
        }
    }

    private static class EraRule
    implements ElementRule<PersianCalendar, PersianEra> {
        private EraRule() {
        }

        public PersianEra getValue(PersianCalendar persianCalendar) {
            return PersianEra.ANNO_PERSICO;
        }

        public PersianEra getMinimum(PersianCalendar persianCalendar) {
            return PersianEra.ANNO_PERSICO;
        }

        public PersianEra getMaximum(PersianCalendar persianCalendar) {
            return PersianEra.ANNO_PERSICO;
        }

        public boolean isValid(PersianCalendar persianCalendar, PersianEra persianEra) {
            return persianEra != null;
        }

        public PersianCalendar withValue(PersianCalendar persianCalendar, PersianEra persianEra, boolean bl) {
            if (persianEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return persianCalendar;
        }

        public ChronoElement<?> getChildAtFloor(PersianCalendar persianCalendar) {
            return YEAR_OF_ERA;
        }

        public ChronoElement<?> getChildAtCeiling(PersianCalendar persianCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<PersianCalendar, PersianMonth> {
        private MonthRule() {
        }

        public PersianMonth getValue(PersianCalendar persianCalendar) {
            return persianCalendar.getMonth();
        }

        public PersianMonth getMinimum(PersianCalendar persianCalendar) {
            return PersianMonth.FARVARDIN;
        }

        public PersianMonth getMaximum(PersianCalendar persianCalendar) {
            return PersianMonth.ESFAND;
        }

        public boolean isValid(PersianCalendar persianCalendar, PersianMonth persianMonth) {
            return persianMonth != null;
        }

        public PersianCalendar withValue(PersianCalendar persianCalendar, PersianMonth persianMonth, boolean bl) {
            int n = persianMonth.getValue();
            int n2 = CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, persianCalendar.pyear, n);
            int n3 = Math.min(persianCalendar.pdom, n2);
            return new PersianCalendar(persianCalendar.pyear, n, n3);
        }

        public ChronoElement<?> getChildAtFloor(PersianCalendar persianCalendar) {
            return DAY_OF_MONTH;
        }

        public ChronoElement<?> getChildAtCeiling(PersianCalendar persianCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements ElementRule<PersianCalendar, Integer> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        public Integer getValue(PersianCalendar persianCalendar) {
            switch (this.index) {
                case 0: {
                    return persianCalendar.pyear;
                }
                case 2: {
                    return persianCalendar.pdom;
                }
                case 3: {
                    int n = 0;
                    for (int i = 1; i < persianCalendar.pmonth; ++i) {
                        n += CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, persianCalendar.pyear, i);
                    }
                    return n + persianCalendar.pdom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMinimum(PersianCalendar persianCalendar) {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMaximum(PersianCalendar persianCalendar) {
            switch (this.index) {
                case 0: {
                    return 3000;
                }
                case 2: {
                    return CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, persianCalendar.pyear, persianCalendar.pmonth);
                }
                case 3: {
                    return CALSYS.getLengthOfYear(PersianEra.ANNO_PERSICO, persianCalendar.pyear);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public boolean isValid(PersianCalendar persianCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            Integer n2 = this.getMinimum(persianCalendar);
            Integer n3 = this.getMaximum(persianCalendar);
            return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
        }

        public PersianCalendar withValue(PersianCalendar persianCalendar, Integer n, boolean bl) {
            if (!this.isValid(persianCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    int n2 = n;
                    int n3 = CALSYS.getLengthOfMonth(PersianEra.ANNO_PERSICO, n2, persianCalendar.pmonth);
                    int n4 = Math.min(persianCalendar.pdom, n3);
                    return PersianCalendar.of(n2, persianCalendar.pmonth, n4);
                }
                case 2: {
                    return new PersianCalendar(persianCalendar.pyear, persianCalendar.pmonth, n);
                }
                case 3: {
                    int n5 = n - this.getValue(persianCalendar);
                    return (PersianCalendar)persianCalendar.plus(CalendarDays.of((long)n5));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public ChronoElement<?> getChildAtFloor(PersianCalendar persianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(PersianCalendar persianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }
    }

    private static class Transformer
    implements MonthBasedCalendarSystem<PersianCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            return calendarEra == PersianEra.ANNO_PERSICO && n >= 1 && n <= 3000 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            if (calendarEra != PersianEra.ANNO_PERSICO) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (calendarEra == PersianEra.ANNO_PERSICO && n >= 1 && n <= 3000 && n2 >= 1 && n2 <= 12) {
                if (n2 <= 6) {
                    return 31;
                }
                if (n2 <= 11) {
                    return 30;
                }
                return this.getLengthOfYear(calendarEra, n) == 365 ? 29 : 30;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + n2);
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            if (calendarEra != PersianEra.ANNO_PERSICO) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 3000) {
                PersianCalendar persianCalendar = new PersianCalendar(n + 1, 1, 1);
                PersianCalendar persianCalendar2 = new PersianCalendar(n, 1, 1);
                return (int)(this.transform(persianCalendar) - this.transform(persianCalendar2));
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n);
        }

        public PersianCalendar transform(long l) {
            int n;
            int n2;
            PlainDate plainDate = PlainDate.of((long)l, (EpochDays)EpochDays.UTC);
            int n3 = plainDate.getYear() - 621;
            if (plainDate.getMonth() < 3) {
                --n3;
            }
            PlainDate plainDate2 = Transformer.vernalEquinox(n3);
            long l2 = CalendarUnit.DAYS.between((TimePoint)plainDate2, (TimePoint)plainDate);
            while (l2 < 0L) {
                plainDate2 = Transformer.vernalEquinox(--n3);
                l2 = CalendarUnit.DAYS.between((TimePoint)plainDate2, (TimePoint)plainDate);
            }
            for (n2 = 1; n2 < 12; ++n2) {
                int n4 = n = n2 <= 6 ? 31 : 30;
                if (l2 < (long)n) break;
                l2 -= (long)n;
            }
            n = (int)(l2 + 1L);
            return PersianCalendar.of(n3, n2, n);
        }

        public long transform(PersianCalendar persianCalendar) {
            long l = Transformer.vernalEquinox(persianCalendar.pyear).getDaysSinceEpochUTC();
            return l += (long)((persianCalendar.pmonth - 1) * 31 - persianCalendar.pmonth / 7 * (persianCalendar.pmonth - 7) + persianCalendar.pdom - 1);
        }

        public long getMinimumSinceUTC() {
            PersianCalendar persianCalendar = new PersianCalendar(1, 1, 1);
            return this.transform(persianCalendar);
        }

        public long getMaximumSinceUTC() {
            PersianCalendar persianCalendar = new PersianCalendar(3001, 1, 1);
            return this.transform(persianCalendar) - 1L;
        }

        public List<CalendarEra> getEras() {
            PersianEra persianEra = PersianEra.ANNO_PERSICO;
            return Collections.singletonList(persianEra);
        }

        private static PlainDate vernalEquinox(int n) {
            int n2;
            int n3;
            int[] nArray = new int[]{-61, 9, 38, 199, 426, 686, 756, 818, 1111, 1181, 1210, 1635, 2060, 2097, 2192, 2262, 2324, 2394, 2456, 3178};
            int n4 = nArray[nArray.length - 1];
            if (n < 1 || n >= n4) {
                throw new IllegalArgumentException("Persian year out of range 1-" + n4 + ": " + n);
            }
            int n5 = n + 621;
            int n6 = -14;
            int n7 = nArray[0];
            int n8 = 0;
            for (n3 = 1; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                n8 = n2 - n7;
                if (n < n2) break;
                n6 += n8 / 33 * 8 + n8 % 33 / 4;
                n7 = n2;
            }
            n3 = n - n7;
            n6 += n3 / 33 * 8 + (n3 % 33 + 3) / 4;
            if (n8 % 33 == 4 && n8 - n3 == 4) {
                ++n6;
            }
            n2 = n5 / 4 - (n5 / 100 + 1) * 3 / 4 - 150;
            int n9 = 20 + n6 - n2;
            return PlainDate.of((int)n5, (int)3, (int)n9);
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.155694336E7),
        MONTHS(2629745.28),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        public double getLength() {
            return this.length;
        }

        public boolean isCalendrical() {
            return true;
        }

        public int between(PersianCalendar persianCalendar, PersianCalendar persianCalendar2) {
            return (int)persianCalendar.until((TimePoint)persianCalendar2, (Object)this);
        }
    }
}

