/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.MinguoEra;
import net.time4j.calendar.MonthBasedCalendarSystem;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="roc")
public final class MinguoCalendar
extends Calendrical<CalendarUnit, MinguoCalendar>
implements LocalizedPatternSupport {
    @FormattableElement(format="G")
    public static final ChronoElement<MinguoEra> ERA = new StdEnumDateElement<MinguoEra, MinguoCalendar>("ERA", MinguoCalendar.class, MinguoEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, MinguoCalendar> YEAR_OF_ERA = new StdIntegerDateElement<MinguoCalendar>("YEAR_OF_ERA", MinguoCalendar.class, 1, 999998088, 'y', null, null);
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<Month, MinguoCalendar> MONTH_OF_YEAR = new StdEnumDateElement<Month, MinguoCalendar>("MONTH_OF_YEAR", MinguoCalendar.class, Month.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, MinguoCalendar> DAY_OF_MONTH = new StdIntegerDateElement<MinguoCalendar>("DAY_OF_MONTH", MinguoCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, MinguoCalendar> DAY_OF_YEAR = new StdIntegerDateElement<MinguoCalendar>("DAY_OF_YEAR", MinguoCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, MinguoCalendar> DAY_OF_WEEK = new StdWeekdayElement<MinguoCalendar>(MinguoCalendar.class);
    private static final Map<Object, ChronoElement<?>> CHILDREN;
    private static final MonthBasedCalendarSystem<MinguoCalendar> CALSYS;
    private static final TimeAxis<CalendarUnit, MinguoCalendar> ENGINE;
    private static final long serialVersionUID = -6628190121085147706L;
    private final PlainDate iso;

    private MinguoCalendar(PlainDate plainDate) {
        this.iso = plainDate;
    }

    public static MinguoCalendar of(MinguoEra minguoEra, int n, Month month, int n2) {
        return MinguoCalendar.of(minguoEra, n, month.getValue(), n2);
    }

    public static MinguoCalendar of(MinguoEra minguoEra, int n, int n2, int n3) {
        int n4 = MinguoCalendar.toProlepticYear(minguoEra, n);
        PlainDate plainDate = PlainDate.of((int)n4, (int)n2, (int)n3);
        return new MinguoCalendar(plainDate);
    }

    public MinguoEra getEra() {
        return this.iso.getYear() < 1912 ? MinguoEra.BEFORE_ROC : MinguoEra.ROC;
    }

    public int getYear() {
        MinguoEra minguoEra = this.getEra();
        return minguoEra == MinguoEra.ROC ? this.iso.getYear() - 1911 : 1912 - this.iso.getYear();
    }

    public Month getMonth() {
        return Month.valueOf((int)this.iso.getMonth());
    }

    public int getDayOfMonth() {
        return this.iso.getDayOfMonth();
    }

    public Weekday getDayOfWeek() {
        return (Weekday)this.iso.get((ChronoElement)PlainDate.DAY_OF_WEEK);
    }

    public int getDayOfYear() {
        return (Integer)this.iso.get((ChronoElement)PlainDate.DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return this.iso.lengthOfMonth();
    }

    public int lengthOfYear() {
        return this.iso.lengthOfYear();
    }

    public boolean isLeapYear() {
        return this.iso.isLeapYear();
    }

    public GeneralTimestamp<MinguoCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of((Calendrical)this, (PlainTime)plainTime);
    }

    public GeneralTimestamp<MinguoCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of((int)n, (int)n2));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MinguoCalendar) {
            MinguoCalendar minguoCalendar = (MinguoCalendar)((Object)object);
            return this.iso.equals((Object)minguoCalendar.iso);
        }
        return false;
    }

    public int hashCode() {
        return this.iso.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append((Object)this.getEra());
        stringBuilder.append(' ');
        stringBuilder.append(this.getYear());
        stringBuilder.append('-');
        int n = this.getMonth().getValue();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        stringBuilder.append('-');
        int n2 = this.getDayOfMonth();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public static TimeAxis<CalendarUnit, MinguoCalendar> axis() {
        return ENGINE;
    }

    protected TimeAxis<CalendarUnit, MinguoCalendar> getChronology() {
        return ENGINE;
    }

    protected MinguoCalendar getContext() {
        return this;
    }

    PlainDate toISO() {
        return this.iso;
    }

    private static int toProlepticYear(MinguoEra minguoEra, int n) {
        return minguoEra == MinguoEra.ROC ? MathUtils.safeAdd((int)n, (int)1911) : MathUtils.safeSubtract((int)1912, (int)n);
    }

    private static void registerUnits(TimeAxis.Builder<CalendarUnit, MinguoCalendar> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit((Object)calendarUnit, (UnitRule)new MinguoUnitRule(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo((Enum)CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private Object writeReplace() {
        return new SPX((Object)this, 6);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        HashMap<Object, StdCalendarElement<Integer, MinguoCalendar>> hashMap = new HashMap<Object, StdCalendarElement<Integer, MinguoCalendar>>();
        hashMap.put(ERA, YEAR_OF_ERA);
        hashMap.put(YEAR_OF_ERA, MONTH_OF_YEAR);
        hashMap.put(MONTH_OF_YEAR, DAY_OF_MONTH);
        CHILDREN = Collections.unmodifiableMap(hashMap);
        CALSYS = new Transformer();
        TimeAxis.Builder builder = TimeAxis.Builder.setUp(CalendarUnit.class, MinguoCalendar.class, (ChronoMerger)new Merger(), CALSYS).appendElement(ERA, FieldRule.of(ERA)).appendElement(YEAR_OF_ERA, FieldRule.of(YEAR_OF_ERA), (Object)CalendarUnit.YEARS).appendElement(MONTH_OF_YEAR, FieldRule.of(MONTH_OF_YEAR), (Object)CalendarUnit.MONTHS).appendElement(CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<MinguoCalendar>(CALSYS, DAY_OF_YEAR)).appendElement(DAY_OF_MONTH, FieldRule.of(DAY_OF_MONTH), (Object)CalendarUnit.DAYS).appendElement(DAY_OF_YEAR, FieldRule.of(DAY_OF_YEAR), (Object)CalendarUnit.DAYS).appendElement(DAY_OF_WEEK, FieldRule.of(DAY_OF_WEEK), (Object)CalendarUnit.DAYS);
        MinguoCalendar.registerUnits((TimeAxis.Builder<CalendarUnit, MinguoCalendar>)builder);
        ENGINE = builder.build();
    }

    private static class Merger
    implements ChronoMerger<MinguoCalendar> {
        private Merger() {
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("roc", displayStyle, locale);
        }

        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        public MinguoCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)this.getDefaultStartOfDay());
            return (MinguoCalendar)Moment.from((UnixTime)timeSource.currentTime()).toGeneralTimestamp((Chronology)ENGINE, tZID, startOfDay).toDate();
        }

        @Deprecated
        public MinguoCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public MinguoCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            MinguoEra minguoEra;
            if (chronoEntity.contains((ChronoElement)PlainDate.COMPONENT)) {
                return new MinguoCalendar((PlainDate)chronoEntity.get((ChronoElement)PlainDate.COMPONENT));
            }
            if (chronoEntity.contains(ERA)) {
                minguoEra = (MinguoEra)((Object)chronoEntity.get(ERA));
            } else if (bl) {
                minguoEra = MinguoEra.ROC;
            } else {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Minguo era.");
                return null;
            }
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Minguo year.");
                return null;
            }
            int n2 = MinguoCalendar.toProlepticYear(minguoEra, n);
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n3 = ((Month)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n4 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n4 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(minguoEra, n, n3, n4)) {
                        return MinguoCalendar.of(minguoEra, n, n3, n4);
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Minguo date.");
                }
            } else {
                int n5 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n5 != Integer.MIN_VALUE) {
                    if (n5 > 0) {
                        int n6 = 1;
                        int n7 = 0;
                        while (n6 <= 12) {
                            int n8 = GregorianMath.getLengthOfMonth((int)n2, (int)n6);
                            if (n5 > n7 + n8) {
                                ++n6;
                                n7 += n8;
                                continue;
                            }
                            int n9 = n5 - n7;
                            return MinguoCalendar.of(minguoEra, n, n6, n9);
                        }
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Minguo date.");
                }
            }
            return null;
        }

        public ChronoDisplay preformat(MinguoCalendar minguoCalendar, AttributeQuery attributeQuery) {
            return minguoCalendar;
        }

        public Chronology<?> preparser() {
            return null;
        }
    }

    private static class MinguoUnitRule
    implements UnitRule<MinguoCalendar> {
        private final CalendarUnit unit;

        MinguoUnitRule(CalendarUnit calendarUnit) {
            this.unit = calendarUnit;
        }

        public MinguoCalendar addTo(MinguoCalendar minguoCalendar, long l) {
            return new MinguoCalendar((PlainDate)minguoCalendar.iso.plus(l, (Object)this.unit));
        }

        public long between(MinguoCalendar minguoCalendar, MinguoCalendar minguoCalendar2) {
            return this.unit.between((TimePoint)minguoCalendar.iso, (TimePoint)minguoCalendar2.iso);
        }
    }

    private static class FieldRule<V extends Comparable<V>>
    implements ElementRule<MinguoCalendar, V> {
        private final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V extends Comparable<V>> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        public V getValue(MinguoCalendar minguoCalendar) {
            Object object;
            if (this.element == ERA) {
                object = minguoCalendar.getEra();
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = minguoCalendar.getYear();
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = minguoCalendar.getMonth();
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = minguoCalendar.getDayOfMonth();
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = minguoCalendar.getDayOfYear();
            } else if (this.element.equals(DAY_OF_WEEK)) {
                object = minguoCalendar.getDayOfWeek();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public V getMinimum(MinguoCalendar minguoCalendar) {
            Object object;
            if (this.element == ERA) {
                object = MinguoEra.BEFORE_ROC;
            } else if (Integer.class.isAssignableFrom(this.element.getType())) {
                object = 1;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = Month.JANUARY;
            } else if (this.element.equals(DAY_OF_WEEK)) {
                object = Weekmodel.of((Locale)Locale.TAIWAN).localDayOfWeek().getDefaultMinimum();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public V getMaximum(MinguoCalendar minguoCalendar) {
            Object object;
            if (this.element == ERA) {
                object = MinguoEra.ROC;
            } else if (this.element.equals(YEAR_OF_ERA)) {
                MinguoEra minguoEra = minguoCalendar.getEra();
                object = minguoEra == MinguoEra.ROC ? Integer.valueOf(999998088) : Integer.valueOf(1000001911);
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = Month.DECEMBER;
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = minguoCalendar.iso.getMaximum((ChronoElement)PlainDate.DAY_OF_MONTH);
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = minguoCalendar.iso.getMaximum((ChronoElement)PlainDate.DAY_OF_YEAR);
            } else if (this.element.equals(DAY_OF_WEEK)) {
                object = Weekmodel.of((Locale)Locale.TAIWAN).localDayOfWeek().getDefaultMaximum();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        public boolean isValid(MinguoCalendar minguoCalendar, V v) {
            if (v == null) {
                return false;
            }
            if (this.element == ERA) {
                return v.equals((Object)minguoCalendar.getEra());
            }
            V v2 = this.getMinimum(minguoCalendar);
            V v3 = this.getMaximum(minguoCalendar);
            return v2.compareTo(v) <= 0 && v.compareTo(v3) <= 0;
        }

        public MinguoCalendar withValue(MinguoCalendar minguoCalendar, V v, boolean bl) {
            if (!this.isValid(minguoCalendar, v)) {
                throw new IllegalArgumentException("Out of range: " + v);
            }
            if (this.element == ERA) {
                return minguoCalendar;
            }
            if (this.element.equals(YEAR_OF_ERA)) {
                MinguoCalendar minguoCalendar2 = MinguoCalendar.of(minguoCalendar.getEra(), FieldRule.toNumber(v), minguoCalendar.getMonth(), 1);
                return (MinguoCalendar)minguoCalendar2.with(DAY_OF_MONTH, Math.min(minguoCalendar.getDayOfMonth(), minguoCalendar2.lengthOfMonth()));
            }
            if (this.element.equals(MONTH_OF_YEAR)) {
                PlainDate plainDate = (PlainDate)minguoCalendar.iso.with((ChronoElement)PlainDate.MONTH_OF_YEAR, Month.class.cast(v));
                return new MinguoCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_MONTH)) {
                PlainDate plainDate = (PlainDate)minguoCalendar.iso.with((ChronoElement)PlainDate.DAY_OF_MONTH, FieldRule.toNumber(v));
                return new MinguoCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_YEAR)) {
                PlainDate plainDate = (PlainDate)minguoCalendar.iso.with((ChronoElement)PlainDate.DAY_OF_YEAR, FieldRule.toNumber(v));
                return new MinguoCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_WEEK)) {
                PlainDate plainDate = (PlainDate)minguoCalendar.iso.with((ChronoElement)Weekmodel.of((Locale)Locale.TAIWAN).localDayOfWeek(), Weekday.class.cast(v));
                return new MinguoCalendar(plainDate);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        public ChronoElement<?> getChildAtFloor(MinguoCalendar minguoCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        public ChronoElement<?> getChildAtCeiling(MinguoCalendar minguoCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        private static int toNumber(Object object) {
            return (Integer)Integer.class.cast(object);
        }
    }

    private static class Transformer
    implements MonthBasedCalendarSystem<MinguoCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            try {
                if (calendarEra instanceof MinguoEra) {
                    int n4 = MinguoCalendar.toProlepticYear((MinguoEra)((Object)MinguoEra.class.cast(calendarEra)), n);
                    return n >= 1 && n4 <= 999999999 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= GregorianMath.getLengthOfMonth((int)n4, (int)n2);
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            try {
                int n3 = MinguoCalendar.toProlepticYear((MinguoEra)((Object)MinguoEra.class.cast(calendarEra)), n);
                return PlainDate.of((int)n3, (int)n2, (int)1).lengthOfMonth();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            try {
                int n2 = MinguoCalendar.toProlepticYear((MinguoEra)((Object)MinguoEra.class.cast(calendarEra)), n);
                return PlainDate.of((int)n2, (Month)Month.JANUARY, (int)1).lengthOfYear();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        public MinguoCalendar transform(long l) {
            return new MinguoCalendar(PlainDate.of((long)l, (EpochDays)EpochDays.UTC));
        }

        public long transform(MinguoCalendar minguoCalendar) {
            return (Long)minguoCalendar.iso.get((ChronoElement)EpochDays.UTC);
        }

        public long getMinimumSinceUTC() {
            return PlainDate.axis().getCalendarSystem().getMinimumSinceUTC();
        }

        public long getMaximumSinceUTC() {
            return PlainDate.axis().getCalendarSystem().getMaximumSinceUTC();
        }

        public List<CalendarEra> getEras() {
            MinguoEra minguoEra = MinguoEra.BEFORE_ROC;
            MinguoEra minguoEra2 = MinguoEra.ROC;
            return Arrays.asList(new CalendarEra[]{minguoEra, minguoEra2});
        }
    }
}

