/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.time4j.Meridiem;
import net.time4j.PlainTime;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.SPX;
import net.time4j.calendar.service.EthiopianExtension;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;

@CalendarType(value="ethiopic")
public final class EthiopianTime
extends TimePoint<Unit, EthiopianTime>
implements Temporal<EthiopianTime>,
LocalizedPatternSupport {
    private static final int ETHIOPIAN_HOUR_INDEX = 0;
    private static final int DIGITAL_HOUR_INDEX = 1;
    private static final int MINUTE_INDEX = 2;
    private static final int SECOND_INDEX = 3;
    public static final ChronoElement<PlainTime> ISO_TIME = PlainTime.COMPONENT;
    @FormattableElement(format="a")
    public static final ChronoElement<Meridiem> AM_PM_OF_DAY = PlainTime.AM_PM_OF_DAY;
    @FormattableElement(format="h")
    public static final ChronoElement<Integer> ETHIOPIAN_HOUR = EthiopianHour.ELEMENT;
    @FormattableElement(format="H")
    public static final ChronoElement<Integer> DIGITAL_HOUR_OF_DAY = PlainTime.DIGITAL_HOUR_OF_DAY;
    @FormattableElement(format="m")
    public static final ChronoElement<Integer> MINUTE_OF_HOUR = PlainTime.MINUTE_OF_HOUR;
    @FormattableElement(format="s")
    public static final ChronoElement<Integer> SECOND_OF_MINUTE = PlainTime.SECOND_OF_MINUTE;
    private static final EthiopianTime MIN = new EthiopianTime(6, 0, 0);
    private static final EthiopianTime MAX = new EthiopianTime(5, 59, 59);
    private static final TimeAxis<Unit, EthiopianTime> ENGINE;
    private static final long serialVersionUID = 3576122091324773241L;
    private final transient int hour24;
    private final transient int minute;
    private final transient int second;

    private EthiopianTime(int n, int n2, int n3) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("HOUR_OF_DAY out of range: " + n);
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("MINUTE_OF_HOUR out of range: " + n2);
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("SECOND_OF_MINUTE out of range: " + n3);
        }
        this.hour24 = n;
        this.minute = n2;
        this.second = n3;
    }

    public static EthiopianTime ofDay(int n, int n2) {
        return EthiopianTime.of(false, n, n2, 0);
    }

    public static EthiopianTime ofDay(int n, int n2, int n3) {
        return EthiopianTime.of(false, n, n2, n3);
    }

    public static EthiopianTime ofNight(int n, int n2) {
        return EthiopianTime.of(true, n, n2, 0);
    }

    public static EthiopianTime ofNight(int n, int n2, int n3) {
        return EthiopianTime.of(true, n, n2, n3);
    }

    public boolean isDay() {
        return this.hour24 >= 6 && this.hour24 < 18;
    }

    public boolean isNight() {
        return !this.isDay();
    }

    public int getHour() {
        int n = this.hour24 - 6;
        if (n < 0) {
            n += 12;
        } else if (n >= 12) {
            n -= 12;
        }
        return n == 0 ? 12 : n;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public boolean isAfter(EthiopianTime ethiopianTime) {
        return this.getTimeOfDay() > ethiopianTime.getTimeOfDay();
    }

    public boolean isBefore(EthiopianTime ethiopianTime) {
        return this.getTimeOfDay() < ethiopianTime.getTimeOfDay();
    }

    public boolean isSimultaneous(EthiopianTime ethiopianTime) {
        return this.getTimeOfDay() == ethiopianTime.getTimeOfDay();
    }

    public int compareTo(EthiopianTime ethiopianTime) {
        return this.getTimeOfDay() - ethiopianTime.getTimeOfDay();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EthiopianTime) {
            EthiopianTime ethiopianTime = (EthiopianTime)((Object)object);
            return this.getTimeOfDay() == ethiopianTime.getTimeOfDay();
        }
        return false;
    }

    public int hashCode() {
        return this.getTimeOfDay();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ethiopic-");
        stringBuilder.append(this.isDay() ? "day-" : "night-");
        stringBuilder.append(this.getHour());
        stringBuilder.append(':');
        if (this.minute < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.minute);
        stringBuilder.append(':');
        if (this.second < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.second);
        return stringBuilder.toString();
    }

    public PlainTime toISO() {
        return PlainTime.of((int)this.hour24, (int)this.minute, (int)this.second);
    }

    public static EthiopianTime from(PlainTime plainTime) {
        int n = plainTime.getHour();
        return new EthiopianTime(n == 24 ? 0 : n, plainTime.getMinute(), plainTime.getSecond());
    }

    public static TimeAxis<Unit, EthiopianTime> axis() {
        return ENGINE;
    }

    protected TimeAxis<Unit, EthiopianTime> getChronology() {
        return ENGINE;
    }

    protected EthiopianTime getContext() {
        return this;
    }

    private static EthiopianTime of(boolean bl, int n, int n2, int n3) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Hour out of range 1-12: " + n);
        }
        int n4 = n == 12 ? 0 : n;
        int n5 = n4 + 6;
        if (bl && (n5 += 12) >= 24) {
            n5 -= 24;
        }
        return new EthiopianTime(n5, n2, n3);
    }

    private int getTimeOfDay() {
        return this.second + this.minute * 60 + (this.hour24 < 6 ? this.hour24 + 24 : this.hour24) * 3600;
    }

    private static void registerUnits(TimeAxis.Builder<Unit, EthiopianTime> builder) {
        EnumSet<Unit> enumSet = EnumSet.allOf(Unit.class);
        for (Unit unit : Unit.values()) {
            builder.appendUnit((Object)unit, (UnitRule)new ClockUnitRule(unit), unit.getLength(), enumSet);
        }
    }

    private static void registerExtensions(TimeAxis.Builder<Unit, EthiopianTime> builder) {
        builder.appendExtension((ChronoExtension)new EthiopianExtension());
        for (ChronoExtension chronoExtension : PlainTime.axis().getExtensions()) {
            Set set = chronoExtension.getElements(Locale.ROOT, Attributes.empty());
            if (set.size() != 2) continue;
            for (ChronoElement chronoElement : set) {
                if (!chronoElement.name().endsWith("_DAY_PERIOD")) continue;
                builder.appendExtension(chronoExtension);
                return;
            }
        }
    }

    private Object writeReplace() {
        return new SPX((Object)this, 5);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        TimeAxis.Builder builder = TimeAxis.Builder.setUp(Unit.class, EthiopianTime.class, (ChronoMerger)new Merger(), (TimePoint)MIN, (TimePoint)MAX).appendElement(AM_PM_OF_DAY, (ElementRule)new MeridiemRule()).appendElement(ISO_TIME, (ElementRule)new TimeRule()).appendElement(ETHIOPIAN_HOUR, (ElementRule)new IntegerElementRule(0), (Object)Unit.HOURS).appendElement(DIGITAL_HOUR_OF_DAY, (ElementRule)new IntegerElementRule(1), (Object)Unit.HOURS).appendElement(MINUTE_OF_HOUR, (ElementRule)new IntegerElementRule(2), (Object)Unit.MINUTES).appendElement(SECOND_OF_MINUTE, (ElementRule)new IntegerElementRule(3), (Object)Unit.SECONDS);
        EthiopianTime.registerUnits((TimeAxis.Builder<Unit, EthiopianTime>)builder);
        EthiopianTime.registerExtensions((TimeAxis.Builder<Unit, EthiopianTime>)builder);
        ENGINE = builder.build();
    }

    private static class Merger
    implements ChronoMerger<EthiopianTime> {
        private Merger() {
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return displayStyle.getStyleValue() == 3 ? "h:mm a" : "h:mm:ss a";
        }

        public EthiopianTime createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            return EthiopianTime.from((PlainTime)PlainTime.axis().createFrom(timeSource, attributeQuery));
        }

        @Deprecated
        public EthiopianTime createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public EthiopianTime createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            PlainTime plainTime = (PlainTime)PlainTime.axis().createFrom(chronoEntity, attributeQuery, bl, false);
            if (plainTime != null) {
                return EthiopianTime.from(plainTime);
            }
            return null;
        }

        public ChronoDisplay preformat(EthiopianTime ethiopianTime, AttributeQuery attributeQuery) {
            return ethiopianTime;
        }

        public Chronology<?> preparser() {
            return null;
        }

        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MORNING;
        }
    }

    private static class IntegerElementRule
    implements ElementRule<EthiopianTime, Integer> {
        private final int index;

        IntegerElementRule(int n) {
            this.index = n;
        }

        public Integer getValue(EthiopianTime ethiopianTime) {
            switch (this.index) {
                case 0: {
                    return ethiopianTime.getHour();
                }
                case 1: {
                    return ethiopianTime.hour24;
                }
                case 2: {
                    return ethiopianTime.minute;
                }
                case 3: {
                    return ethiopianTime.second;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMinimum(EthiopianTime ethiopianTime) {
            switch (this.index) {
                case 0: {
                    return 1;
                }
                case 1: 
                case 2: 
                case 3: {
                    return 0;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMaximum(EthiopianTime ethiopianTime) {
            switch (this.index) {
                case 0: {
                    return 12;
                }
                case 1: {
                    return 23;
                }
                case 2: 
                case 3: {
                    return 59;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public boolean isValid(EthiopianTime ethiopianTime, Integer n) {
            return this.getMinimum(ethiopianTime).compareTo(n) <= 0 && this.getMaximum(ethiopianTime).compareTo(n) >= 0;
        }

        public EthiopianTime withValue(EthiopianTime ethiopianTime, Integer n, boolean bl) {
            int n2 = n;
            switch (this.index) {
                case 0: {
                    if (ethiopianTime.isDay()) {
                        return EthiopianTime.ofDay(n2, ethiopianTime.minute, ethiopianTime.second);
                    }
                    return EthiopianTime.ofNight(n2, ethiopianTime.minute, ethiopianTime.second);
                }
                case 1: {
                    return new EthiopianTime(n2, ethiopianTime.minute, ethiopianTime.second);
                }
                case 2: {
                    return new EthiopianTime(ethiopianTime.hour24, n2, ethiopianTime.second);
                }
                case 3: {
                    return new EthiopianTime(ethiopianTime.hour24, ethiopianTime.minute, n2);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public ChronoElement<?> getChildAtFloor(EthiopianTime ethiopianTime) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianTime ethiopianTime) {
            return null;
        }
    }

    private static class GeneralHourRule<T extends ChronoEntity<T>>
    implements ElementRule<T, Integer> {
        private GeneralHourRule() {
        }

        public Integer getValue(T t) {
            PlainTime plainTime = (PlainTime)t.get((ChronoElement)PlainTime.COMPONENT);
            return EthiopianTime.from(plainTime).getHour();
        }

        public Integer getMinimum(T t) {
            return 1;
        }

        public Integer getMaximum(T t) {
            return 12;
        }

        public boolean isValid(T t, Integer n) {
            PlainTime plainTime = (PlainTime)t.get((ChronoElement)PlainTime.COMPONENT);
            return EthiopianTime.from(plainTime).isValid(ETHIOPIAN_HOUR, n);
        }

        public T withValue(T t, Integer n, boolean bl) {
            PlainTime plainTime = (PlainTime)t.get((ChronoElement)PlainTime.COMPONENT);
            EthiopianTime ethiopianTime = (EthiopianTime)EthiopianTime.from(plainTime).with(ETHIOPIAN_HOUR, n);
            return (T)t.with((ChronoElement)PlainTime.COMPONENT, (Object)ethiopianTime.toISO());
        }

        public ChronoElement<?> getChildAtFloor(T t) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(T t) {
            return null;
        }
    }

    private static class MeridiemRule
    implements ElementRule<EthiopianTime, Meridiem> {
        private MeridiemRule() {
        }

        public Meridiem getValue(EthiopianTime ethiopianTime) {
            return ethiopianTime.hour24 < 12 ? Meridiem.AM : Meridiem.PM;
        }

        public EthiopianTime withValue(EthiopianTime ethiopianTime, Meridiem meridiem, boolean bl) {
            int n = ethiopianTime.hour24;
            if (meridiem == null) {
                throw new NullPointerException("Missing am/pm-value.");
            }
            if (meridiem == Meridiem.AM) {
                if (n >= 12) {
                    n -= 12;
                }
            } else if (meridiem == Meridiem.PM && n < 12) {
                n += 12;
            }
            return new EthiopianTime(n, ethiopianTime.minute, ethiopianTime.second);
        }

        public boolean isValid(EthiopianTime ethiopianTime, Meridiem meridiem) {
            return meridiem != null;
        }

        public Meridiem getMinimum(EthiopianTime ethiopianTime) {
            return Meridiem.AM;
        }

        public Meridiem getMaximum(EthiopianTime ethiopianTime) {
            return Meridiem.PM;
        }

        public ChronoElement<?> getChildAtFloor(EthiopianTime ethiopianTime) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianTime ethiopianTime) {
            return null;
        }
    }

    private static class TimeRule
    implements ElementRule<EthiopianTime, PlainTime> {
        private TimeRule() {
        }

        public PlainTime getValue(EthiopianTime ethiopianTime) {
            return ethiopianTime.toISO();
        }

        public PlainTime getMinimum(EthiopianTime ethiopianTime) {
            return PlainTime.midnightAtStartOfDay();
        }

        public PlainTime getMaximum(EthiopianTime ethiopianTime) {
            return PlainTime.of((int)23, (int)59, (int)59);
        }

        public boolean isValid(EthiopianTime ethiopianTime, PlainTime plainTime) {
            return plainTime != null;
        }

        public EthiopianTime withValue(EthiopianTime ethiopianTime, PlainTime plainTime, boolean bl) {
            return EthiopianTime.from(plainTime);
        }

        public ChronoElement<?> getChildAtFloor(EthiopianTime ethiopianTime) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianTime ethiopianTime) {
            return null;
        }
    }

    private static class EthiopianHour
    extends BasicElement<Integer> {
        private static final long serialVersionUID = -2095959121446847268L;
        static final EthiopianHour ELEMENT = new EthiopianHour();

        private EthiopianHour() {
            super("ETHIOPIAN_HOUR");
        }

        public Class<Integer> getType() {
            return Integer.class;
        }

        public char getSymbol() {
            return 'h';
        }

        public Integer getDefaultMinimum() {
            return 1;
        }

        public Integer getDefaultMaximum() {
            return 12;
        }

        public boolean isDateElement() {
            return false;
        }

        public boolean isTimeElement() {
            return true;
        }

        protected ChronoElement<?> getParent() {
            return PlainTime.CLOCK_HOUR_OF_AMPM;
        }

        protected <T extends ChronoEntity<T>> ElementRule<T, Integer> derive(Chronology<T> chronology) {
            if (PlainTime.axis().equals(chronology)) {
                return new GeneralHourRule();
            }
            return null;
        }

        protected boolean isSingleton() {
            return true;
        }

        private Object readResolve() {
            return ELEMENT;
        }
    }

    private static class ClockUnitRule
    implements UnitRule<EthiopianTime> {
        private final Unit unit;

        private ClockUnitRule(Unit unit) {
            this.unit = unit;
        }

        public EthiopianTime addTo(EthiopianTime ethiopianTime, long l) {
            long l2;
            if (l == 0L) {
                return ethiopianTime;
            }
            int n = ethiopianTime.minute;
            int n2 = ethiopianTime.second;
            switch (this.unit) {
                case HOURS: {
                    l2 = MathUtils.safeAdd((long)ethiopianTime.hour24, (long)l);
                    break;
                }
                case MINUTES: {
                    long l3 = MathUtils.safeAdd((long)ethiopianTime.minute, (long)l);
                    l2 = MathUtils.safeAdd((long)ethiopianTime.hour24, (long)MathUtils.floorDivide((long)l3, (int)60));
                    n = MathUtils.floorModulo((long)l3, (int)60);
                    break;
                }
                case SECONDS: {
                    long l4 = MathUtils.safeAdd((long)ethiopianTime.second, (long)l);
                    long l5 = MathUtils.safeAdd((long)ethiopianTime.minute, (long)MathUtils.floorDivide((long)l4, (int)60));
                    l2 = MathUtils.safeAdd((long)ethiopianTime.hour24, (long)MathUtils.floorDivide((long)l5, (int)60));
                    n = MathUtils.floorModulo((long)l5, (int)60);
                    n2 = MathUtils.floorModulo((long)l4, (int)60);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unit.name());
                }
            }
            int n3 = MathUtils.floorModulo((long)l2, (int)24);
            return new EthiopianTime(n3, n, n2);
        }

        public long between(EthiopianTime ethiopianTime, EthiopianTime ethiopianTime2) {
            long l;
            long l2 = ethiopianTime2.getTimeOfDay() - ethiopianTime.getTimeOfDay();
            switch (this.unit) {
                case HOURS: {
                    l = 3600L;
                    break;
                }
                case MINUTES: {
                    l = 60L;
                    break;
                }
                case SECONDS: {
                    l = 1L;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unit.name());
                }
            }
            return l2 / l;
        }
    }

    public static enum Unit implements ChronoUnit
    {
        HOURS(3600.0),
        MINUTES(60.0),
        SECONDS(1.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        public double getLength() {
            return this.length;
        }

        public boolean isCalendrical() {
            return false;
        }

        public int between(EthiopianTime ethiopianTime, EthiopianTime ethiopianTime2) {
            return (int)ethiopianTime.until(ethiopianTime2, (Object)this);
        }
    }
}

