/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EthiopianEra;
import net.time4j.calendar.EthiopianMonth;
import net.time4j.calendar.EthiopianTime;
import net.time4j.calendar.Evangelist;
import net.time4j.calendar.MonthBasedCalendarSystem;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.Tabot;
import net.time4j.calendar.service.EthiopianExtension;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.TextElement;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="ethiopic")
public final class EthiopianCalendar
extends Calendrical<Unit, EthiopianCalendar>
implements LocalizedPatternSupport {
    private static final int DELTA_ALEM_MIHRET = 5500;
    private static final long MIHRET_EPOCH;
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<EthiopianEra> ERA;
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, EthiopianCalendar> YEAR_OF_ERA;
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<EthiopianMonth, EthiopianCalendar> MONTH_OF_YEAR;
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, EthiopianCalendar> DAY_OF_MONTH;
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, EthiopianCalendar> DAY_OF_YEAR;
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, EthiopianCalendar> DAY_OF_WEEK;
    public static final ChronoElement<Evangelist> EVANGELIST;
    public static final TextElement<Tabot> TABOT;
    private static final MonthBasedCalendarSystem<EthiopianCalendar> CALSYS;
    private static final TimeAxis<Unit, EthiopianCalendar> ENGINE;
    private static final long serialVersionUID = -1632000525062084751L;
    private final transient int mihret;
    private final transient int emonth;
    private final transient int edom;

    private EthiopianCalendar(int n, int n2, int n3) {
        this.mihret = n;
        this.emonth = n2;
        this.edom = n3;
    }

    public static EthiopianCalendar of(EthiopianEra ethiopianEra, int n, EthiopianMonth ethiopianMonth, int n2) {
        return EthiopianCalendar.of(ethiopianEra, n, ethiopianMonth.getValue(), n2);
    }

    public static EthiopianCalendar of(EthiopianEra ethiopianEra, int n, int n2, int n3) {
        if (!CALSYS.isValid(ethiopianEra, n, n2, n3)) {
            throw new IllegalArgumentException("Invalid Ethiopian date: era=" + (Object)((Object)ethiopianEra) + ", year=" + n + ", month=" + n2 + ", day=" + n3);
        }
        return new EthiopianCalendar(EthiopianCalendar.mihret(ethiopianEra, n), n2, n3);
    }

    public EthiopianEra getEra() {
        return this.mihret < 1 ? EthiopianEra.AMETE_ALEM : EthiopianEra.AMETE_MIHRET;
    }

    @Deprecated
    public int getYearOfEra() {
        return this.getYear();
    }

    public int getYear() {
        return this.mihret < 1 ? this.mihret + 5500 : this.mihret;
    }

    public EthiopianMonth getMonth() {
        return EthiopianMonth.valueOf(this.emonth);
    }

    public int getDayOfMonth() {
        return this.edom;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform((Object)this);
        return Weekday.valueOf((int)(MathUtils.floorModulo((long)(l + 5L), (int)7) + 1));
    }

    public int getDayOfYear() {
        return (Integer)this.get(DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return CALSYS.getLengthOfMonth(this.getEra(), this.getYear(), this.emonth);
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return this.getYear() % 4 == 3;
    }

    public GeneralTimestamp<EthiopianCalendar> at(EthiopianTime ethiopianTime) {
        return GeneralTimestamp.of((Calendrical)this, (PlainTime)ethiopianTime.toISO());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EthiopianCalendar) {
            EthiopianCalendar ethiopianCalendar = (EthiopianCalendar)((Object)object);
            return this.edom == ethiopianCalendar.edom && this.emonth == ethiopianCalendar.emonth && this.mihret == ethiopianCalendar.mihret;
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.edom + 31 * this.emonth + 37 * this.mihret;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append((Object)this.getEra());
        stringBuilder.append('-');
        String string = String.valueOf(this.getYear());
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (this.emonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.emonth);
        stringBuilder.append('-');
        if (this.edom < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.edom);
        return stringBuilder.toString();
    }

    public static TimeAxis<Unit, EthiopianCalendar> axis() {
        return ENGINE;
    }

    protected TimeAxis<Unit, EthiopianCalendar> getChronology() {
        return ENGINE;
    }

    protected EthiopianCalendar getContext() {
        return this;
    }

    private static int mihret(CalendarEra calendarEra, int n) {
        return EthiopianEra.AMETE_ALEM.equals(calendarEra) ? n - 5500 : n;
    }

    private Object writeReplace() {
        return new SPX((Object)this, 4);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        PlainDate plainDate = ChronoHistory.PROLEPTIC_JULIAN.convert(HistoricDate.of((HistoricEra)HistoricEra.AD, (int)8, (int)8, (int)29));
        MIHRET_EPOCH = (Long)plainDate.get((ChronoElement)EpochDays.UTC);
        ERA = new StdEnumDateElement<EthiopianEra, EthiopianCalendar>("ERA", EthiopianCalendar.class, EthiopianEra.class, 'G');
        YEAR_OF_ERA = new StdIntegerDateElement<EthiopianCalendar>("YEAR_OF_ERA", EthiopianCalendar.class, 1, 9999, 'y', null, null);
        MONTH_OF_YEAR = new StdEnumDateElement<EthiopianMonth, EthiopianCalendar>("MONTH_OF_YEAR", EthiopianCalendar.class, EthiopianMonth.class, 'M');
        DAY_OF_MONTH = new StdIntegerDateElement<EthiopianCalendar>("DAY_OF_MONTH", EthiopianCalendar.class, 1, 30, 'd');
        DAY_OF_YEAR = new StdIntegerDateElement<EthiopianCalendar>("DAY_OF_YEAR", EthiopianCalendar.class, 1, 365, 'D');
        DAY_OF_WEEK = new StdWeekdayElement<EthiopianCalendar>(EthiopianCalendar.class);
        EVANGELIST = new StdEnumDateElement<Evangelist, EthiopianCalendar>("EVANGELIST", EthiopianCalendar.class, Evangelist.class, '\u0000', "generic");
        TABOT = Tabot.Element.TABOT;
        CALSYS = new Transformer();
        plainDate = TimeAxis.Builder.setUp(Unit.class, EthiopianCalendar.class, (ChronoMerger)new Merger(), CALSYS).appendElement(ERA, (ElementRule)new EraRule()).appendElement(YEAR_OF_ERA, (ElementRule)new IntegerRule(0), (Object)Unit.YEARS).appendElement(MONTH_OF_YEAR, (ElementRule)new MonthRule(), (Object)Unit.MONTHS).appendElement(DAY_OF_MONTH, (ElementRule)new IntegerRule(2), (Object)Unit.DAYS).appendElement(DAY_OF_YEAR, (ElementRule)new IntegerRule(3), (Object)Unit.DAYS).appendElement(DAY_OF_WEEK, (ElementRule)new WeekdayRule(), (Object)Unit.DAYS).appendElement(CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<EthiopianCalendar>(CALSYS, DAY_OF_YEAR)).appendElement(EVANGELIST, (ElementRule)new EvangelistRule()).appendElement(TABOT, (ElementRule)new TabotRule()).appendUnit((Object)Unit.YEARS, (UnitRule)new EthiopianUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit((Object)Unit.MONTHS, (UnitRule)new EthiopianUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit((Object)Unit.WEEKS, (UnitRule)new EthiopianUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit((Object)Unit.DAYS, (UnitRule)new EthiopianUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS)).appendExtension((ChronoExtension)new EthiopianExtension());
        ENGINE = plainDate.build();
    }

    private static class EthiopianUnitRule
    implements UnitRule<EthiopianCalendar> {
        private final Unit unit;

        EthiopianUnitRule(Unit unit) {
            this.unit = unit;
        }

        public EthiopianCalendar addTo(EthiopianCalendar ethiopianCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    l = MathUtils.safeMultiply((long)l, (long)13L);
                }
                case MONTHS: {
                    EthiopianEra ethiopianEra = EthiopianEra.AMETE_MIHRET;
                    long l2 = MathUtils.safeAdd((long)EthiopianUnitRule.ymValue(ethiopianCalendar), (long)l);
                    int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)l2, (int)13));
                    int n2 = MathUtils.floorModulo((long)l2, (int)13) + 1;
                    if (n < 1) {
                        ethiopianEra = EthiopianEra.AMETE_ALEM;
                        n += 5500;
                    }
                    int n3 = Math.min(ethiopianCalendar.edom, CALSYS.getLengthOfMonth(ethiopianEra, n, n2));
                    return EthiopianCalendar.of(ethiopianEra, n, n2, n3);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply((long)l, (long)7L);
                }
                case DAYS: {
                    long l3 = MathUtils.safeAdd((long)CALSYS.transform((Object)ethiopianCalendar), (long)l);
                    return (EthiopianCalendar)((Object)CALSYS.transform(l3));
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        public long between(EthiopianCalendar ethiopianCalendar, EthiopianCalendar ethiopianCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    return Unit.MONTHS.between(ethiopianCalendar, ethiopianCalendar2) / 13;
                }
                case MONTHS: {
                    long l = EthiopianUnitRule.ymValue(ethiopianCalendar2) - EthiopianUnitRule.ymValue(ethiopianCalendar);
                    if (l > 0L && ethiopianCalendar2.edom < ethiopianCalendar.edom) {
                        --l;
                    } else if (l < 0L && ethiopianCalendar2.edom > ethiopianCalendar.edom) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(ethiopianCalendar, ethiopianCalendar2) / 7;
                }
                case DAYS: {
                    return CALSYS.transform((Object)ethiopianCalendar2) - CALSYS.transform((Object)ethiopianCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int ymValue(EthiopianCalendar ethiopianCalendar) {
            return ethiopianCalendar.mihret * 13 + ethiopianCalendar.emonth - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<EthiopianCalendar> {
        private Merger() {
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("ethiopic", displayStyle, locale);
        }

        public EthiopianCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)this.getDefaultStartOfDay());
            return (EthiopianCalendar)Moment.from((UnixTime)timeSource.currentTime()).toGeneralTimestamp((Chronology)ENGINE, tZID, startOfDay).toDate();
        }

        @Deprecated
        public EthiopianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public EthiopianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Ethiopian year.");
                return null;
            }
            if (!chronoEntity.contains(ERA)) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Missing Ethiopian era.");
            }
            EthiopianEra ethiopianEra = (EthiopianEra)((Object)chronoEntity.get(ERA));
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2 = ((EthiopianMonth)((Object)chronoEntity.get(MONTH_OF_YEAR))).getValue();
                int n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(ethiopianEra, n, n2, n3)) {
                        return EthiopianCalendar.of(ethiopianEra, n, n2, n3);
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Ethiopian date.");
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 > 0) {
                        int n5 = 1;
                        int n6 = 0;
                        while (n5 <= 13) {
                            int n7 = CALSYS.getLengthOfMonth(ethiopianEra, n, n5);
                            if (n4 > n6 + n7) {
                                ++n5;
                                n6 += n7;
                                continue;
                            }
                            return EthiopianCalendar.of(ethiopianEra, n, n5, n4 - n6);
                        }
                    }
                    chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)"Invalid Ethiopian date.");
                }
            }
            return null;
        }

        public ChronoDisplay preformat(EthiopianCalendar ethiopianCalendar, AttributeQuery attributeQuery) {
            return ethiopianCalendar;
        }

        public Chronology<?> preparser() {
            return null;
        }

        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MORNING;
        }
    }

    private static class WeekdayRule
    implements ElementRule<EthiopianCalendar, Weekday> {
        private WeekdayRule() {
        }

        public Weekday getValue(EthiopianCalendar ethiopianCalendar) {
            return ethiopianCalendar.getDayOfWeek();
        }

        public Weekday getMinimum(EthiopianCalendar ethiopianCalendar) {
            return Weekday.SUNDAY;
        }

        public Weekday getMaximum(EthiopianCalendar ethiopianCalendar) {
            return Weekday.SATURDAY;
        }

        public boolean isValid(EthiopianCalendar ethiopianCalendar, Weekday weekday) {
            return weekday != null;
        }

        public EthiopianCalendar withValue(EthiopianCalendar ethiopianCalendar, Weekday weekday, boolean bl) {
            Weekmodel weekmodel = Weekmodel.of((Weekday)Weekday.SUNDAY, (int)1);
            int n = ethiopianCalendar.getDayOfWeek().getValue(weekmodel);
            int n2 = weekday.getValue(weekmodel);
            return (EthiopianCalendar)ethiopianCalendar.plus(CalendarDays.of((long)(n2 - n)));
        }

        public ChronoElement<?> getChildAtFloor(EthiopianCalendar ethiopianCalendar) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianCalendar ethiopianCalendar) {
            return null;
        }
    }

    private static class TabotRule
    implements ElementRule<EthiopianCalendar, Tabot> {
        private TabotRule() {
        }

        public Tabot getValue(EthiopianCalendar ethiopianCalendar) {
            return Tabot.of(ethiopianCalendar.getDayOfMonth());
        }

        public Tabot getMinimum(EthiopianCalendar ethiopianCalendar) {
            return Tabot.of(1);
        }

        public Tabot getMaximum(EthiopianCalendar ethiopianCalendar) {
            return Tabot.of((Integer)ethiopianCalendar.getMaximum(DAY_OF_MONTH));
        }

        public boolean isValid(EthiopianCalendar ethiopianCalendar, Tabot tabot) {
            return tabot != null && tabot.compareTo(this.getMaximum(ethiopianCalendar)) <= 0;
        }

        public EthiopianCalendar withValue(EthiopianCalendar ethiopianCalendar, Tabot tabot, boolean bl) {
            if (tabot == null) {
                throw new IllegalArgumentException("Missing tabot.");
            }
            return (EthiopianCalendar)ethiopianCalendar.with(DAY_OF_MONTH, tabot.getDayOfMonth());
        }

        public ChronoElement<?> getChildAtFloor(EthiopianCalendar ethiopianCalendar) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianCalendar ethiopianCalendar) {
            return null;
        }
    }

    private static class EvangelistRule
    implements ElementRule<EthiopianCalendar, Evangelist> {
        private EvangelistRule() {
        }

        public Evangelist getValue(EthiopianCalendar ethiopianCalendar) {
            return Evangelist.values()[(ethiopianCalendar.getYear() + 3) % 4];
        }

        public Evangelist getMinimum(EthiopianCalendar ethiopianCalendar) {
            return Evangelist.MATTHEW;
        }

        public Evangelist getMaximum(EthiopianCalendar ethiopianCalendar) {
            return ethiopianCalendar.mihret >= 9997 ? Evangelist.LUKE : Evangelist.JOHN;
        }

        public boolean isValid(EthiopianCalendar ethiopianCalendar, Evangelist evangelist) {
            return evangelist != null && evangelist.compareTo(this.getMaximum(ethiopianCalendar)) <= 0;
        }

        public EthiopianCalendar withValue(EthiopianCalendar ethiopianCalendar, Evangelist evangelist, boolean bl) {
            if (evangelist == null) {
                throw new IllegalArgumentException("Missing evangelist.");
            }
            int n = evangelist.ordinal() - this.getValue(ethiopianCalendar).ordinal();
            return (EthiopianCalendar)ethiopianCalendar.plus(n, (Object)Unit.YEARS);
        }

        public ChronoElement<?> getChildAtFloor(EthiopianCalendar ethiopianCalendar) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianCalendar ethiopianCalendar) {
            return null;
        }
    }

    private static class EraRule
    implements ElementRule<EthiopianCalendar, EthiopianEra> {
        private EraRule() {
        }

        public EthiopianEra getValue(EthiopianCalendar ethiopianCalendar) {
            return ethiopianCalendar.getEra();
        }

        public EthiopianEra getMinimum(EthiopianCalendar ethiopianCalendar) {
            return EthiopianEra.AMETE_ALEM;
        }

        public EthiopianEra getMaximum(EthiopianCalendar ethiopianCalendar) {
            return EthiopianEra.AMETE_MIHRET;
        }

        public boolean isValid(EthiopianCalendar ethiopianCalendar, EthiopianEra ethiopianEra) {
            return ethiopianEra != null;
        }

        public EthiopianCalendar withValue(EthiopianCalendar ethiopianCalendar, EthiopianEra ethiopianEra, boolean bl) {
            if (ethiopianEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return ethiopianCalendar;
        }

        public ChronoElement<?> getChildAtFloor(EthiopianCalendar ethiopianCalendar) {
            return YEAR_OF_ERA;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianCalendar ethiopianCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<EthiopianCalendar, EthiopianMonth> {
        private MonthRule() {
        }

        public EthiopianMonth getValue(EthiopianCalendar ethiopianCalendar) {
            return ethiopianCalendar.getMonth();
        }

        public EthiopianMonth getMinimum(EthiopianCalendar ethiopianCalendar) {
            return EthiopianMonth.MESKEREM;
        }

        public EthiopianMonth getMaximum(EthiopianCalendar ethiopianCalendar) {
            return EthiopianMonth.PAGUMEN;
        }

        public boolean isValid(EthiopianCalendar ethiopianCalendar, EthiopianMonth ethiopianMonth) {
            return ethiopianMonth != null;
        }

        public EthiopianCalendar withValue(EthiopianCalendar ethiopianCalendar, EthiopianMonth ethiopianMonth, boolean bl) {
            int n = ethiopianMonth.getValue();
            int n2 = CALSYS.getLengthOfMonth(ethiopianCalendar.getEra(), ethiopianCalendar.getYear(), n);
            int n3 = Math.min(ethiopianCalendar.edom, n2);
            return new EthiopianCalendar(ethiopianCalendar.mihret, n, n3);
        }

        public ChronoElement<?> getChildAtFloor(EthiopianCalendar ethiopianCalendar) {
            return DAY_OF_MONTH;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianCalendar ethiopianCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements ElementRule<EthiopianCalendar, Integer> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        public Integer getValue(EthiopianCalendar ethiopianCalendar) {
            switch (this.index) {
                case 0: {
                    return ethiopianCalendar.getYear();
                }
                case 2: {
                    return ethiopianCalendar.edom;
                }
                case 3: {
                    int n = 0;
                    for (int i = 1; i < ethiopianCalendar.emonth; ++i) {
                        n += CALSYS.getLengthOfMonth(ethiopianCalendar.getEra(), ethiopianCalendar.getYear(), i);
                    }
                    return n + ethiopianCalendar.edom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMinimum(EthiopianCalendar ethiopianCalendar) {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public Integer getMaximum(EthiopianCalendar ethiopianCalendar) {
            switch (this.index) {
                case 0: {
                    return ethiopianCalendar.getEra() == EthiopianEra.AMETE_ALEM ? 15499 : 9999;
                }
                case 2: {
                    return CALSYS.getLengthOfMonth(ethiopianCalendar.getEra(), ethiopianCalendar.getYear(), ethiopianCalendar.emonth);
                }
                case 3: {
                    return CALSYS.getLengthOfYear(ethiopianCalendar.getEra(), ethiopianCalendar.getYear());
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public boolean isValid(EthiopianCalendar ethiopianCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            Integer n2 = this.getMinimum(ethiopianCalendar);
            Integer n3 = this.getMaximum(ethiopianCalendar);
            return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
        }

        public EthiopianCalendar withValue(EthiopianCalendar ethiopianCalendar, Integer n, boolean bl) {
            if (!this.isValid(ethiopianCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    EthiopianEra ethiopianEra = ethiopianCalendar.getEra();
                    int n2 = n;
                    int n3 = CALSYS.getLengthOfMonth(ethiopianEra, n2, ethiopianCalendar.emonth);
                    int n4 = Math.min(ethiopianCalendar.edom, n3);
                    return EthiopianCalendar.of(ethiopianEra, n2, ethiopianCalendar.emonth, n4);
                }
                case 2: {
                    return new EthiopianCalendar(ethiopianCalendar.mihret, ethiopianCalendar.emonth, n);
                }
                case 3: {
                    int n5 = n - this.getValue(ethiopianCalendar);
                    return (EthiopianCalendar)ethiopianCalendar.plus(CalendarDays.of((long)n5));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        public ChronoElement<?> getChildAtFloor(EthiopianCalendar ethiopianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(EthiopianCalendar ethiopianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }
    }

    private static class Transformer
    implements MonthBasedCalendarSystem<EthiopianCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            return calendarEra instanceof EthiopianEra && n >= 1 && n <= (EthiopianEra.AMETE_ALEM.equals(calendarEra) ? 15499 : 9999) && n2 >= 1 && n2 <= 13 && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            Transformer.checkEra(calendarEra);
            if (n >= 1 && n <= (EthiopianEra.AMETE_ALEM.equals(calendarEra) ? 15499 : 9999) && n2 >= 1 && n2 <= 13) {
                if (n2 <= 12) {
                    return 30;
                }
                return n % 4 == 3 ? 6 : 5;
            }
            throw new IllegalArgumentException("Out of bounds: era=" + calendarEra + ", year=" + n + ", month=" + n2);
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            Transformer.checkEra(calendarEra);
            if (n >= 1 && n <= (EthiopianEra.AMETE_ALEM.equals(calendarEra) ? 15499 : 9999)) {
                return n % 4 == 3 ? 366 : 365;
            }
            throw new IllegalArgumentException("Out of bounds: era=" + calendarEra + ", year=" + n);
        }

        public EthiopianCalendar transform(long l) {
            int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)MathUtils.safeAdd((long)MathUtils.safeMultiply((long)4L, (long)MathUtils.safeSubtract((long)l, (long)MIHRET_EPOCH)), (long)1463L), (int)1461));
            int n2 = MathUtils.safeCast((long)this.transform(new EthiopianCalendar(n, 1, 1)));
            int n3 = 1 + MathUtils.safeCast((long)MathUtils.floorDivide((long)(l - (long)n2), (int)30));
            int n4 = MathUtils.safeCast((long)this.transform(new EthiopianCalendar(n, n3, 1)));
            int n5 = 1 + MathUtils.safeCast((long)MathUtils.safeSubtract((long)l, (long)n4));
            EthiopianEra ethiopianEra = EthiopianEra.AMETE_MIHRET;
            if (n < 1) {
                n += 5500;
                ethiopianEra = EthiopianEra.AMETE_ALEM;
            }
            return EthiopianCalendar.of(ethiopianEra, n, n3, n5);
        }

        public long transform(EthiopianCalendar ethiopianCalendar) {
            return MIHRET_EPOCH - 1L + (long)(365 * (ethiopianCalendar.mihret - 1)) + (long)MathUtils.floorDivide((int)ethiopianCalendar.mihret, (int)4) + (long)(30 * (ethiopianCalendar.emonth - 1)) + (long)ethiopianCalendar.edom;
        }

        public long getMinimumSinceUTC() {
            EthiopianCalendar ethiopianCalendar = new EthiopianCalendar(-5499, 1, 1);
            return this.transform(ethiopianCalendar);
        }

        public long getMaximumSinceUTC() {
            EthiopianCalendar ethiopianCalendar = new EthiopianCalendar(9999, 13, 6);
            return this.transform(ethiopianCalendar);
        }

        public List<CalendarEra> getEras() {
            EthiopianEra ethiopianEra = EthiopianEra.AMETE_ALEM;
            EthiopianEra ethiopianEra2 = EthiopianEra.AMETE_MIHRET;
            return Arrays.asList(new CalendarEra[]{ethiopianEra, ethiopianEra2});
        }

        private static void checkEra(CalendarEra calendarEra) {
            if (!(calendarEra instanceof EthiopianEra)) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.15576E7),
        MONTHS(2592000.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        public double getLength() {
            return this.length;
        }

        public boolean isCalendrical() {
            return true;
        }

        public int between(EthiopianCalendar ethiopianCalendar, EthiopianCalendar ethiopianCalendar2) {
            return (int)ethiopianCalendar.until((TimePoint)ethiopianCalendar2, (Object)this);
        }
    }
}

