/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import java.util.Collections;
import java.util.Set;
import net.time4j.Duration;
import net.time4j.PlainTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeLine;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.ClockInterval;
import net.time4j.range.IntervalFactory;

final class ClockIntervalFactory
implements IntervalFactory<PlainTime, ClockInterval> {
    static final ClockIntervalFactory INSTANCE = new ClockIntervalFactory();

    private ClockIntervalFactory() {
    }

    @Override
    public ClockInterval between(Boundary<PlainTime> boundary, Boundary<PlainTime> boundary2) {
        return new ClockInterval(boundary, boundary2);
    }

    @Override
    public PlainTime plusPeriod(PlainTime plainTime, String string, ParseLog parseLog, AttributeQuery attributeQuery) {
        try {
            return (PlainTime)plainTime.plus(Duration.parseClockPeriod(string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public PlainTime minusPeriod(PlainTime plainTime, String string, ParseLog parseLog, AttributeQuery attributeQuery) {
        try {
            return (PlainTime)plainTime.minus(Duration.parseClockPeriod(string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Set<ChronoElement<?>> stdElements(ChronoEntity<?> chronoEntity) {
        return Collections.emptySet();
    }

    @Override
    public TimeLine<PlainTime> getTimeLine() {
        return PlainTime.axis();
    }

    @Override
    public boolean supportsInfinity() {
        return false;
    }
}

