/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.tz.NameStyle;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZoneModelProvider;
import net.time4j.tz.ZoneNameProvider;
import net.time4j.tz.other.MilitaryZone;

public class MilZoneProviderSPI
implements ZoneModelProvider,
ZoneNameProvider {
    @Override
    public Set<String> getAvailableIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (MilitaryZone militaryZone : MilitaryZone.values()) {
            hashSet.add(militaryZone.canonical());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Map<String, String> getAliases() {
        return Collections.emptyMap();
    }

    @Override
    public String getFallback() {
        return "";
    }

    @Override
    public String getName() {
        return "MILITARY";
    }

    @Override
    public String getLocation() {
        return "";
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public TransitionHistory load(String string) {
        return Timezone.of(ZonalOffset.parse(string)).getHistory();
    }

    @Override
    public Set<String> getPreferredIDs(Locale locale, boolean bl) {
        return this.getAvailableIDs();
    }

    @Override
    public String getDisplayName(String string, NameStyle nameStyle, Locale locale) {
        ZonalOffset zonalOffset = ZonalOffset.parse(string);
        for (MilitaryZone militaryZone : MilitaryZone.values()) {
            if (!militaryZone.getOffset().equals(zonalOffset)) continue;
            return nameStyle.isAbbreviation() ? militaryZone.getSymbol() : militaryZone.toString();
        }
        return "";
    }
}

