/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Optional;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeLine;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalCreator;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;

public final class SimpleInterval<T>
implements ChronoInterval<T>,
Serializable {
    private static final Factory<Date> OLD_DATE_FACTORY = new Factory(new TraditionalTimeLine());
    private static final Factory<Instant> INSTANT_FACTORY = new Factory(new InstantTimeLine());
    private static final long serialVersionUID = -3508139527445140226L;
    private final Boundary<T> start;
    private final Boundary<T> end;
    private final TimeLine<T> timeLine;

    SimpleInterval(T t, T t2, TimeLine<T> timeLine) {
        if (timeLine == null) {
            throw new NullPointerException();
        }
        if (t != null && t2 != null && timeLine.compare(t, t2) > 0) {
            throw new IllegalArgumentException("Start after end: " + t + "/" + t2);
        }
        Boundary boundary = this.start = t == null ? Boundary.infinitePast() : Boundary.ofClosed(t);
        this.end = t2 == null ? Boundary.infiniteFuture() : (timeLine.isCalendrical() ? Boundary.ofClosed(t2) : Boundary.ofOpen(t2));
        this.timeLine = timeLine;
    }

    SimpleInterval(Boundary<T> boundary, Boundary<T> boundary2, TimeLine<T> timeLine) {
        this.start = boundary;
        this.end = boundary2;
        this.timeLine = timeLine;
    }

    public static SimpleInterval<Date> between(Date date, Date date2) {
        return OLD_DATE_FACTORY.between(date, date2);
    }

    public static SimpleInterval<Instant> between(Instant instant, Instant instant2) {
        return INSTANT_FACTORY.between(instant, instant2);
    }

    public static SimpleInterval<Date> since(Date date) {
        return OLD_DATE_FACTORY.since(date);
    }

    public static SimpleInterval<Instant> since(Instant instant) {
        return INSTANT_FACTORY.since(instant);
    }

    public static SimpleInterval<Date> until(Date date) {
        return OLD_DATE_FACTORY.until(date);
    }

    public static SimpleInterval<Instant> until(Instant instant) {
        return INSTANT_FACTORY.until(instant);
    }

    public static Factory<Date> onTraditionalTimeLine() {
        return OLD_DATE_FACTORY;
    }

    public static Factory<Instant> onInstantTimeLine() {
        return INSTANT_FACTORY;
    }

    public static <T> Factory<T> on(TimeLine<T> timeLine) {
        if (timeLine instanceof TimeAxis) {
            Class clazz = ((TimeAxis)TimeAxis.class.cast(timeLine)).getChronoType();
            return new Factory(new SerializableTimeLine(timeLine, clazz));
        }
        return new Factory(timeLine);
    }

    @Override
    public Boundary<T> getStart() {
        return this.start;
    }

    @Override
    public Boundary<T> getEnd() {
        return this.end;
    }

    @Override
    public boolean isEmpty() {
        if (!this.isFinite()) {
            return false;
        }
        return this.end.isOpen() && this.timeLine.compare(this.start.getTemporal(), this.end.getTemporal()) == 0;
    }

    @Override
    public boolean contains(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (!this.start.isInfinite() && this.timeLine.compare(t, this.start.getTemporal()) < 0) {
            return false;
        }
        if (!this.end.isInfinite()) {
            int n = this.timeLine.compare(this.end.getTemporal(), t);
            return this.end.isClosed() ? n >= 0 : n > 0;
        }
        return true;
    }

    @Override
    public boolean contains(ChronoInterval<T> chronoInterval) {
        if (!chronoInterval.isFinite()) {
            return false;
        }
        T t = this.start.getTemporal();
        T t2 = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            t2 = this.timeLine.stepForward(t2);
        }
        if (t2 == null || t != null && this.timeLine.compare(t, t2) > 0) {
            return false;
        }
        T t3 = this.end.getTemporal();
        if (t3 == null) {
            return true;
        }
        T t4 = chronoInterval.getEnd().getTemporal();
        if (chronoInterval.getEnd().isOpen() && this.timeLine.compare(t2, t4) == 0) {
            if (this.end.isOpen()) {
                t3 = this.timeLine.stepBackwards(t3);
            }
            return t3 != null && this.timeLine.compare(t2, t3) <= 0;
        }
        if (this.timeLine.isCalendrical()) {
            if (chronoInterval.getEnd().isOpen()) {
                t4 = this.timeLine.stepBackwards(t4);
            }
            return t4 != null && this.timeLine.compare(t3, t4) >= 0;
        }
        if (chronoInterval.getEnd().isClosed() && (t4 = this.timeLine.stepForward(t4)) == null) {
            return false;
        }
        return this.timeLine.compare(t3, t4) >= 0;
    }

    @Override
    public boolean isAfter(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.start.isInfinite()) {
            return false;
        }
        return this.timeLine.compare(this.start.getTemporal(), t) > 0;
    }

    @Override
    public boolean isBefore(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.end.isInfinite()) {
            return false;
        }
        if (this.end.isOpen()) {
            return this.timeLine.compare(this.end.getTemporal(), t) <= 0;
        }
        return this.timeLine.compare(this.end.getTemporal(), t) < 0;
    }

    @Override
    public boolean isBefore(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        T t = this.end.getTemporal();
        T t2 = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            t2 = this.timeLine.stepForward(t2);
        }
        if (t2 == null) {
            return true;
        }
        if (this.end.isOpen()) {
            return this.timeLine.compare(t, t2) <= 0;
        }
        return this.timeLine.compare(t, t2) < 0;
    }

    @Override
    public boolean abuts(ChronoInterval<T> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return false;
        }
        T t = this.start.getTemporal();
        T t2 = chronoInterval.getStart().getTemporal();
        if (t2 != null && chronoInterval.getStart().isOpen()) {
            t2 = this.timeLine.stepForward(t2);
        }
        T t3 = this.end.getTemporal();
        T t4 = chronoInterval.getEnd().getTemporal();
        if (t3 != null && this.end.isClosed()) {
            t3 = this.timeLine.stepForward(t3);
        }
        if (t4 != null && chronoInterval.getEnd().isClosed()) {
            t4 = this.timeLine.stepForward(t4);
        }
        if (t3 == null || t2 == null) {
            return t != null && t4 != null && this.timeLine.compare(t, t4) == 0;
        }
        if (t == null || t4 == null) {
            return this.timeLine.compare(t3, t2) == 0;
        }
        return this.timeLine.compare(t3, t2) == 0 ^ this.timeLine.compare(t, t4) == 0;
    }

    public Optional<SimpleInterval<T>> findIntersection(ChronoInterval<T> chronoInterval) {
        Boundary<Object> boundary;
        T t;
        Object object;
        Boundary<T> boundary2;
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return Optional.empty();
        }
        if (this.start.isInfinite()) {
            boundary2 = chronoInterval.getStart();
        } else if (chronoInterval.getStart().isInfinite()) {
            boundary2 = this.start;
        } else {
            object = this.start.getTemporal();
            t = chronoInterval.getStart().getTemporal();
            if (chronoInterval.getStart().isOpen()) {
                t = this.timeLine.stepForward(t);
            }
            if (object == null || t == null) {
                return Optional.empty();
            }
            Boundary<Object> boundary3 = boundary2 = this.timeLine.compare(object, t) < 0 ? Boundary.ofClosed(t) : Boundary.ofClosed(object);
        }
        if (this.end.isInfinite()) {
            boundary = chronoInterval.getEnd();
        } else if (chronoInterval.getEnd().isInfinite()) {
            boundary = this.end;
        } else {
            object = this.end.getTemporal();
            t = chronoInterval.getEnd().getTemporal();
            if (this.timeLine.isCalendrical()) {
                if (this.end.isOpen()) {
                    object = this.timeLine.stepBackwards(object);
                }
                if (chronoInterval.getEnd().isOpen()) {
                    t = this.timeLine.stepBackwards(t);
                }
                boundary = this.timeLine.compare(object, t) < 0 ? Boundary.ofClosed(object) : Boundary.ofClosed(t);
            } else {
                if (this.end.isClosed()) {
                    object = this.timeLine.stepForward(object);
                }
                if (chronoInterval.getEnd().isClosed()) {
                    t = this.timeLine.stepForward(t);
                }
                if (object == null) {
                    boundary = t == null ? Boundary.infiniteFuture() : Boundary.ofOpen(t);
                } else if (t == null) {
                    boundary = Boundary.ofOpen(object);
                } else {
                    Boundary<Object> boundary4 = boundary = this.timeLine.compare(object, t) < 0 ? Boundary.ofOpen(object) : Boundary.ofOpen(t);
                }
            }
        }
        if (this.isAfter(boundary2, boundary)) {
            return Optional.empty();
        }
        object = new SimpleInterval<T>(boundary2, boundary, this.timeLine);
        return ((SimpleInterval)object).isEmpty() ? Optional.empty() : Optional.of(object);
    }

    public String print(ChronoPrinter<T> chronoPrinter) {
        return this.print(chronoPrinter, IsoInterval.getIntervalPattern(chronoPrinter));
    }

    public String print(ChronoPrinter<T> chronoPrinter, String string) {
        AttributeQuery attributeQuery = chronoPrinter.getAttributes();
        StringBuilder stringBuilder = new StringBuilder(32);
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '{' && n + 2 < n2 && string.charAt(n + 2) == '}') {
                char c2 = string.charAt(n + 1);
                if (c2 == '0') {
                    if (this.start.isInfinite()) {
                        stringBuilder.append("-\u221e");
                    } else {
                        chronoPrinter.print(this.start.getTemporal(), stringBuilder, attributeQuery);
                    }
                    n += 3;
                    continue;
                }
                if (c2 == '1') {
                    if (this.end.isInfinite()) {
                        stringBuilder.append("+\u221e");
                    } else {
                        chronoPrinter.print(this.end.getTemporal(), stringBuilder, attributeQuery);
                    }
                    n += 3;
                    continue;
                }
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimpleInterval) {
            SimpleInterval simpleInterval = (SimpleInterval)object;
            return this.start.equals(simpleInterval.start) && this.end.equals(simpleInterval.end) && this.timeLine.equals(simpleInterval.timeLine);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.start.isInfinite()) {
            stringBuilder.append("(-\u221e");
        } else {
            stringBuilder.append('[');
            stringBuilder.append(this.start.getTemporal());
        }
        stringBuilder.append('/');
        if (this.end.isInfinite()) {
            stringBuilder.append("+\u221e)");
        } else {
            stringBuilder.append(this.end.getTemporal());
            if (this.end.isClosed()) {
                stringBuilder.append(']');
            } else {
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    private boolean isAfter(Boundary<T> boundary, Boundary<T> boundary2) {
        if (boundary.isInfinite() || boundary2.isInfinite()) {
            return false;
        }
        return this.timeLine.compare(boundary.getTemporal(), boundary2.getTemporal()) > 0;
    }

    private static class SerializableTimeLine<T>
    implements TimeLine<T>,
    Serializable {
        private final transient TimeLine<T> axis;
        private final Class<?> chronoType;

        private SerializableTimeLine(TimeLine<T> timeLine, Class<?> clazz) {
            this.axis = timeLine;
            this.chronoType = clazz;
        }

        @Override
        public T stepForward(T t) {
            return this.axis.stepForward(t);
        }

        @Override
        public T stepBackwards(T t) {
            return this.axis.stepBackwards(t);
        }

        @Override
        public boolean isCalendrical() {
            return this.axis.isCalendrical();
        }

        @Override
        public int compare(T t, T t2) {
            return this.axis.compare(t, t2);
        }

        @Override
        public T getMinimum() {
            return this.axis.getMinimum();
        }

        @Override
        public T getMaximum() {
            return this.axis.getMaximum();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SerializableTimeLine) {
                SerializableTimeLine serializableTimeLine = (SerializableTimeLine)object;
                return this.chronoType == serializableTimeLine.chronoType;
            }
            return false;
        }

        public int hashCode() {
            return this.chronoType.hashCode();
        }

        private Object readResolve() throws ObjectStreamException {
            Chronology<?> chronology = Chronology.lookup(this.chronoType);
            TimeAxis timeAxis = (TimeAxis)TimeAxis.class.cast(chronology);
            return new SerializableTimeLine<T>(timeAxis, chronology.getChronoType());
        }
    }

    private static class InstantTimeLine
    implements TimeLine<Instant>,
    Serializable {
        private InstantTimeLine() {
        }

        @Override
        public Instant stepForward(Instant instant) {
            if (instant.equals(Instant.MAX)) {
                return null;
            }
            return instant.plus(1L, ChronoUnit.NANOS);
        }

        @Override
        public Instant stepBackwards(Instant instant) {
            if (instant.equals(Instant.MIN)) {
                return null;
            }
            return instant.minus(1L, ChronoUnit.NANOS);
        }

        @Override
        public int compare(Instant instant, Instant instant2) {
            return instant.compareTo(instant2);
        }

        @Override
        public Instant getMinimum() {
            return Instant.MIN;
        }

        @Override
        public Instant getMaximum() {
            return Instant.MAX;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANT_FACTORY.getTimeLine();
        }
    }

    private static class TraditionalTimeLine
    implements TimeLine<Date>,
    Serializable {
        private TraditionalTimeLine() {
        }

        @Override
        public Date stepForward(Date date) {
            if (date.getTime() == Long.MAX_VALUE) {
                return null;
            }
            return new Date(date.getTime() + 1L);
        }

        @Override
        public Date stepBackwards(Date date) {
            if (date.getTime() == Long.MIN_VALUE) {
                return null;
            }
            return new Date(date.getTime() - 1L);
        }

        @Override
        public boolean isCalendrical() {
            return false;
        }

        @Override
        public int compare(Date date, Date date2) {
            return date.compareTo(date2);
        }

        @Override
        public Date getMinimum() {
            return new Date(Long.MIN_VALUE);
        }

        @Override
        public Date getMaximum() {
            return new Date(Long.MAX_VALUE);
        }

        private Object readResolve() throws ObjectStreamException {
            return OLD_DATE_FACTORY.getTimeLine();
        }
    }

    public static class Factory<T> {
        private final TimeLine<T> timeLine;

        private Factory(TimeLine<T> timeLine) {
            if (timeLine == null) {
                throw new NullPointerException("Missing timeline.");
            }
            this.timeLine = timeLine;
        }

        public SimpleInterval<T> between(T t, T t2) {
            if (t == null) {
                throw new NullPointerException("Missing start.");
            }
            if (t2 == null) {
                throw new NullPointerException("Missing end.");
            }
            return new SimpleInterval<T>(t, t2, this.timeLine);
        }

        public SimpleInterval<T> since(T t) {
            if (t == null) {
                throw new NullPointerException("Missing start.");
            }
            return new SimpleInterval<Object>(t, null, (TimeLine<Object>)this.timeLine);
        }

        public SimpleInterval<T> until(T t) {
            if (t == null) {
                throw new NullPointerException("Missing end.");
            }
            return new SimpleInterval<Object>(null, t, (TimeLine<Object>)this.timeLine);
        }

        public SimpleInterval<T> parse(CharSequence charSequence, ChronoParser<T> chronoParser) throws ParseException {
            return this.parse(charSequence, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
        }

        public SimpleInterval<T> parse(CharSequence charSequence, ChronoParser<T> chronoParser, String string) throws ParseException {
            IntervalCreator intervalCreator = new IntervalCreator<T, SimpleInterval<T>>(){

                @Override
                public SimpleInterval<T> between(Boundary<T> boundary, Boundary<T> boundary2) {
                    return new SimpleInterval(boundary, boundary2, timeLine);
                }

                @Override
                public boolean isCalendrical() {
                    return timeLine.isCalendrical();
                }
            };
            return (SimpleInterval)IntervalParser.parsePattern(charSequence, intervalCreator, chronoParser, string);
        }

        TimeLine<T> getTimeLine() {
            return this.timeLine;
        }
    }
}

