/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoDateUnit;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.ZonalDateTime;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.range.Boundary;
import net.time4j.range.DateInterval;
import net.time4j.range.DateIntervalFactory;
import net.time4j.range.MomentInterval;
import net.time4j.range.MomentIntervalFactory;
import net.time4j.range.TimestampInterval;
import net.time4j.range.TimestampIntervalFactory;
import net.time4j.tz.ZonalOffset;

public class IsoRecurrence<I>
implements Iterable<I> {
    private static final int INFINITE = -1;
    private static final int TYPE_START_END = 0;
    private static final int TYPE_START_DURATION = 1;
    private static final int TYPE_DURATION_END = 2;
    private final int count;
    private final int type;

    private IsoRecurrence(int n, int n2) {
        this.count = n;
        this.type = n2;
    }

    public static IsoRecurrence<DateInterval> of(int n, PlainDate plainDate, Duration<? extends IsoDateUnit> duration) {
        IsoRecurrence.check(n);
        if (plainDate == null) {
            throw new NullPointerException("Missing start of recurrent interval.");
        }
        return new RecurrentDateIntervals(n, 1, plainDate, duration);
    }

    public static IsoRecurrence<DateInterval> of(int n, Duration<? extends IsoDateUnit> duration, PlainDate plainDate) {
        IsoRecurrence.check(n);
        if (plainDate == null) {
            throw new NullPointerException("Missing end of recurrent interval.");
        }
        return new RecurrentDateIntervals(n, 2, plainDate, duration);
    }

    public static IsoRecurrence<DateInterval> of(int n, PlainDate plainDate, PlainDate plainDate2) {
        IsoRecurrence.check(n);
        if (!plainDate2.isAfter(plainDate)) {
            throw new IllegalArgumentException("End is not after start.");
        }
        return new RecurrentDateIntervals(n, 0, plainDate, Duration.inYearsMonthsDays().between(plainDate, plainDate2.plus(1L, CalendarUnit.DAYS)));
    }

    public static IsoRecurrence<TimestampInterval> of(int n, PlainTimestamp plainTimestamp, Duration<?> duration) {
        IsoRecurrence.check(n);
        if (plainTimestamp == null) {
            throw new NullPointerException("Missing start of recurrent interval.");
        }
        return new RecurrentTimestampIntervals(n, 1, plainTimestamp, duration);
    }

    public static IsoRecurrence<TimestampInterval> of(int n, Duration<?> duration, PlainTimestamp plainTimestamp) {
        IsoRecurrence.check(n);
        if (plainTimestamp == null) {
            throw new NullPointerException("Missing end of recurrent interval.");
        }
        return new RecurrentTimestampIntervals(n, 2, plainTimestamp, duration);
    }

    public static IsoRecurrence<TimestampInterval> of(int n, PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
        IsoRecurrence.check(n);
        if (!plainTimestamp2.isAfter(plainTimestamp)) {
            throw new IllegalArgumentException("End is not after start.");
        }
        return new RecurrentTimestampIntervals(n, 0, plainTimestamp, (Duration)Duration.in((IsoUnit[])new Enum[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS}).between(plainTimestamp, plainTimestamp2));
    }

    public static IsoRecurrence<MomentInterval> of(int n, Moment moment, Duration<?> duration, ZonalOffset zonalOffset) {
        IsoRecurrence.check(n);
        return new RecurrentMomentIntervals(n, 1, moment.toZonalTimestamp(zonalOffset), zonalOffset, duration);
    }

    public static IsoRecurrence<MomentInterval> of(int n, Duration<?> duration, Moment moment, ZonalOffset zonalOffset) {
        IsoRecurrence.check(n);
        return new RecurrentMomentIntervals(n, 2, moment.toZonalTimestamp(zonalOffset), zonalOffset, duration);
    }

    public static IsoRecurrence<MomentInterval> of(int n, Moment moment, Moment moment2, ZonalOffset zonalOffset) {
        IsoRecurrence.check(n);
        if (!moment2.isAfter(moment)) {
            throw new IllegalArgumentException("End is not after start.");
        }
        PlainTimestamp plainTimestamp = moment.toZonalTimestamp(zonalOffset);
        PlainTimestamp plainTimestamp2 = moment2.toZonalTimestamp(zonalOffset);
        return new RecurrentMomentIntervals(n, 0, plainTimestamp, zonalOffset, (Duration)Duration.in((IsoUnit[])new Enum[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS}).between(plainTimestamp, plainTimestamp2));
    }

    public int getCount() {
        return this.count;
    }

    public IsoRecurrence<I> withCount(int n) {
        if (n == this.count) {
            return this;
        }
        IsoRecurrence.check(n);
        return this.copyWithCount(n);
    }

    public IsoRecurrence<I> withInfiniteCount() {
        if (this.count == -1) {
            return this;
        }
        return this.copyWithCount(-1);
    }

    public boolean isBackwards() {
        return this.type == 2;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean isInfinite() {
        return this.count == -1;
    }

    public static IsoRecurrence<DateInterval> parseDateIntervals(String string) throws ParseException {
        IsoRecurrence<DateInterval> isoRecurrence;
        String[] stringArray = string.split("/");
        int n = IsoRecurrence.parseCount(stringArray);
        boolean bl = false;
        if (n == -1) {
            n = 0;
            bl = true;
        }
        if (stringArray[2].charAt(0) == 'P') {
            PlainDate plainDate = Iso8601Format.parseDate(stringArray[1]);
            Duration<CalendarUnit> duration = Duration.parseCalendarPeriod(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n, plainDate, duration);
        } else if (stringArray[1].charAt(0) == 'P') {
            Duration<CalendarUnit> duration = Duration.parseCalendarPeriod(stringArray[1]);
            PlainDate plainDate = Iso8601Format.parseDate(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n, duration, plainDate);
        } else {
            DateInterval dateInterval = DateInterval.parseISO(string.substring(IsoRecurrence.getFirstSlash(string) + 1));
            PlainDate plainDate = (PlainDate)dateInterval.getStart().getTemporal();
            PlainDate plainDate2 = (PlainDate)dateInterval.getEnd().getTemporal();
            isoRecurrence = IsoRecurrence.of(n, plainDate, plainDate2);
        }
        if (bl) {
            isoRecurrence = isoRecurrence.withInfiniteCount();
        }
        return isoRecurrence;
    }

    public static IsoRecurrence<TimestampInterval> parseTimestampIntervals(String string) throws ParseException {
        IsoRecurrence<TimestampInterval> isoRecurrence;
        String[] stringArray = string.split("/");
        int n = IsoRecurrence.parseCount(stringArray);
        boolean bl = false;
        if (n == -1) {
            n = 0;
            bl = true;
        }
        if (stringArray[2].charAt(0) == 'P') {
            boolean bl2 = IsoRecurrence.isExtendedFormat(stringArray[1]);
            PlainTimestamp plainTimestamp = IsoRecurrence.timestampFormatter(bl2).parse(stringArray[1]);
            Duration<IsoUnit> duration = Duration.parsePeriod(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n, plainTimestamp, duration);
        } else if (stringArray[1].charAt(0) == 'P') {
            Duration<IsoUnit> duration = Duration.parsePeriod(stringArray[1]);
            boolean bl3 = IsoRecurrence.isExtendedFormat(stringArray[2]);
            PlainTimestamp plainTimestamp = IsoRecurrence.timestampFormatter(bl3).parse(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n, duration, plainTimestamp);
        } else {
            TimestampInterval timestampInterval = TimestampInterval.parseISO(string.substring(IsoRecurrence.getFirstSlash(string) + 1));
            PlainTimestamp plainTimestamp = (PlainTimestamp)timestampInterval.getStart().getTemporal();
            PlainTimestamp plainTimestamp2 = (PlainTimestamp)timestampInterval.getEnd().getTemporal();
            isoRecurrence = IsoRecurrence.of(n, plainTimestamp, plainTimestamp2);
        }
        if (bl) {
            isoRecurrence = isoRecurrence.withInfiniteCount();
        }
        return isoRecurrence;
    }

    public static IsoRecurrence<MomentInterval> parseMomentIntervals(String string) throws ParseException {
        IsoRecurrence<MomentInterval> isoRecurrence;
        String[] stringArray = string.split("/");
        int n = IsoRecurrence.parseCount(stringArray);
        boolean bl = false;
        if (n == -1) {
            n = 0;
            bl = true;
        }
        if (stringArray[2].charAt(0) == 'P') {
            boolean bl2 = IsoRecurrence.isExtendedFormat(stringArray[1]);
            ZonalDateTime zonalDateTime = ZonalDateTime.parse(stringArray[1], IsoRecurrence.momentFormatter(bl2));
            Duration<IsoUnit> duration = Duration.parsePeriod(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n, zonalDateTime.toMoment(), duration, zonalDateTime.getOffset());
        } else if (stringArray[1].charAt(0) == 'P') {
            Duration<IsoUnit> duration = Duration.parsePeriod(stringArray[1]);
            boolean bl3 = IsoRecurrence.isExtendedFormat(stringArray[2]);
            ZonalDateTime zonalDateTime = ZonalDateTime.parse(stringArray[2], IsoRecurrence.momentFormatter(bl3));
            isoRecurrence = IsoRecurrence.of(n, duration, zonalDateTime.toMoment(), zonalDateTime.getOffset());
        } else {
            String string2 = string.substring(IsoRecurrence.getFirstSlash(string) + 1);
            MomentInterval momentInterval = MomentInterval.parseISO(string2);
            Moment moment = (Moment)momentInterval.getStart().getTemporal();
            Moment moment2 = (Moment)momentInterval.getEnd().getTemporal();
            ZonalOffset zonalOffset = null;
            int n2 = -1;
            int n3 = string2.length();
            for (int i = 1; i < n3; ++i) {
                char c = string2.charAt(i);
                if (c == 'Z') {
                    zonalOffset = ZonalOffset.UTC;
                    break;
                }
                if (c == '-' || c == '+') {
                    n2 = i;
                    continue;
                }
                if (c != '/') continue;
                if ((string2 = string2.substring(n2, i)).charAt(3) != ':') {
                    string2 = string2.substring(0, 3) + ":" + string2.substring(3);
                }
                zonalOffset = ZonalOffset.parse(string2);
                break;
            }
            isoRecurrence = IsoRecurrence.of(n, moment, moment2, zonalOffset);
        }
        if (bl) {
            isoRecurrence = isoRecurrence.withInfiniteCount();
        }
        return isoRecurrence;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            IsoRecurrence isoRecurrence = (IsoRecurrence)IsoRecurrence.class.cast(object);
            return this.count == isoRecurrence.count && this.type == isoRecurrence.type;
        }
        return false;
    }

    public int hashCode() {
        return this.count;
    }

    public String toString() {
        throw new AbstractMethodError();
    }

    @Override
    public Iterator<I> iterator() {
        throw new AbstractMethodError();
    }

    public Stream<I> intervalStream() {
        long l = this.isInfinite() ? Long.MAX_VALUE : (long)this.getCount();
        int n = 17745;
        Spliterator<I> spliterator = Spliterators.spliterator(this.iterator(), l, n);
        return StreamSupport.stream(spliterator, false);
    }

    IsoRecurrence<I> copyWithCount(int n) {
        throw new AbstractMethodError();
    }

    int getType() {
        return this.type;
    }

    private static void check(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Count of recurrent intervals must be postive or zero: " + n);
        }
    }

    private static int parseCount(String[] stringArray) throws ParseException {
        if (stringArray.length != 3) {
            throw new ParseException("Recurrent interval format must contain exactly 3 chars '/'.", 0);
        }
        if (stringArray[0].isEmpty() || stringArray[0].charAt(0) != 'R') {
            throw new ParseException("Recurrent interval format must start with char 'R'.", 0);
        }
        int n = -1;
        for (int i = 1; i < stringArray[0].length(); ++i) {
            int n2;
            if (i == 1) {
                n = 0;
            }
            if ((n2 = stringArray[0].charAt(i) - 48) < 0 || n2 > 9) {
                throw new ParseException("Digit 0-9 is missing.", i);
            }
            n = n * 10 + n2;
        }
        return n;
    }

    private static boolean isExtendedFormat(String string) {
        char c;
        int n = string.length();
        for (int i = 1; i < n && (c = string.charAt(i)) != 'T'; ++i) {
            if (c != '-') continue;
            return true;
        }
        return false;
    }

    private static int getFirstSlash(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '/') continue;
            return i;
        }
        return -1;
    }

    private static ChronoFormatter<PlainTimestamp> timestampFormatter(boolean bl) {
        return bl ? Iso8601Format.EXTENDED_DATE_TIME : Iso8601Format.BASIC_DATE_TIME;
    }

    private static ChronoFormatter<Moment> momentFormatter(boolean bl) {
        return bl ? Iso8601Format.EXTENDED_DATE_TIME_OFFSET : Iso8601Format.BASIC_DATE_TIME_OFFSET;
    }

    private static class RecurrentMomentIntervals
    extends IsoRecurrence<MomentInterval> {
        private final PlainTimestamp ref;
        private final ZonalOffset offset;
        private final Duration<?> duration;

        private RecurrentMomentIntervals(int n, int n2, PlainTimestamp plainTimestamp, ZonalOffset zonalOffset, Duration<?> duration) {
            super(n, n2);
            this.ref = plainTimestamp;
            this.offset = zonalOffset;
            this.duration = duration;
            if (!duration.isPositive()) {
                throw new IllegalArgumentException("Duration must be positive: " + duration);
            }
            if (zonalOffset.getIntegralAmount() % 60 != 0 || zonalOffset.getFractionalAmount() != 0) {
                throw new IllegalArgumentException("Offset with seconds is invalid in ISO-8601: " + zonalOffset);
            }
        }

        @Override
        public Iterator<MomentInterval> iterator() {
            return new ReadOnlyIterator<MomentInterval, RecurrentMomentIntervals>(this){
                private PlainTimestamp current;
                private ZonalOffset offset;
                {
                    super(recurrentMomentIntervals2);
                    this.current = ref;
                    this.offset = offset;
                }

                @Override
                protected MomentInterval nextInterval() {
                    Boundary<Moment> boundary;
                    Boundary<Moment> boundary2;
                    PlainTimestamp plainTimestamp;
                    if (this.isBackwards()) {
                        plainTimestamp = (PlainTimestamp)this.current.minus(duration);
                        boundary2 = Boundary.ofClosed(plainTimestamp.at(this.offset));
                        boundary = Boundary.ofOpen(this.current.at(this.offset));
                    } else {
                        plainTimestamp = (PlainTimestamp)this.current.plus(duration);
                        boundary2 = Boundary.ofClosed(this.current.at(this.offset));
                        boundary = Boundary.ofOpen(plainTimestamp.at(this.offset));
                    }
                    this.current = plainTimestamp;
                    return MomentIntervalFactory.INSTANCE.between((Boundary)boundary2, (Boundary)boundary);
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                RecurrentMomentIntervals recurrentMomentIntervals = (RecurrentMomentIntervals)object;
                return this.ref.equals(recurrentMomentIntervals.ref) && this.duration.equals(recurrentMomentIntervals.duration) && this.offset.equals(recurrentMomentIntervals.offset);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 7 * this.ref.hashCode() + 31 * this.offset.hashCode() + 37 * this.duration.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('R');
            int n = this.getCount();
            if (n != -1) {
                stringBuilder.append(this.getCount());
            }
            stringBuilder.append('/');
            switch (this.getType()) {
                case 1: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append(this.getOffsetAsString());
                    stringBuilder.append('/');
                    stringBuilder.append(this.duration);
                    break;
                }
                case 2: {
                    stringBuilder.append(this.duration);
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref);
                    stringBuilder.append(this.getOffsetAsString());
                    break;
                }
                case 0: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append(this.getOffsetAsString());
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref.plus(this.duration));
                    stringBuilder.append(this.getOffsetAsString());
                }
            }
            return stringBuilder.toString();
        }

        @Override
        IsoRecurrence<MomentInterval> copyWithCount(int n) {
            return new RecurrentMomentIntervals(n, this.getType(), this.ref, this.offset, this.duration);
        }

        private String getOffsetAsString() {
            if (this.offset.getIntegralAmount() == 0 && this.offset.getFractionalAmount() == 0) {
                return "Z";
            }
            return this.offset.toString();
        }
    }

    private static class RecurrentTimestampIntervals
    extends IsoRecurrence<TimestampInterval> {
        private final PlainTimestamp ref;
        private final Duration<?> duration;

        private RecurrentTimestampIntervals(int n, int n2, PlainTimestamp plainTimestamp, Duration<?> duration) {
            super(n, n2);
            this.ref = plainTimestamp;
            this.duration = duration;
            if (!duration.isPositive()) {
                throw new IllegalArgumentException("Duration must be positive: " + duration);
            }
        }

        @Override
        public Iterator<TimestampInterval> iterator() {
            return new ReadOnlyIterator<TimestampInterval, RecurrentTimestampIntervals>(this){
                private PlainTimestamp current;
                {
                    super(recurrentTimestampIntervals2);
                    this.current = ref;
                }

                @Override
                protected TimestampInterval nextInterval() {
                    Boundary<PlainTimestamp> boundary;
                    Boundary<PlainTimestamp> boundary2;
                    PlainTimestamp plainTimestamp;
                    if (this.isBackwards()) {
                        plainTimestamp = (PlainTimestamp)this.current.minus(duration);
                        boundary2 = Boundary.ofClosed(plainTimestamp);
                        boundary = Boundary.ofOpen(this.current);
                    } else {
                        plainTimestamp = (PlainTimestamp)this.current.plus(duration);
                        boundary2 = Boundary.ofClosed(this.current);
                        boundary = Boundary.ofOpen(plainTimestamp);
                    }
                    this.current = plainTimestamp;
                    return TimestampIntervalFactory.INSTANCE.between((Boundary)boundary2, (Boundary)boundary);
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                RecurrentTimestampIntervals recurrentTimestampIntervals = (RecurrentTimestampIntervals)object;
                return this.ref.equals(recurrentTimestampIntervals.ref) && this.duration.equals(recurrentTimestampIntervals.duration);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.ref.hashCode() + 37 * this.duration.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('R');
            int n = this.getCount();
            if (n != -1) {
                stringBuilder.append(this.getCount());
            }
            stringBuilder.append('/');
            switch (this.getType()) {
                case 1: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append('/');
                    stringBuilder.append(this.duration);
                    break;
                }
                case 2: {
                    stringBuilder.append(this.duration);
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref);
                    break;
                }
                case 0: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref.plus(this.duration));
                }
            }
            return stringBuilder.toString();
        }

        @Override
        IsoRecurrence<TimestampInterval> copyWithCount(int n) {
            return new RecurrentTimestampIntervals(n, this.getType(), this.ref, this.duration);
        }
    }

    private static class RecurrentDateIntervals
    extends IsoRecurrence<DateInterval> {
        private final PlainDate ref;
        private final Duration<? extends IsoDateUnit> duration;

        private RecurrentDateIntervals(int n, int n2, PlainDate plainDate, Duration<? extends IsoDateUnit> duration) {
            super(n, n2);
            this.ref = plainDate;
            this.duration = duration;
            if (!duration.isPositive()) {
                throw new IllegalArgumentException("Duration must be positive: " + duration);
            }
        }

        @Override
        public Iterator<DateInterval> iterator() {
            return new ReadOnlyIterator<DateInterval, RecurrentDateIntervals>(this){
                private PlainDate current;
                {
                    super(recurrentDateIntervals2);
                    this.current = ref;
                }

                @Override
                protected DateInterval nextInterval() {
                    Boundary<PlainDate> boundary;
                    Boundary<PlainDate> boundary2;
                    PlainDate plainDate;
                    if (this.isBackwards()) {
                        plainDate = (PlainDate)this.current.minus(duration);
                        boundary2 = Boundary.ofClosed(plainDate.plus(1L, CalendarUnit.DAYS));
                        boundary = Boundary.ofClosed(this.current);
                    } else {
                        plainDate = (PlainDate)this.current.plus(duration);
                        boundary2 = Boundary.ofClosed(this.current);
                        boundary = Boundary.ofClosed(plainDate.minus(1L, CalendarUnit.DAYS));
                    }
                    this.current = plainDate;
                    return DateIntervalFactory.INSTANCE.between((Boundary)boundary2, (Boundary)boundary);
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                RecurrentDateIntervals recurrentDateIntervals = (RecurrentDateIntervals)object;
                return this.ref.equals(recurrentDateIntervals.ref) && this.duration.equals(recurrentDateIntervals.duration);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.ref.hashCode() + 37 * this.duration.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('R');
            int n = this.getCount();
            if (n != -1) {
                stringBuilder.append(this.getCount());
            }
            stringBuilder.append('/');
            switch (this.getType()) {
                case 1: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append('/');
                    stringBuilder.append(this.duration);
                    break;
                }
                case 2: {
                    stringBuilder.append(this.duration);
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref);
                    break;
                }
                case 0: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append('/');
                    stringBuilder.append(((PlainDate)this.ref.plus(this.duration)).minus(1L, CalendarUnit.DAYS));
                }
            }
            return stringBuilder.toString();
        }

        @Override
        IsoRecurrence<DateInterval> copyWithCount(int n) {
            return new RecurrentDateIntervals(n, this.getType(), this.ref, this.duration);
        }
    }

    private static abstract class ReadOnlyIterator<I, R extends IsoRecurrence<?>>
    implements Iterator<I> {
        private int index = 0;
        private R recurrence;

        ReadOnlyIterator(R r) {
            this.recurrence = r;
        }

        @Override
        public final boolean hasNext() {
            int n = ((IsoRecurrence)this.recurrence).getCount();
            return n == -1 || this.index < n;
        }

        @Override
        public final I next() {
            int n = ((IsoRecurrence)this.recurrence).getCount();
            if (n != -1 && this.index >= n) {
                throw new NoSuchElementException("After end of interval recurrence.");
            }
            I i = this.nextInterval();
            ++this.index;
            return i;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract I nextInterval();
    }
}

