/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.calendar.EthiopianCalendar;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum EthiopianMonth implements ChronoCondition<EthiopianCalendar>
{
    MESKEREM,
    TEKEMT,
    HEDAR,
    TAHSAS,
    TER,
    YEKATIT,
    MEGABIT,
    MIAZIA,
    GENBOT,
    SENE,
    HAMLE,
    NEHASSE,
    PAGUMEN;

    private static final EthiopianMonth[] ENUMS;

    public static EthiopianMonth valueOf(int n) {
        if (n < 1 || n > 13) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return ENUMS[n - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance("ethiopic", locale);
        return calendarText.getStdMonths(textWidth, outputContext).print(this);
    }

    @Override
    public boolean test(EthiopianCalendar ethiopianCalendar) {
        return ethiopianCalendar.getMonth() == this;
    }

    static {
        ENUMS = EthiopianMonth.values();
    }
}

