/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.io.Serializable;
import java.util.Locale;
import net.time4j.calendar.IndianMonth;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduPrimitive;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public final class HinduMonth
extends HinduPrimitive
implements Comparable<HinduMonth>,
ChronoCondition<HinduCalendar>,
Serializable {
    public static final AttributeKey<Boolean> RASI_NAMES = Attributes.createKey("RASI_NAMES", Boolean.class);
    private final IndianMonth value;
    private final boolean leap;

    private HinduMonth(IndianMonth indianMonth, boolean bl) {
        if (indianMonth == null) {
            throw new NullPointerException("Missing Indian month.");
        }
        this.value = indianMonth;
        this.leap = bl;
    }

    public static HinduMonth of(IndianMonth indianMonth) {
        return new HinduMonth(indianMonth, false);
    }

    public static HinduMonth ofLunisolar(int n) {
        return new HinduMonth(IndianMonth.valueOf(n), false);
    }

    public static HinduMonth ofSolar(int n) {
        int n2 = n == 12 ? 1 : n + 1;
        return new HinduMonth(IndianMonth.valueOf(n2), false);
    }

    public IndianMonth getValue() {
        return this.value;
    }

    public int getRasi() {
        return this.value == IndianMonth.CHAITRA ? 12 : this.value.getValue() - 1;
    }

    public String getRasi(Locale locale) {
        CalendarText calendarText = CalendarText.getInstance("extra/hindu", locale);
        String string = calendarText.getTextForms("R", IndianMonth.class, new String[0]).print(IndianMonth.valueOf(this.getRasi()));
        if (this.leap) {
            string = HinduMonth.getAdhika(locale) + string;
        }
        return string;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        String string = CalendarText.getInstance("indian", locale).getStdMonths(textWidth, outputContext).print(this.value);
        if (this.leap) {
            string = HinduMonth.getAdhika(locale) + string;
        }
        return string;
    }

    @Override
    public boolean isLeap() {
        return this.leap;
    }

    public HinduMonth withLeap() {
        return this.leap ? this : new HinduMonth(this.value, true);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HinduMonth) {
            HinduMonth hinduMonth = (HinduMonth)object;
            return this.value == hinduMonth.value && this.leap == hinduMonth.leap;
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode() + (this.leap ? 12 : 0);
    }

    public String toString() {
        String string = this.value.toString();
        return this.leap ? "*" + string : string;
    }

    @Override
    public int compareTo(HinduMonth hinduMonth) {
        int n = this.value.compareTo(hinduMonth.value);
        if (n == 0) {
            n = this.leap ? (hinduMonth.leap ? 0 : -1) : (hinduMonth.leap ? 1 : 0);
        }
        return n;
    }

    @Override
    public boolean test(HinduCalendar hinduCalendar) {
        return this.equals(hinduCalendar.getMonth());
    }

    private static String getAdhika(Locale locale) {
        return CalendarText.getInstance("extra/hindu", locale).getTextForms().get("adhika") + " ";
    }
}

