/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.base.ResourceLoader;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.astro.SunPosition;
import net.time4j.calendar.astro.Twilight;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.EpochDays;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class SolarTime
implements GeoLocation,
Serializable {
    static final double SUN_RADIUS = 16.0;
    static final double STD_REFRACTION = 34.0;
    static final double STD_ZENITH = 90.83333333333333;
    static final String DECLINATION = "declination";
    static final String RIGHT_ASCENSION = "right-ascension";
    static final double ARC_MIN = 0.016666666666666666;
    private static final Calculator DEFAULT_CALCULATOR;
    private static final ConcurrentMap<String, Calculator> CALCULATORS;
    private static final SolarTime JERUSALEM;
    private static final SolarTime MECCA;
    private static final long serialVersionUID = -4816619838743247977L;
    private final double latitude;
    private final double longitude;
    private final int altitude;
    private final String calculator;
    private final TZID observerZoneID;

    private SolarTime(double d, double d2, int n, String string, TZID tZID) {
        this.latitude = d;
        this.longitude = d2;
        this.altitude = n;
        this.calculator = string;
        this.observerZoneID = tZID;
    }

    public static Builder ofLocation() {
        return new Builder();
    }

    public static SolarTime ofLocation(double d, double d2) {
        return SolarTime.ofLocation(d, d2, 0, DEFAULT_CALCULATOR);
    }

    public static SolarTime ofLocation(double d, double d2, int n, String string) {
        SolarTime.check(d, d2, n, string);
        return new SolarTime(d, d2, n, string, null);
    }

    public static SolarTime ofLocation(double d, double d2, int n, Calculator calculator) {
        String string = calculator.name();
        CALCULATORS.putIfAbsent(string, calculator);
        SolarTime.check(d, d2, n, string);
        return new SolarTime(d, d2, n, string, null);
    }

    public static SolarTime ofJerusalem() {
        return JERUSALEM;
    }

    public static SolarTime ofMecca() {
        return MECCA;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public int getAltitude() {
        return this.altitude;
    }

    public Calculator getCalculator() {
        return (Calculator)CALCULATORS.get(this.calculator);
    }

    public Optional<TZID> getObserverZoneID() {
        return this.observerZoneID == null ? Optional.empty() : Optional.of(this.observerZoneID);
    }

    public ChronoFunction<CalendarDate, Optional<Moment>> sunrise() {
        return calendarDate -> this.getCalculator().sunrise(this.toLMT((CalendarDate)calendarDate), this.latitude, this.longitude, this.zenithAngle());
    }

    public ChronoFunction<CalendarDate, Optional<Moment>> sunrise(Twilight twilight) {
        double d = 90.0 + this.geodeticAngle() + twilight.getAngle();
        return calendarDate -> this.getCalculator().sunrise(this.toLMT((CalendarDate)calendarDate), this.latitude, this.longitude, d);
    }

    public ChronoFunction<CalendarDate, Optional<Moment>> sunset() {
        return calendarDate -> this.getCalculator().sunset(this.toLMT((CalendarDate)calendarDate), this.latitude, this.longitude, this.zenithAngle());
    }

    public ChronoFunction<CalendarDate, Optional<Moment>> sunset(Twilight twilight) {
        double d = 90.0 + this.geodeticAngle() + twilight.getAngle();
        return calendarDate -> this.getCalculator().sunset(this.toLMT((CalendarDate)calendarDate), this.latitude, this.longitude, d);
    }

    public ChronoFunction<CalendarDate, Sunshine> sunshine(TZID tZID) {
        return calendarDate -> {
            double d;
            PlainDate plainDate = SolarTime.toGregorian(this.toLMT((CalendarDate)calendarDate));
            Calculator calculator = this.getCalculator();
            double d2 = this.zenithAngle();
            Optional<Moment> optional = calculator.sunrise((CalendarDate)calendarDate, this.latitude, this.longitude, d2);
            Optional<Moment> optional2 = calculator.sunset((CalendarDate)calendarDate, this.latitude, this.longitude, d2);
            boolean bl = false;
            if (!optional.isPresent() && !optional2.isPresent() && Double.compare(d = this.getHighestElevationOfSun(plainDate), 90.0 - d2) < 0) {
                bl = true;
            }
            return new Sunshine(plainDate, optional, optional2, tZID, bl);
        };
    }

    public ChronoCondition<CalendarDate> polarNight() {
        return calendarDate -> {
            if (Double.compare(Math.abs(this.latitude), 66.0) < 0) {
                return false;
            }
            PlainDate plainDate = SolarTime.toGregorian(this.toLMT((CalendarDate)calendarDate));
            Calculator calculator = this.getCalculator();
            double d = this.zenithAngle();
            Optional<Moment> optional = calculator.sunrise((CalendarDate)calendarDate, this.latitude, this.longitude, d);
            Optional<Moment> optional2 = calculator.sunset((CalendarDate)calendarDate, this.latitude, this.longitude, d);
            if (optional.isPresent() || optional2.isPresent()) {
                return false;
            }
            double d2 = this.getHighestElevationOfSun(plainDate);
            return Double.compare(d2, 90.0 - d) < 0;
        };
    }

    public ChronoCondition<CalendarDate> midnightSun() {
        return calendarDate -> {
            if (Double.compare(Math.abs(this.latitude), 66.0) < 0) {
                return false;
            }
            PlainDate plainDate = SolarTime.toGregorian(this.toLMT((CalendarDate)calendarDate));
            Calculator calculator = this.getCalculator();
            double d = this.zenithAngle();
            Optional<Moment> optional = calculator.sunrise((CalendarDate)calendarDate, this.latitude, this.longitude, d);
            Optional<Moment> optional2 = calculator.sunset((CalendarDate)calendarDate, this.latitude, this.longitude, d);
            if (optional.isPresent() || optional2.isPresent()) {
                return false;
            }
            double d2 = this.getHighestElevationOfSun(plainDate);
            return Double.compare(d2, 90.0 - d) > 0;
        };
    }

    public ChronoFunction<CalendarDate, Moment> transitAtNoon() {
        return calendarDate -> SolarTime.transitAtNoon(this.toLMT((CalendarDate)calendarDate), this.longitude, this.calculator);
    }

    public ChronoFunction<CalendarDate, Moment> transitAtMidnight() {
        return calendarDate -> SolarTime.transitAtMidnight(this.toLMT((CalendarDate)calendarDate), this.longitude, this.calculator);
    }

    public ChronoFunction<CalendarDate, Optional<Moment>> timeOfShadowBeforeNoon(double d, double d2) {
        this.checkShadow(d, d2);
        return calendarDate -> this.timeOfShadow((CalendarDate)calendarDate, false, d, d2);
    }

    public ChronoFunction<CalendarDate, Optional<Moment>> timeOfShadowAfterNoon(double d, double d2) {
        this.checkShadow(d, d2);
        return calendarDate -> this.timeOfShadow((CalendarDate)calendarDate, true, d, d2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SolarTime) {
            SolarTime solarTime = (SolarTime)object;
            return this.calculator.equals(solarTime.calculator) && Double.compare(this.latitude, solarTime.latitude) == 0 && Double.compare(this.longitude, solarTime.longitude) == 0 && this.altitude == solarTime.altitude && SolarTime.equalZones(this.observerZoneID, solarTime.observerZoneID);
        }
        return false;
    }

    public int hashCode() {
        return this.calculator.hashCode() + 7 * Double.hashCode(this.latitude) + 31 * Double.hashCode(this.longitude) + 37 * this.altitude;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SolarTime[latitude=");
        stringBuilder.append(this.latitude);
        stringBuilder.append(",longitude=");
        stringBuilder.append(this.longitude);
        if (this.altitude != 0) {
            stringBuilder.append(",altitude=");
            stringBuilder.append(this.altitude);
        }
        if (!this.calculator.equals(DEFAULT_CALCULATOR.name())) {
            stringBuilder.append(",calculator=");
            stringBuilder.append(this.calculator);
        }
        if (this.observerZoneID != null) {
            stringBuilder.append(",observerZoneID=");
            stringBuilder.append(this.observerZoneID.canonical());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static ChronoFunction<Moment, PlainTimestamp> apparentAt(ZonalOffset zonalOffset) {
        return moment -> {
            PlainTimestamp plainTimestamp = SolarTime.onAverage(moment, zonalOffset);
            double d = SolarTime.equationOfTime(moment);
            long l = (long)Math.floor(d);
            int n = (int)((d - (double)l) * 1.0E9);
            return plainTimestamp.plus(l, ClockUnit.SECONDS).plus((long)n, ClockUnit.NANOS);
        };
    }

    public static ChronoFunction<Moment, PlainTimestamp> apparentAt(ZonalOffset zonalOffset, String string) {
        return moment -> {
            PlainTimestamp plainTimestamp = SolarTime.onAverage(moment, zonalOffset);
            double d = SolarTime.equationOfTime(moment, string);
            long l = (long)Math.floor(d);
            int n = (int)((d - (double)l) * 1.0E9);
            return plainTimestamp.plus(l, ClockUnit.SECONDS).plus((long)n, ClockUnit.NANOS);
        };
    }

    public static ChronoFunction<Moment, PlainTimestamp> onAverage(ZonalOffset zonalOffset) {
        return moment -> SolarTime.onAverage(moment, zonalOffset);
    }

    public static double equationOfTime(Moment moment) {
        double d = JulianDay.getValue(moment, TimeScale.TT);
        return DEFAULT_CALCULATOR.equationOfTime(d);
    }

    public static double equationOfTime(Moment moment, String string) {
        if (string == null) {
            throw new NullPointerException("Missing calculator parameter.");
        }
        if (CALCULATORS.containsKey(string)) {
            double d = JulianDay.getValue(moment, TimeScale.TT);
            return ((Calculator)CALCULATORS.get(string)).equationOfTime(d);
        }
        throw new IllegalArgumentException("Unknown calculator: " + string);
    }

    double getHighestElevationOfSun(PlainDate plainDate) {
        Moment moment = plainDate.get(this.transitAtNoon());
        double d = JulianDay.getValue(moment, TimeScale.TT);
        double d2 = Math.toRadians(this.getCalculator().getFeature(d, DECLINATION));
        double d3 = Math.toRadians(this.latitude);
        double d4 = Math.sin(d3) * Math.sin(d2) + Math.cos(d3) * Math.cos(d2);
        double d5 = Math.toDegrees(Math.asin(d4));
        if (Double.isNaN(d5)) {
            throw new UnsupportedOperationException("Solar declination not supported by: " + this.getCalculator().name());
        }
        return d5;
    }

    static PlainDate toGregorian(CalendarDate calendarDate) {
        if (calendarDate instanceof PlainDate) {
            return (PlainDate)calendarDate;
        }
        return PlainDate.of(calendarDate.getDaysSinceEpochUTC(), EpochDays.UTC);
    }

    static Moment fromLocalEvent(CalendarDate calendarDate, int n, double d, String string) {
        Calculator calculator = (Calculator)CALCULATORS.get(string);
        double d2 = (double)(calendarDate.getDaysSinceEpochUTC() * 86400L + (long)(n * 3600)) - d * 240.0;
        long l = (long)Math.floor(d2);
        int n2 = (int)((d2 - (double)l) * 1.0E9);
        TimeScale timeScale = TimeScale.UT;
        if (!LeapSeconds.getInstance().isEnabled()) {
            l += 63072000L;
            timeScale = TimeScale.POSIX;
        }
        Moment moment = Moment.of(l, n2, timeScale);
        double d3 = calculator.equationOfTime(JulianDay.getValue(moment, TimeScale.TT));
        l = (long)Math.floor(d3);
        n2 = (int)((d3 - (double)l) * 1.0E9);
        Moment moment2 = (Moment)((Moment)moment.minus(l, TimeUnit.SECONDS)).minus((long)n2, TimeUnit.NANOSECONDS);
        d3 = calculator.equationOfTime(JulianDay.getValue(moment2, TimeScale.TT));
        l = (long)Math.floor(d3);
        n2 = (int)((d3 - (double)l) * 1.0E9);
        return (Moment)((Moment)moment.minus(l, TimeUnit.SECONDS)).minus((long)n2, TimeUnit.NANOSECONDS);
    }

    private static PlainTimestamp onAverage(Moment moment, ZonalOffset zonalOffset) {
        Moment moment2 = Moment.of(moment.getElapsedTime(TimeScale.UT) + 63072000L, moment.getNanosecond(TimeScale.UT), TimeScale.POSIX);
        return moment2.toZonalTimestamp(zonalOffset);
    }

    private static Moment transitAtNoon(CalendarDate calendarDate, double d, String string) {
        Moment moment = SolarTime.fromLocalEvent(calendarDate, 12, d, string);
        return (Moment)moment.with(Moment.PRECISION, SolarTime.precision(string));
    }

    private static Moment transitAtMidnight(CalendarDate calendarDate, double d, String string) {
        Moment moment = SolarTime.fromLocalEvent(calendarDate, 0, d, string);
        return (Moment)moment.with(Moment.PRECISION, SolarTime.precision(string));
    }

    private void checkShadow(double d, double d2) {
        if (!Double.isFinite(d) || d <= 0.0) {
            throw new IllegalArgumentException("Object height must be finite and positive.");
        }
        if (!Double.isFinite(d2) || d2 < 0.0) {
            throw new IllegalArgumentException("Length of shadow must be finite and not negative.");
        }
        if (Math.abs(this.latitude) > 66.0) {
            throw new UnsupportedOperationException("Cannot calculate time of shadow for polar regions.");
        }
    }

    private Optional<Moment> timeOfShadow(CalendarDate calendarDate, boolean bl, double d, double d2) {
        double d3;
        Optional<Moment> optional;
        PlainDate plainDate = SolarTime.toGregorian(this.toLMT(calendarDate));
        Optional<Moment> optional2 = optional = bl ? plainDate.get(this.sunset()) : plainDate.get(this.sunrise());
        assert (optional.isPresent());
        Moment moment = plainDate.get(this.transitAtNoon());
        double d4 = SunPosition.at(moment, this).getElevation();
        if (d4 <= 0.016666666666666666) {
            return optional;
        }
        double d5 = d3 = d2 == 0.0 ? 90.0 : Math.toDegrees(Math.atan(d / d2));
        if (d3 > d4 + 0.016666666666666666) {
            return Optional.empty();
        }
        return Optional.of(this.timeOfShadow(optional.get().getPosixTime(), moment.getPosixTime(), d3));
    }

    private Moment timeOfShadow(long l, long l2, double d) {
        Moment moment = Moment.of(Math.addExact(l, l2) / 2L, TimeScale.POSIX);
        double d2 = SunPosition.at(moment, this).getElevation();
        if (Math.abs(d2 - d) < 0.016666666666666666) {
            return moment;
        }
        if ((double)Double.compare(d, d2) > 0.0) {
            return this.timeOfShadow(moment.getPosixTime(), l2, d);
        }
        return this.timeOfShadow(l, moment.getPosixTime(), d);
    }

    private static TimeUnit precision(String string) {
        return string.equals(StdSolarCalculator.SIMPLE.name()) ? TimeUnit.MINUTES : TimeUnit.SECONDS;
    }

    private double geodeticAngle() {
        return this.getCalculator().getGeodeticAngle(this.latitude, this.altitude);
    }

    private double zenithAngle() {
        return this.getCalculator().getZenithAngle(this.latitude, this.altitude);
    }

    private static void check(double d, double d2, int n, String string) {
        if (!Double.isFinite(d)) {
            throw new IllegalArgumentException("Latitude must be a finite value: " + d);
        }
        if (!Double.isFinite(d2)) {
            throw new IllegalArgumentException("Longitude must be a finite value: " + d2);
        }
        if (Double.compare(d, 90.0) > 0 || Double.compare(d, -90.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -90.0 <= latitude <= +90.0: " + d);
        }
        if (Double.compare(d2, 180.0) >= 0 || Double.compare(d2, -180.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -180.0 <= longitude < +180.0: " + d2);
        }
        if (!Double.isFinite(n)) {
            throw new IllegalArgumentException("Altitude must be finite: " + n);
        }
        if (n < 0 || n >= 11000) {
            throw new IllegalArgumentException("Meters out of range 0 <= altitude < +11,000: " + n);
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing calculator.");
        }
        if (!CALCULATORS.containsKey(string)) {
            throw new IllegalArgumentException("Unknown calculator: " + string);
        }
    }

    private CalendarDate toLMT(CalendarDate calendarDate) {
        if (this.observerZoneID == null || Math.abs(this.longitude) < 150.0) {
            return calendarDate;
        }
        PlainDate plainDate = SolarTime.toGregorian(calendarDate);
        PlainTimestamp plainTimestamp = plainDate.at(PlainTime.of(12));
        if (!plainTimestamp.isValid(this.observerZoneID)) {
            throw new ChronoException("Calendar date does not exist in zone: " + calendarDate + " (" + this.observerZoneID.canonical() + ")");
        }
        ZonalOffset zonalOffset = ZonalOffset.atLongitude(new BigDecimal(this.longitude));
        return plainTimestamp.inTimezone(this.observerZoneID).toZonalTimestamp(zonalOffset).getCalendarDate();
    }

    private static boolean equalZones(TZID tZID, TZID tZID2) {
        if (tZID == null) {
            return tZID2 == null;
        }
        if (tZID2 == null) {
            return false;
        }
        return tZID.canonical().equals(tZID2.canonical());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        SolarTime.check(this.latitude, this.longitude, this.altitude, this.calculator);
    }

    static /* synthetic */ Calculator access$100() {
        return DEFAULT_CALCULATOR;
    }

    static {
        Calculator calculator = null;
        ConcurrentHashMap<String, Calculator> concurrentHashMap = new ConcurrentHashMap<String, Calculator>();
        StdSolarCalculator[] stdSolarCalculatorArray = ResourceLoader.getInstance().services(Calculator.class).iterator();
        while (stdSolarCalculatorArray.hasNext()) {
            Calculator calculator2;
            calculator = calculator2 = stdSolarCalculatorArray.next();
            concurrentHashMap.put(calculator2.name(), calculator2);
        }
        for (StdSolarCalculator stdSolarCalculator : StdSolarCalculator.values()) {
            concurrentHashMap.put(stdSolarCalculator.name(), stdSolarCalculator);
        }
        CALCULATORS = concurrentHashMap;
        DEFAULT_CALCULATOR = calculator == null ? StdSolarCalculator.NOAA : calculator;
        JERUSALEM = SolarTime.ofLocation().easternLongitude(35, 14, 5.0).northernLatitude(31, 46, 44.0).atAltitude(721).usingCalculator(StdSolarCalculator.TIME4J).build();
        MECCA = SolarTime.ofLocation().easternLongitude(39, 49, 34.06).northernLatitude(21, 25, 21.22).atAltitude(298).usingCalculator(StdSolarCalculator.TIME4J).build();
    }

    public static class Sunshine {
        private final Moment startUTC;
        private final Moment endUTC;
        private final PlainTimestamp startLocal;
        private final PlainTimestamp endLocal;

        private Sunshine(PlainDate plainDate, Optional<Moment> optional, Optional<Moment> optional2, TZID tZID, boolean bl) {
            boolean bl2;
            Timezone timezone = Timezone.of(tZID);
            boolean bl3 = bl2 = timezone.getHistory() != null;
            if (bl) {
                this.startUTC = null;
                this.endUTC = null;
                this.startLocal = null;
                this.endLocal = null;
            } else if (optional.isPresent()) {
                this.startUTC = optional.get();
                this.startLocal = this.startUTC.toZonalTimestamp(tZID);
                if (optional2.isPresent()) {
                    this.endUTC = optional2.get();
                    this.endLocal = this.endUTC.toZonalTimestamp(tZID);
                } else if (bl2) {
                    PlainDate plainDate2 = plainDate.plus(1L, CalendarUnit.DAYS);
                    this.endUTC = plainDate2.atFirstMoment(tZID);
                    this.endLocal = plainDate2.atStartOfDay(tZID);
                } else {
                    PlainDate plainDate3 = plainDate.plus(1L, CalendarUnit.DAYS);
                    this.endUTC = plainDate3.atStartOfDay().in(timezone);
                    this.endLocal = this.endUTC.toZonalTimestamp(tZID);
                }
            } else if (optional2.isPresent()) {
                if (bl2) {
                    this.startUTC = plainDate.atFirstMoment(tZID);
                    this.startLocal = plainDate.atStartOfDay(tZID);
                    this.endUTC = optional2.get();
                    this.endLocal = this.endUTC.toZonalTimestamp(tZID);
                } else {
                    this.startUTC = plainDate.atStartOfDay().in(timezone);
                    this.startLocal = this.startUTC.toZonalTimestamp(tZID);
                    this.endUTC = optional2.get();
                    this.endLocal = this.endUTC.toZonalTimestamp(tZID);
                }
            } else if (bl2) {
                this.startUTC = plainDate.atFirstMoment(tZID);
                this.startLocal = plainDate.atStartOfDay(tZID);
                PlainDate plainDate4 = plainDate.plus(1L, CalendarUnit.DAYS);
                this.endUTC = plainDate4.atFirstMoment(tZID);
                this.endLocal = plainDate4.atStartOfDay(tZID);
            } else {
                this.startUTC = plainDate.atStartOfDay().in(timezone);
                this.startLocal = this.startUTC.toZonalTimestamp(tZID);
                PlainDate plainDate5 = plainDate.plus(1L, CalendarUnit.DAYS);
                this.endUTC = plainDate5.atStartOfDay().in(timezone);
                this.endLocal = this.endUTC.toZonalTimestamp(tZID);
            }
        }

        public Moment startUTC() {
            return Sunshine.checkAndGet(this.startUTC);
        }

        public Moment endUTC() {
            return Sunshine.checkAndGet(this.endUTC);
        }

        public PlainTimestamp startLocal() {
            return Sunshine.checkAndGet(this.startLocal);
        }

        public PlainTimestamp endLocal() {
            return Sunshine.checkAndGet(this.endLocal);
        }

        public boolean isPresent(Moment moment) {
            if (this.isAbsent()) {
                return false;
            }
            return !this.startUTC.isAfter(moment) && moment.isBefore(this.endUTC);
        }

        public boolean isPresent(PlainTimestamp plainTimestamp) {
            if (this.isAbsent()) {
                return false;
            }
            return !this.startLocal.isAfter(plainTimestamp) && plainTimestamp.isBefore(this.endLocal);
        }

        public boolean isAbsent() {
            return this.startUTC == null;
        }

        public int length() {
            if (this.isAbsent()) {
                return 0;
            }
            return (int)this.startUTC.until(this.endUTC, TimeUnit.SECONDS);
        }

        public String toString() {
            if (this.isAbsent()) {
                return "Polar night";
            }
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Sunshine[");
            stringBuilder.append("utc=");
            stringBuilder.append(this.startUTC);
            stringBuilder.append('/');
            stringBuilder.append(this.endUTC);
            stringBuilder.append(",local=");
            stringBuilder.append(this.startLocal);
            stringBuilder.append('/');
            stringBuilder.append(this.endLocal);
            stringBuilder.append(",length=");
            stringBuilder.append(this.length());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        private static <T> T checkAndGet(T t) {
            if (t == null) {
                throw new IllegalStateException("Sunshine is absent (polar night).");
            }
            return t;
        }
    }

    public static interface Calculator {
        public String name();

        public Optional<Moment> sunrise(CalendarDate var1, double var2, double var4, double var6);

        public Optional<Moment> sunset(CalendarDate var1, double var2, double var4, double var6);

        public double equationOfTime(double var1);

        default public double getFeature(double d, String string) {
            return Double.NaN;
        }

        default public double getGeodeticAngle(double d, int n) {
            return 0.0;
        }

        default public double getZenithAngle(double d, int n) {
            return 90.83333333333333 + this.getGeodeticAngle(d, n);
        }
    }

    public static class Builder {
        private double latitude = Double.NaN;
        private double longitude = Double.NaN;
        private int altitude = 0;
        private String calculator = SolarTime.access$100().name();
        private TZID observerZoneID = null;

        private Builder() {
        }

        public Builder northernLatitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 90);
            if (Double.isNaN(this.latitude)) {
                this.latitude = (double)n + (double)n2 / 60.0 + d / 3600.0;
                return this;
            }
            throw new IllegalStateException("Latitude has already been set.");
        }

        public Builder southernLatitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 90);
            if (Double.isNaN(this.latitude)) {
                this.latitude = -1.0 * ((double)n + (double)n2 / 60.0 + d / 3600.0);
                return this;
            }
            throw new IllegalStateException("Latitude has already been set.");
        }

        public Builder easternLongitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 179);
            if (Double.isNaN(this.longitude)) {
                this.longitude = (double)n + (double)n2 / 60.0 + d / 3600.0;
                return this;
            }
            throw new IllegalStateException("Longitude has already been set.");
        }

        public Builder westernLongitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 180);
            if (Double.isNaN(this.longitude)) {
                this.longitude = -1.0 * ((double)n + (double)n2 / 60.0 + d / 3600.0);
                return this;
            }
            throw new IllegalStateException("Longitude has already been set.");
        }

        public Builder atAltitude(int n) {
            if (!Double.isFinite(n)) {
                throw new IllegalArgumentException("Altitude must be finite: " + n);
            }
            if (n < 0 || n >= 11000) {
                throw new IllegalArgumentException("Meters out of range 0 <= altitude < +11,000: " + n);
            }
            this.altitude = n;
            return this;
        }

        public Builder usingCalculator(String string) {
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Missing calculator.");
            }
            if (!CALCULATORS.containsKey(string)) {
                throw new IllegalArgumentException("Unknown calculator: " + string);
            }
            this.calculator = string;
            return this;
        }

        public Builder usingCalculator(Calculator calculator) {
            CALCULATORS.putIfAbsent(calculator.name(), calculator);
            this.calculator = calculator.name();
            return this;
        }

        public Builder inTimezone(TZID tZID) {
            if (tZID == null) {
                throw new NullPointerException("Missing timezone identifier.");
            }
            this.observerZoneID = tZID;
            return this;
        }

        public SolarTime build() {
            if (Double.isNaN(this.latitude)) {
                throw new IllegalStateException("Latitude was not yet set.");
            }
            if (Double.isNaN(this.longitude)) {
                throw new IllegalStateException("Longitude was not yet set.");
            }
            return new SolarTime(this.latitude, this.longitude, this.altitude, this.calculator, this.observerZoneID);
        }

        private static void check(int n, int n2, double d, int n3) {
            if (n < 0 || n > n3 || n == n3 && n3 != 179 && (n2 > 0 || Double.compare(d, 0.0) > 0)) {
                double d2 = (double)n + (double)n2 / 60.0 + d / 3600.0;
                throw new IllegalArgumentException("Degrees out of range: " + n + " (decimal=" + d2 + ")");
            }
            if (n2 < 0 || n2 >= 60) {
                throw new IllegalArgumentException("Arc minutes out of range: " + n2);
            }
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new IllegalArgumentException("Arc seconds must be finite.");
            }
            if (Double.compare(d, 0.0) < 0 || Double.compare(d, 60.0) >= 0) {
                throw new IllegalArgumentException("Arc seconds out of range: " + d);
            }
        }
    }
}

