/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import net.time4j.calendar.IndianMonth;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.hindu.AryaSiddhanta;
import net.time4j.calendar.hindu.HinduCS;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduRule;
import net.time4j.calendar.hindu.SPX;
import net.time4j.engine.VariantSource;

public final class HinduVariant
implements VariantSource,
Serializable {
    static final GeoLocation UJJAIN = GeoLocation.of(23.15, 75.76833333333333);
    private static final HinduRule[] RULES = HinduRule.values();
    private static final int TYPE_OLD_SOLAR = -1;
    private static final int TYPE_OLD_LUNAR = -2;
    static final HinduVariant VAR_OLD_SOLAR = new HinduVariant(AryaSiddhanta.SOLAR);
    static final HinduVariant VAR_OLD_LUNAR = new HinduVariant(AryaSiddhanta.LUNAR);
    private final transient int type;
    private final transient HinduEra defaultEra;
    private final transient boolean elapsedMode;
    private final transient boolean altHinduSunrise;
    private final transient GeoLocation location;

    HinduVariant(HinduRule hinduRule, HinduEra hinduEra) {
        this(hinduRule.ordinal(), hinduEra, HinduVariant.useStandardElapsedMode(hinduEra, hinduRule), false, UJJAIN);
    }

    private HinduVariant(AryaSiddhanta aryaSiddhanta) {
        this(aryaSiddhanta == AryaSiddhanta.SOLAR ? -1 : -2, HinduEra.KALI_YUGA, true, false, UJJAIN);
    }

    private HinduVariant(int n, HinduEra hinduEra, boolean bl, boolean bl2, GeoLocation geoLocation) {
        if (n < -2 || n >= HinduRule.values().length) {
            throw new IllegalArgumentException("Undefined Hindu rule.");
        }
        if (hinduEra == null) {
            throw new NullPointerException("Missing default Hindu era.");
        }
        if (geoLocation == null) {
            throw new NullPointerException("Missing geographical location.");
        }
        this.type = n;
        this.defaultEra = hinduEra;
        this.elapsedMode = bl;
        this.altHinduSunrise = bl2;
        this.location = geoLocation;
    }

    public static HinduVariant from(String string) {
        if (string.startsWith("AryaSiddhanta@")) {
            try {
                AryaSiddhanta aryaSiddhanta = AryaSiddhanta.valueOf(string.substring("AryaSiddhanta@".length()));
                return aryaSiddhanta == AryaSiddhanta.SOLAR ? VAR_OLD_SOLAR : VAR_OLD_LUNAR;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("Invalid variant: " + string, indexOutOfBoundsException);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        HinduEra hinduEra = null;
        boolean bl = true;
        boolean bl2 = false;
        double d = UJJAIN.getLatitude();
        double d2 = UJJAIN.getLongitude();
        int n3 = UJJAIN.getAltitude();
        boolean bl3 = true;
        block13: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (++n) {
                case 1: {
                    n2 = Integer.valueOf(string2);
                    continue block13;
                }
                case 2: {
                    hinduEra = HinduEra.valueOf(string2);
                    continue block13;
                }
                case 3: {
                    bl = string2.equals("elapsed");
                    continue block13;
                }
                case 4: {
                    bl2 = string2.equals("alt");
                    continue block13;
                }
                case 5: {
                    d = Double.valueOf(string2);
                    bl3 = d == UJJAIN.getLatitude();
                    continue block13;
                }
                case 6: {
                    d2 = Double.valueOf(string2);
                    bl3 = bl3 && d2 == UJJAIN.getLongitude();
                    continue block13;
                }
                case 7: {
                    n3 = Integer.valueOf(string2);
                    bl3 = bl3 && n3 == 0;
                    continue block13;
                }
            }
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
        try {
            return new HinduVariant(n2, hinduEra, bl, bl2, bl3 ? UJJAIN : GeoLocation.of(d, d2, n3));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
    }

    public HinduEra getDefaultEra() {
        return this.defaultEra;
    }

    public GeoLocation getLocation() {
        return this.location;
    }

    public boolean isSolar() {
        return !this.isLunisolar();
    }

    public boolean isLunisolar() {
        return this.isAmanta() || this.isPurnimanta();
    }

    public boolean isAmanta() {
        if (this.type == -2) {
            return true;
        }
        return this.type >= HinduRule.AMANTA.ordinal() && this.type < HinduRule.PURNIMANTA.ordinal();
    }

    public boolean isPurnimanta() {
        return this.type == HinduRule.PURNIMANTA.ordinal();
    }

    public boolean isOld() {
        return this.type < 0;
    }

    boolean prefersRasiNames() {
        return this.type == HinduRule.MADRAS.ordinal() || this.type == HinduRule.MALAYALI.ordinal();
    }

    public boolean isUsingElapsedYears() {
        return this.elapsedMode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HinduVariant) {
            HinduVariant hinduVariant = (HinduVariant)object;
            return this.type == hinduVariant.type && this.defaultEra == hinduVariant.defaultEra && this.elapsedMode == hinduVariant.elapsedMode && this.altHinduSunrise == hinduVariant.altHinduSunrise && this.location.getLatitude() == hinduVariant.location.getLatitude() && this.location.getLongitude() == hinduVariant.location.getLongitude() && this.location.getAltitude() == hinduVariant.location.getAltitude();
        }
        return false;
    }

    public int hashCode() {
        return this.type + 17 * this.defaultEra.hashCode() + (this.elapsedMode ? 1 : 0) + (this.altHinduSunrise ? 100 : 99);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hindu-variant=[");
        switch (this.type) {
            case -1: {
                stringBuilder.append("OLD-SOLAR");
                break;
            }
            case -2: {
                stringBuilder.append("OLD-LUNAR");
                break;
            }
            default: {
                stringBuilder.append(this.getRule().name());
            }
        }
        if (!this.isOld()) {
            stringBuilder.append("|default-era=");
            stringBuilder.append(this.defaultEra.name());
            stringBuilder.append('|');
            stringBuilder.append(this.elapsedMode ? "elapsed-year-mode" : "current-year-mode");
            if (this.altHinduSunrise) {
                stringBuilder.append("|alt-hindu-sunrise");
            }
            if (this.location != UJJAIN) {
                stringBuilder.append("|lat=");
                stringBuilder.append(this.location.getLatitude());
                stringBuilder.append(",lng=");
                stringBuilder.append(this.location.getLongitude());
                int n = this.location.getAltitude();
                if (n != 0) {
                    stringBuilder.append(",alt=");
                    stringBuilder.append(n);
                }
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getVariant() {
        if (this.isOld()) {
            AryaSiddhanta aryaSiddhanta = this.type == -1 ? AryaSiddhanta.SOLAR : AryaSiddhanta.LUNAR;
            return "AryaSiddhanta@" + aryaSiddhanta.name();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type);
        stringBuilder.append('|');
        stringBuilder.append(this.defaultEra.name());
        stringBuilder.append('|');
        stringBuilder.append(this.elapsedMode ? "elapsed" : "current");
        stringBuilder.append('|');
        stringBuilder.append(this.altHinduSunrise ? "alt" : "std");
        if (this.location != UJJAIN) {
            stringBuilder.append('|');
            stringBuilder.append(this.location.getLatitude());
            stringBuilder.append('|');
            stringBuilder.append(this.location.getLongitude());
            int n = this.location.getAltitude();
            if (n != 0) {
                stringBuilder.append('|');
                stringBuilder.append(n);
            }
        }
        return stringBuilder.toString();
    }

    public HinduVariant with(HinduEra hinduEra) {
        if (this.isOld() || this.defaultEra.equals(hinduEra)) {
            return this;
        }
        return new HinduVariant(this.type, hinduEra, this.elapsedMode, this.altHinduSunrise, this.location);
    }

    public HinduVariant withElapsedYears() {
        if (this.isOld() || this.elapsedMode) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, true, this.altHinduSunrise, this.location);
    }

    public HinduVariant withCurrentYears() {
        if (this.isOld() || !this.elapsedMode) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, false, this.altHinduSunrise, this.location);
    }

    public HinduVariant withAlternativeHinduSunrise() {
        if (this.isOld() || this.altHinduSunrise) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, this.elapsedMode, true, this.location);
    }

    public HinduVariant withAlternativeLocation(GeoLocation geoLocation) {
        if (this.isOld()) {
            return this;
        }
        if (geoLocation.getLatitude() == this.location.getLatitude() && geoLocation.getLongitude() == this.location.getLongitude() && geoLocation.getAltitude() == this.location.getAltitude()) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, this.elapsedMode, this.altHinduSunrise, geoLocation);
    }

    HinduCS getCalendarSystem() {
        switch (this.type) {
            case -1: {
                return AryaSiddhanta.SOLAR.getCalendarSystem();
            }
            case -2: {
                return AryaSiddhanta.LUNAR.getCalendarSystem();
            }
        }
        return new ModernHinduCS(this);
    }

    int getFirstMonthOfYear() {
        IndianMonth indianMonth;
        if (this.isOld()) {
            return 1;
        }
        switch (this.getRule()) {
            case AMANTA_ASHADHA: {
                indianMonth = IndianMonth.ASHADHA;
                break;
            }
            case AMANTA_KARTIKA: {
                indianMonth = IndianMonth.KARTIKA;
                break;
            }
            default: {
                indianMonth = IndianMonth.CHAITRA;
            }
        }
        return indianMonth.getValue();
    }

    private static boolean useStandardElapsedMode(HinduEra hinduEra, HinduRule hinduRule) {
        switch (hinduEra) {
            case SAKA: {
                switch (hinduRule) {
                    case MADRAS: 
                    case MALAYALI: 
                    case TAMIL: {
                        return false;
                    }
                }
                return true;
            }
            case KOLLAM: {
                return false;
            }
        }
        return true;
    }

    private HinduRule getRule() {
        return RULES[this.type];
    }

    private HinduCS toAmanta() {
        return new HinduVariant(HinduRule.AMANTA.ordinal(), this.defaultEra, this.elapsedMode, this.altHinduSunrise, this.location).getCalendarSystem();
    }

    private Object writeReplace() {
        return new SPX(this, 21);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class ModernHinduCS
    extends HinduCS {
        ModernHinduCS(HinduVariant hinduVariant) {
            super(hinduVariant);
        }

        @Override
        HinduCalendar create(long l) {
            switch (this.getRule()) {
                case AMANTA_ASHADHA: 
                case AMANTA_KARTIKA: {
                    HinduCalendar hinduCalendar = this.variant.toAmanta().create(l);
                    if (hinduCalendar.getMonth().getValue().getValue() < this.variant.getFirstMonthOfYear()) {
                        hinduCalendar = new HinduCalendar(this.variant, hinduCalendar.getExpiredYearOfKaliYuga() - 1, hinduCalendar.getMonth(), hinduCalendar.getDayOfMonth(), l);
                    }
                    return hinduCalendar;
                }
            }
            return null;
        }

        @Override
        HinduCalendar create(int n, HinduMonth hinduMonth, HinduDay hinduDay) {
            switch (this.getRule()) {
                case AMANTA_ASHADHA: 
                case AMANTA_KARTIKA: {
                    if (hinduMonth.getValue().getValue() < this.variant.getFirstMonthOfYear()) {
                        ++n;
                    }
                    return this.variant.toAmanta().create(n, hinduMonth, hinduDay);
                }
            }
            return null;
        }

        @Override
        boolean isValid(int n, HinduMonth hinduMonth, HinduDay hinduDay) {
            switch (this.getRule()) {
                case AMANTA_ASHADHA: 
                case AMANTA_KARTIKA: {
                    if (hinduMonth.getValue().getValue() < this.variant.getFirstMonthOfYear()) {
                        ++n;
                    }
                    return this.variant.toAmanta().isValid(n, hinduMonth, hinduDay);
                }
            }
            return false;
        }

        @Override
        public long getMinimumSinceUTC() {
            return 0L;
        }

        @Override
        public long getMaximumSinceUTC() {
            return 0L;
        }

        private HinduRule getRule() {
            return this.variant.getRule();
        }
    }
}

