/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.util.Arrays;
import java.util.List;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduVariant;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;

abstract class HinduCS
implements CalendarSystem<HinduCalendar> {
    final HinduVariant variant;

    HinduCS(HinduVariant hinduVariant) {
        if (hinduVariant == null) {
            throw new NullPointerException();
        }
        this.variant = hinduVariant;
    }

    @Override
    public final HinduCalendar transform(long l) {
        long l2 = this.getMinimumSinceUTC();
        long l3 = this.getMaximumSinceUTC();
        if (l < l2 || l > l3) {
            throw new IllegalArgumentException("Out of range: " + l2 + " <= " + l + " <= " + l3);
        }
        return this.create(l);
    }

    @Override
    public final long transform(HinduCalendar hinduCalendar) {
        return hinduCalendar.getDaysSinceEpochUTC();
    }

    @Override
    public List<CalendarEra> getEras() {
        return Arrays.asList(HinduEra.values());
    }

    abstract HinduCalendar create(long var1);

    abstract HinduCalendar create(int var1, HinduMonth var2, HinduDay var3);

    abstract boolean isValid(int var1, HinduMonth var2, HinduDay var3);

    final boolean isExpunged(int n, HinduMonth hinduMonth, HinduDay hinduDay) {
        HinduCalendar hinduCalendar = this.create(n, hinduMonth, hinduDay);
        return !hinduCalendar.equals(this.create(hinduCalendar.getDaysSinceEpochUTC()));
    }

    static double modulo(double d, double d2) {
        return d - d2 * Math.floor(d / d2);
    }
}

