/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.AstronomicalHijriData;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.HijriAdjustment;
import net.time4j.calendar.HijriAlgorithm;
import net.time4j.calendar.HijriData;
import net.time4j.calendar.HijriEra;
import net.time4j.calendar.HijriMonth;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.RelatedGregorianYearRule;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.calendar.service.WeekdayRule;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.ValidationElement;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="islamic")
public final class HijriCalendar
extends CalendarVariant<HijriCalendar>
implements LocalizedPatternSupport {
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<HijriEra> ERA = new StdEnumDateElement<HijriEra, HijriCalendar>("ERA", HijriCalendar.class, HijriEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, HijriCalendar> YEAR_OF_ERA = new StdIntegerDateElement<HijriCalendar>("YEAR_OF_ERA", HijriCalendar.class, Integer.MIN_VALUE, Integer.MAX_VALUE, 'y', new HijriMonth.Operator(-12), new HijriMonth.Operator(12));
    @FormattableElement(format="M", alt="L")
    public static final StdCalendarElement<HijriMonth, HijriCalendar> MONTH_OF_YEAR = new StdEnumDateElement<HijriMonth, HijriCalendar>("MONTH_OF_YEAR", HijriCalendar.class, HijriMonth.class, 'M', new HijriMonth.Operator(-1), new HijriMonth.Operator(1));
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, HijriCalendar> DAY_OF_MONTH = new StdIntegerDateElement<HijriCalendar>("DAY_OF_MONTH", HijriCalendar.class, 1, 30, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, HijriCalendar> DAY_OF_YEAR = new StdIntegerDateElement<HijriCalendar>("DAY_OF_YEAR", HijriCalendar.class, 1, 355, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, HijriCalendar> DAY_OF_WEEK = new StdWeekdayElement<HijriCalendar>(HijriCalendar.class, HijriCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<HijriCalendar> WIM_ELEMENT = new WeekdayInMonthElement<HijriCalendar>(HijriCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<HijriCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    public static final String VARIANT_UMALQURA = "islamic-umalqura";
    @Deprecated
    public static final String VARIANT_ICU4J = "islamic-icu4j";
    public static final String VARIANT_DIYANET = "islamic-diyanet";
    private static final Map<String, EraYearMonthDaySystem<HijriCalendar>> CALSYS;
    private static final CalendarFamily<HijriCalendar> ENGINE;
    public static final StdCalendarElement<Weekday, HijriCalendar> LOCAL_DAY_OF_WEEK;
    public static final StdCalendarElement<Integer, HijriCalendar> WEEK_OF_YEAR;
    public static final StdCalendarElement<Integer, HijriCalendar> WEEK_OF_MONTH;
    public static final StdCalendarElement<Integer, HijriCalendar> BOUNDED_WEEK_OF_YEAR;
    public static final StdCalendarElement<Integer, HijriCalendar> BOUNDED_WEEK_OF_MONTH;
    private static final long serialVersionUID = 4666707700222367373L;
    private final transient int hyear;
    private final transient int hmonth;
    private final transient int hdom;
    private final transient String variant;

    private HijriCalendar(int n, int n2, int n3, String string) {
        this.hyear = n;
        this.hmonth = n2;
        this.hdom = n3;
        this.variant = string;
    }

    public static HijriCalendar of(String string, int n, HijriMonth hijriMonth, int n2) {
        return HijriCalendar.of(string, n, hijriMonth.getValue(), n2);
    }

    public static HijriCalendar of(String string, int n, int n2, int n3) {
        EraYearMonthDaySystem<HijriCalendar> eraYearMonthDaySystem = HijriCalendar.getCalendarSystem(string);
        if (!eraYearMonthDaySystem.isValid(HijriEra.ANNO_HEGIRAE, n, n2, n3)) {
            throw new IllegalArgumentException("Invalid hijri date: year=" + n + ", month=" + n2 + ", day=" + n3);
        }
        return new HijriCalendar(n, n2, n3, string);
    }

    public static HijriCalendar of(VariantSource variantSource, int n, HijriMonth hijriMonth, int n2) {
        return HijriCalendar.of(variantSource.getVariant(), n, hijriMonth.getValue(), n2);
    }

    public static HijriCalendar of(VariantSource variantSource, int n, int n2, int n3) {
        return HijriCalendar.of(variantSource.getVariant(), n, n2, n3);
    }

    public static HijriCalendar ofUmalqura(int n, HijriMonth hijriMonth, int n2) {
        return HijriCalendar.of(VARIANT_UMALQURA, n, hijriMonth.getValue(), n2);
    }

    public static HijriCalendar ofUmalqura(int n, int n2, int n3) {
        return HijriCalendar.of(VARIANT_UMALQURA, n, n2, n3);
    }

    public static HijriCalendar nowInSystemTime(String string, StartOfDay startOfDay) {
        return SystemClock.inLocalView().now(HijriCalendar.family(), string, startOfDay).toDate();
    }

    public static HijriCalendar nowInSystemTime(VariantSource variantSource, StartOfDay startOfDay) {
        return SystemClock.inLocalView().now(HijriCalendar.family(), variantSource, startOfDay).toDate();
    }

    public HijriEra getEra() {
        return HijriEra.ANNO_HEGIRAE;
    }

    public int getYear() {
        return this.hyear;
    }

    public HijriMonth getMonth() {
        return HijriMonth.valueOf(this.hmonth);
    }

    public int getDayOfMonth() {
        return this.hdom;
    }

    public Weekday getDayOfWeek() {
        long l = HijriCalendar.getCalendarSystem(this.variant).transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return (Integer)this.get(DAY_OF_YEAR);
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    public int lengthOfMonth() {
        return this.getCalendarSystem().getLengthOfMonth(HijriEra.ANNO_HEGIRAE, this.hyear, this.hmonth);
    }

    public int lengthOfYear() {
        try {
            return this.getCalendarSystem().getLengthOfYear(HijriEra.ANNO_HEGIRAE, this.hyear);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ChronoException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public static boolean isValid(String string, int n, int n2, int n3) {
        EraYearMonthDaySystem<HijriCalendar> eraYearMonthDaySystem = CALSYS.get(string);
        return eraYearMonthDaySystem != null && eraYearMonthDaySystem.isValid(HijriEra.ANNO_HEGIRAE, n, n2, n3);
    }

    public HijriCalendar nextYear() {
        return this.with(YEAR_OF_ERA.incremented());
    }

    public HijriCalendar nextMonth() {
        return this.with(MONTH_OF_YEAR.incremented());
    }

    public HijriCalendar nextDay() {
        return this.with(DAY_OF_MONTH.incremented());
    }

    public GeneralTimestamp<HijriCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<HijriCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    public HijriCalendar plus(int n, Unit unit) {
        try {
            return unit.addTo(this, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException(illegalArgumentException.getMessage());
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public HijriCalendar minus(int n, Unit unit) {
        return this.plus(MathUtils.safeNegate(n), unit);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HijriCalendar) {
            HijriCalendar hijriCalendar = (HijriCalendar)object;
            return this.hdom == hijriCalendar.hdom && this.hmonth == hijriCalendar.hmonth && this.hyear == hijriCalendar.hyear && this.variant.equals(hijriCalendar.variant);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.hdom + 31 * this.hmonth + 37 * this.hyear ^ this.variant.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("AH-");
        String string = String.valueOf(this.hyear);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (this.hmonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.hmonth);
        stringBuilder.append('-');
        if (this.hdom < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.hdom);
        stringBuilder.append('[');
        stringBuilder.append(this.variant);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SUNDAY, 1, Weekday.FRIDAY, Weekday.SATURDAY);
    }

    public static CalendarFamily<HijriCalendar> family() {
        return ENGINE;
    }

    public static void register(HijriData hijriData) {
        String string = "islamic-" + hijriData.name();
        hijriData.prepare();
        try {
            AstronomicalHijriData astronomicalHijriData = new AstronomicalHijriData(hijriData);
            CALSYS.put(string, astronomicalHijriData);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Invalid Hijri data.", runtimeException);
        }
    }

    public static String getVersion(String string) {
        EraYearMonthDaySystem<HijriCalendar> eraYearMonthDaySystem = HijriCalendar.getCalendarSystem(string);
        if (eraYearMonthDaySystem instanceof AstronomicalHijriData) {
            return ((AstronomicalHijriData)AstronomicalHijriData.class.cast(eraYearMonthDaySystem)).getVersion();
        }
        return "";
    }

    @Override
    protected CalendarFamily<HijriCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected HijriCalendar getContext() {
        return this;
    }

    @Override
    protected EraYearMonthDaySystem<HijriCalendar> getCalendarSystem() {
        return HijriCalendar.getCalendarSystem(this.variant);
    }

    private static EraYearMonthDaySystem<HijriCalendar> getCalendarSystem(String string) {
        EraYearMonthDaySystem<HijriCalendar> eraYearMonthDaySystem = CALSYS.get(string);
        if (eraYearMonthDaySystem == null) {
            throw new ChronoException("Unsupported calendar variant: " + string);
        }
        return eraYearMonthDaySystem;
    }

    private Object writeReplace() {
        return new SPX(this, 1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        VariantMap variantMap = new VariantMap();
        variantMap.put(VARIANT_UMALQURA, AstronomicalHijriData.UMALQURA);
        for (HijriAlgorithm hijriAlgorithm : HijriAlgorithm.values()) {
            variantMap.put(hijriAlgorithm.getVariant(), hijriAlgorithm.getCalendarSystem(0));
        }
        CALSYS = variantMap;
        Chronology.Builder builder = ((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)CalendarFamily.Builder.setUp(HijriCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement((ChronoElement)YEAR_OF_ERA, (ElementRule)new IntegerRule(0))).appendElement((ChronoElement)MONTH_OF_YEAR, (ElementRule)new MonthRule())).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<HijriCalendar>(CALSYS, DAY_OF_YEAR))).appendElement((ChronoElement)DAY_OF_MONTH, (ElementRule)new IntegerRule(2))).appendElement((ChronoElement)DAY_OF_YEAR, (ElementRule)new IntegerRule(3))).appendElement((ChronoElement)DAY_OF_WEEK, new WeekdayRule<HijriCalendar>(HijriCalendar.getDefaultWeekmodel(), hijriCalendar -> ((CalendarFamily)hijriCalendar.getChronology()).getCalendarSystem(hijriCalendar.getVariant())))).appendElement(WIM_ELEMENT, (ElementRule)WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendExtension(new CommonElements.Weekengine(HijriCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, HijriCalendar.getDefaultWeekmodel()));
        ENGINE = ((CalendarFamily.Builder)builder).build();
        LOCAL_DAY_OF_WEEK = CommonElements.localDayOfWeek(HijriCalendar.family(), HijriCalendar.getDefaultWeekmodel());
        WEEK_OF_YEAR = CommonElements.weekOfYear(HijriCalendar.family(), HijriCalendar.getDefaultWeekmodel());
        WEEK_OF_MONTH = CommonElements.weekOfMonth(HijriCalendar.family(), HijriCalendar.getDefaultWeekmodel());
        BOUNDED_WEEK_OF_YEAR = CommonElements.boundedWeekOfYear(HijriCalendar.family(), HijriCalendar.getDefaultWeekmodel());
        BOUNDED_WEEK_OF_MONTH = CommonElements.boundedWeekOfMonth(HijriCalendar.family(), HijriCalendar.getDefaultWeekmodel());
    }

    private static class Merger
    implements ChronoMerger<HijriCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("islamic", displayStyle, locale);
        }

        @Override
        public HijriCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            String string = attributeQuery.get(Attributes.CALENDAR_VARIANT, "");
            if (string.isEmpty()) {
                return null;
            }
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (HijriCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, string, tZID, startOfDay).toDate();
        }

        @Override
        public HijriCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            String string = attributeQuery.get(Attributes.CALENDAR_VARIANT, "");
            if (string.isEmpty()) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Hijri calendar variant.");
                return null;
            }
            EraYearMonthDaySystem eraYearMonthDaySystem = (EraYearMonthDaySystem)CALSYS.get(string);
            if (eraYearMonthDaySystem == null) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Unknown Hijri calendar variant: " + string);
                return null;
            }
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing islamic year.");
                return null;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2 = ((HijriMonth)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 != Integer.MIN_VALUE) {
                    if (eraYearMonthDaySystem.isValid(HijriEra.ANNO_HEGIRAE, n, n2, n3)) {
                        return HijriCalendar.of(string, n, n2, n3);
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hijri date.");
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 > 0) {
                        int n5 = 1;
                        int n6 = 0;
                        while (n5 <= 12) {
                            int n7 = eraYearMonthDaySystem.getLengthOfMonth(HijriEra.ANNO_HEGIRAE, n, n5);
                            if (n4 > n6 + n7) {
                                ++n5;
                                n6 += n7;
                                continue;
                            }
                            int n8 = n4 - n6;
                            return HijriCalendar.of(string, n, n5, n8);
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hijri date.");
                }
            }
            return null;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.EVENING;
        }

        @Override
        public int getDefaultPivotYear() {
            return HijriCalendar.nowInSystemTime(HijriAlgorithm.WEST_ISLAMIC_CIVIL, StartOfDay.MIDNIGHT).getYear() + 20;
        }
    }

    private static class EraRule
    implements ElementRule<HijriCalendar, HijriEra> {
        private EraRule() {
        }

        @Override
        public HijriEra getValue(HijriCalendar hijriCalendar) {
            return HijriEra.ANNO_HEGIRAE;
        }

        @Override
        public HijriEra getMinimum(HijriCalendar hijriCalendar) {
            return HijriEra.ANNO_HEGIRAE;
        }

        @Override
        public HijriEra getMaximum(HijriCalendar hijriCalendar) {
            return HijriEra.ANNO_HEGIRAE;
        }

        @Override
        public boolean isValid(HijriCalendar hijriCalendar, HijriEra hijriEra) {
            return hijriEra != null;
        }

        @Override
        public HijriCalendar withValue(HijriCalendar hijriCalendar, HijriEra hijriEra, boolean bl) {
            if (hijriEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return hijriCalendar;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HijriCalendar hijriCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HijriCalendar hijriCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<HijriCalendar, HijriMonth> {
        private MonthRule() {
        }

        @Override
        public HijriMonth getValue(HijriCalendar hijriCalendar) {
            return hijriCalendar.getMonth();
        }

        @Override
        public HijriMonth getMinimum(HijriCalendar hijriCalendar) {
            return HijriMonth.MUHARRAM;
        }

        @Override
        public HijriMonth getMaximum(HijriCalendar hijriCalendar) {
            return HijriMonth.DHU_AL_HIJJAH;
        }

        @Override
        public boolean isValid(HijriCalendar hijriCalendar, HijriMonth hijriMonth) {
            return hijriMonth != null;
        }

        @Override
        public HijriCalendar withValue(HijriCalendar hijriCalendar, HijriMonth hijriMonth, boolean bl) {
            if (hijriMonth == null) {
                throw new IllegalArgumentException("Missing month.");
            }
            int n = hijriMonth.getValue();
            int n2 = hijriCalendar.getCalendarSystem().getLengthOfMonth(HijriEra.ANNO_HEGIRAE, hijriCalendar.hyear, n);
            int n3 = Math.min(hijriCalendar.hdom, n2);
            return new HijriCalendar(hijriCalendar.hyear, n, n3, hijriCalendar.getVariant());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HijriCalendar hijriCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HijriCalendar hijriCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements ElementRule<HijriCalendar, Integer> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public Integer getValue(HijriCalendar hijriCalendar) {
            switch (this.index) {
                case 0: {
                    return hijriCalendar.hyear;
                }
                case 2: {
                    return hijriCalendar.hdom;
                }
                case 3: {
                    int n = 0;
                    CalendarSystem calendarSystem = hijriCalendar.getCalendarSystem();
                    for (int i = 1; i < hijriCalendar.hmonth; ++i) {
                        n += calendarSystem.getLengthOfMonth(HijriEra.ANNO_HEGIRAE, hijriCalendar.hyear, i);
                    }
                    return n + hijriCalendar.hdom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMinimum(HijriCalendar hijriCalendar) {
            switch (this.index) {
                case 0: {
                    CalendarSystem calendarSystem = hijriCalendar.getCalendarSystem();
                    return ((HijriCalendar)calendarSystem.transform(calendarSystem.getMinimumSinceUTC())).hyear;
                }
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMaximum(HijriCalendar hijriCalendar) {
            CalendarSystem calendarSystem = hijriCalendar.getCalendarSystem();
            switch (this.index) {
                case 0: {
                    return ((HijriCalendar)calendarSystem.transform(calendarSystem.getMaximumSinceUTC())).hyear;
                }
                case 2: {
                    return calendarSystem.getLengthOfMonth(HijriEra.ANNO_HEGIRAE, hijriCalendar.hyear, hijriCalendar.hmonth);
                }
                case 3: {
                    return calendarSystem.getLengthOfYear(HijriEra.ANNO_HEGIRAE, hijriCalendar.hyear);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(HijriCalendar hijriCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            Integer n2 = this.getMinimum(hijriCalendar);
            Integer n3 = this.getMaximum(hijriCalendar);
            return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
        }

        @Override
        public HijriCalendar withValue(HijriCalendar hijriCalendar, Integer n, boolean bl) {
            if (!this.isValid(hijriCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    int n2 = n;
                    int n3 = hijriCalendar.getCalendarSystem().getLengthOfMonth(HijriEra.ANNO_HEGIRAE, n2, hijriCalendar.hmonth);
                    int n4 = Math.min(hijriCalendar.hdom, n3);
                    return HijriCalendar.of(hijriCalendar.getVariant(), n2, hijriCalendar.hmonth, n4);
                }
                case 2: {
                    return new HijriCalendar(hijriCalendar.hyear, hijriCalendar.hmonth, n, hijriCalendar.getVariant());
                }
                case 3: {
                    int n5 = n - this.getValue(hijriCalendar);
                    return (HijriCalendar)hijriCalendar.plus(CalendarDays.of(n5));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HijriCalendar hijriCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HijriCalendar hijriCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }
    }

    private static class VariantMap
    extends ConcurrentHashMap<String, EraYearMonthDaySystem<HijriCalendar>> {
        private VariantMap() {
        }

        @Override
        public EraYearMonthDaySystem<HijriCalendar> get(Object object) {
            EraYearMonthDaySystem eraYearMonthDaySystem = (EraYearMonthDaySystem)super.get(object);
            if (eraYearMonthDaySystem == null) {
                Object object2;
                String string = object.toString();
                if (object.equals(HijriCalendar.VARIANT_UMALQURA)) {
                    eraYearMonthDaySystem = AstronomicalHijriData.UMALQURA;
                } else {
                    object2 = HijriAdjustment.from(string);
                    String string2 = ((HijriAdjustment)object2).getBaseVariant();
                    for (HijriAlgorithm hijriAlgorithm : HijriAlgorithm.values()) {
                        if (!hijriAlgorithm.getVariant().equals(string2)) continue;
                        eraYearMonthDaySystem = hijriAlgorithm.getCalendarSystem(((HijriAdjustment)object2).getValue());
                        break;
                    }
                    if (eraYearMonthDaySystem == null) {
                        try {
                            eraYearMonthDaySystem = new AstronomicalHijriData(string);
                        }
                        catch (IOException | ChronoException exception) {
                            return null;
                        }
                    }
                }
                object2 = this.putIfAbsent(string, eraYearMonthDaySystem);
                if (object2 != null) {
                    eraYearMonthDaySystem = object2;
                }
            }
            return eraYearMonthDaySystem;
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.061728E7),
        MONTHS(2551440.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public int between(HijriCalendar hijriCalendar, HijriCalendar hijriCalendar2, String string) {
            switch (this) {
                case YEARS: {
                    return MONTHS.between(hijriCalendar, hijriCalendar2, string) / 12;
                }
                case MONTHS: {
                    HijriCalendar hijriCalendar3 = (HijriCalendar)hijriCalendar.withVariant(string);
                    HijriCalendar hijriCalendar4 = (HijriCalendar)hijriCalendar2.withVariant(string);
                    int n = hijriCalendar4.hyear * 12 + (hijriCalendar4.hmonth - 1) - hijriCalendar3.hyear * 12 - (hijriCalendar3.hmonth - 1);
                    if (n > 0 && hijriCalendar4.hdom < hijriCalendar3.hdom) {
                        --n;
                    } else if (n < 0 && hijriCalendar4.hdom > hijriCalendar3.hdom) {
                        ++n;
                    }
                    return n;
                }
                case WEEKS: {
                    return DAYS.between(hijriCalendar, hijriCalendar2, string) / 7;
                }
                case DAYS: {
                    return (int)CalendarDays.between(hijriCalendar, hijriCalendar2).getAmount();
                }
            }
            throw new UnsupportedOperationException(this.name());
        }

        public int between(HijriCalendar hijriCalendar, HijriCalendar hijriCalendar2, VariantSource variantSource) {
            return this.between(hijriCalendar, hijriCalendar2, variantSource.getVariant());
        }

        HijriCalendar addTo(HijriCalendar hijriCalendar, int n) {
            switch (this) {
                case YEARS: {
                    return (HijriCalendar)hijriCalendar.with((ChronoElement<Integer>)YEAR_OF_ERA, MathUtils.safeAdd(hijriCalendar.getYear(), n));
                }
                case MONTHS: {
                    int n2 = MathUtils.safeAdd(hijriCalendar.hyear * 12 + (hijriCalendar.hmonth - 1), n);
                    int n3 = MathUtils.floorDivide(n2, 12);
                    int n4 = MathUtils.floorModulo(n2, 12) + 1;
                    int n5 = hijriCalendar.getCalendarSystem().getLengthOfMonth(HijriEra.ANNO_HEGIRAE, n3, n4);
                    int n6 = Math.min(hijriCalendar.hdom, n5);
                    return HijriCalendar.of(hijriCalendar.getVariant(), n3, n4, n6);
                }
                case WEEKS: {
                    return DAYS.addTo(hijriCalendar, MathUtils.safeMultiply(n, 7));
                }
                case DAYS: {
                    return (HijriCalendar)hijriCalendar.plus(CalendarDays.of(n));
                }
            }
            throw new UnsupportedOperationException(this.name());
        }
    }
}

