/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ParseLog;

public final class MultiFormatParser<T extends ChronoEntity<T>>
implements ChronoParser<T> {
    private final ChronoFormatter<T>[] parsers;

    private MultiFormatParser(ChronoFormatter<T>[] chronoFormatterArray) {
        for (ChronoFormatter<T> chronoFormatter : this.parsers = chronoFormatterArray) {
            if (chronoFormatter != null) continue;
            throw new NullPointerException("Null format cannot be set.");
        }
    }

    @SafeVarargs
    public static <T extends ChronoEntity<T>> MultiFormatParser<T> of(ChronoFormatter<T> ... chronoFormatterArray) {
        ChronoFormatter<T>[] chronoFormatterArray2 = Arrays.copyOf(chronoFormatterArray, chronoFormatterArray.length);
        return new MultiFormatParser<T>(chronoFormatterArray2);
    }

    public static <T extends ChronoEntity<T>> MultiFormatParser<T> of(List<ChronoFormatter<T>> list) {
        ChronoFormatter[] chronoFormatterArray = list.toArray((ChronoFormatter[])Array.newInstance(ChronoFormatter.class, list.size()));
        return new MultiFormatParser<T>(chronoFormatterArray);
    }

    @Override
    public T parse(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        for (int i = 0; i < this.parsers.length; ++i) {
            parseLog.reset();
            parseLog.setPosition(0);
            ChronoEntity chronoEntity = (ChronoEntity)this.parsers[i].parse(charSequence, parseLog);
            if (chronoEntity == null || parseLog.isError() || !this.parsers[i].isToleratingTrailingChars() && parseLog.getPosition() != charSequence.length()) continue;
            return (T)chronoEntity;
        }
        throw new ParseException("Not matched by any format: " + charSequence, charSequence.length());
    }

    @Override
    public T parse(CharSequence charSequence, ParseLog parseLog) {
        int n = parseLog.getPosition();
        for (int i = 0; i < this.parsers.length; ++i) {
            parseLog.reset();
            parseLog.setPosition(n);
            ChronoEntity chronoEntity = (ChronoEntity)this.parsers[i].parse(charSequence, parseLog);
            if (chronoEntity == null || parseLog.isError()) continue;
            return (T)chronoEntity;
        }
        parseLog.setError(parseLog.getErrorIndex(), "Not matched by any format: " + charSequence);
        return null;
    }

    @Override
    public T parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        int n = parseLog.getPosition();
        for (int i = 0; i < this.parsers.length; ++i) {
            parseLog.reset();
            parseLog.setPosition(n);
            ChronoEntity chronoEntity = (ChronoEntity)this.parsers[i].parse(charSequence, parseLog, attributeQuery);
            if (chronoEntity == null || parseLog.isError()) continue;
            return (T)chronoEntity;
        }
        parseLog.setError(parseLog.getErrorIndex(), "Not matched by any format: " + charSequence);
        return null;
    }
}

