/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.Chronology;
import net.time4j.engine.Temporal;
import net.time4j.engine.VariantSource;

public interface CalendarDate
extends Temporal<CalendarDate> {
    public long getDaysSinceEpochUTC();

    default public <T extends Calendrical<?, T>> T transform(Chronology<T> chronology) {
        long l = this.getDaysSinceEpochUTC();
        CalendarSystem<T> calendarSystem = chronology.getCalendarSystem();
        if (calendarSystem.getMinimumSinceUTC() > l || calendarSystem.getMaximumSinceUTC() < l) {
            throw new ArithmeticException("Cannot transform <" + l + "> to: " + chronology.getChronoType().getName());
        }
        return (T)((Calendrical)calendarSystem.transform(l));
    }

    default public <T extends CalendarVariant<T>> T transform(CalendarFamily<T> calendarFamily, String string) {
        long l = this.getDaysSinceEpochUTC();
        CalendarSystem<T> calendarSystem = calendarFamily.getCalendarSystem(string);
        if (calendarSystem.getMinimumSinceUTC() > l || calendarSystem.getMaximumSinceUTC() < l) {
            throw new ArithmeticException("Cannot transform <" + l + "> to: " + calendarFamily.getChronoType().getName());
        }
        return (T)((CalendarVariant)calendarSystem.transform(l));
    }

    default public <T extends CalendarVariant<T>> T transform(CalendarFamily<T> calendarFamily, VariantSource variantSource) {
        return this.transform(calendarFamily, variantSource.getVariant());
    }

    default public <T extends Calendrical<?, T>> T transform(Class<T> clazz) {
        String string = clazz.getName();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + string);
        }
        long l = this.getDaysSinceEpochUTC();
        CalendarSystem<T> calendarSystem = chronology.getCalendarSystem();
        if (calendarSystem.getMinimumSinceUTC() > l || calendarSystem.getMaximumSinceUTC() < l) {
            throw new ArithmeticException("Cannot transform <" + l + "> to: " + string);
        }
        return (T)((Calendrical)calendarSystem.transform(l));
    }

    default public <T extends CalendarVariant<T>> T transform(Class<T> clazz, String string) {
        String string2 = clazz.getName();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + string2);
        }
        long l = this.getDaysSinceEpochUTC();
        CalendarSystem<T> calendarSystem = chronology.getCalendarSystem(string);
        if (calendarSystem.getMinimumSinceUTC() > l || calendarSystem.getMaximumSinceUTC() < l) {
            throw new ArithmeticException("Cannot transform <" + l + "> to: " + string2);
        }
        return (T)((CalendarVariant)calendarSystem.transform(l));
    }

    default public <T extends CalendarVariant<T>> T transform(Class<T> clazz, VariantSource variantSource) {
        return this.transform(clazz, variantSource.getVariant());
    }
}

