/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.base.MathUtils;
import net.time4j.calendar.ChineseCalendar;
import net.time4j.calendar.CopticCalendar;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.EthiopianCalendar;
import net.time4j.calendar.EthiopianEra;
import net.time4j.calendar.EthiopianTime;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.calendar.HebrewMonth;
import net.time4j.calendar.HebrewTime;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HistoricCalendar;
import net.time4j.calendar.IndianCalendar;
import net.time4j.calendar.JapaneseCalendar;
import net.time4j.calendar.JucheCalendar;
import net.time4j.calendar.JulianCalendar;
import net.time4j.calendar.KoreanCalendar;
import net.time4j.calendar.MinguoCalendar;
import net.time4j.calendar.PersianCalendar;
import net.time4j.calendar.ThaiSolarCalendar;
import net.time4j.calendar.VietnameseCalendar;
import net.time4j.engine.EpochDays;
import net.time4j.history.HistoricEra;

final class SPX
implements Externalizable {
    static final int HIJRI = 1;
    static final int PERSIAN = 2;
    static final int COPTIC = 3;
    static final int ETHIOPIAN_DATE = 4;
    static final int ETHIOPIAN_TIME = 5;
    static final int MINGUO = 6;
    static final int JULIAN = 7;
    static final int THAI_SOLAR = 8;
    static final int JAPANESE = 9;
    static final int INDIAN = 10;
    static final int HISTORIC = 11;
    static final int HEBREW_DATE = 12;
    static final int HEBREW_TIME = 13;
    static final int CHINESE = 14;
    static final int KOREAN = 15;
    static final int VIETNAMESE = 16;
    static final int JUCHE = 17;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 1: {
                this.writeHijri(objectOutput);
                break;
            }
            case 2: {
                this.writePersian(objectOutput);
                break;
            }
            case 3: {
                this.writeCoptic(objectOutput);
                break;
            }
            case 4: {
                this.writeEthiopianDate(objectOutput);
                break;
            }
            case 5: {
                this.writeEthiopianTime(objectOutput);
                break;
            }
            case 6: {
                this.writeMinguo(objectOutput);
                break;
            }
            case 7: {
                this.writeJulian(objectOutput);
                break;
            }
            case 8: {
                this.writeThaiSolar(objectOutput);
                break;
            }
            case 9: {
                this.writeJapanese(objectOutput);
                break;
            }
            case 10: {
                this.writeIndian(objectOutput);
                break;
            }
            case 11: {
                this.writeHistoric(objectOutput);
                break;
            }
            case 12: {
                this.writeHebrewDate(objectOutput);
                break;
            }
            case 13: {
                this.writeHebrewTime(objectOutput);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                this.writeEAC(objectOutput);
                break;
            }
            case 17: {
                this.writeJuche(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported calendar type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by) {
            case 1: {
                this.obj = this.readHijri(objectInput);
                break;
            }
            case 2: {
                this.obj = this.readPersian(objectInput);
                break;
            }
            case 3: {
                this.obj = this.readCoptic(objectInput);
                break;
            }
            case 4: {
                this.obj = this.readEthiopianDate(objectInput);
                break;
            }
            case 5: {
                this.obj = this.readEthiopianTime(objectInput);
                break;
            }
            case 6: {
                this.obj = this.readMinguo(objectInput);
                break;
            }
            case 7: {
                this.obj = this.readJulian(objectInput);
                break;
            }
            case 8: {
                this.obj = this.readThaiSolar(objectInput);
                break;
            }
            case 9: {
                this.obj = this.readJapanese(objectInput);
                break;
            }
            case 10: {
                this.obj = this.readIndian(objectInput);
                break;
            }
            case 11: {
                this.obj = this.readHistoric(objectInput);
                break;
            }
            case 12: {
                this.obj = this.readHebrewDate(objectInput);
                break;
            }
            case 13: {
                this.obj = this.readHebrewTime(objectInput);
                break;
            }
            case 14: {
                this.obj = this.readChinese(objectInput);
                break;
            }
            case 15: {
                this.obj = this.readKorean(objectInput);
                break;
            }
            case 16: {
                this.obj = this.readVietnamese(objectInput);
                break;
            }
            case 17: {
                this.obj = this.readJuche(objectInput);
                break;
            }
            default: {
                throw new InvalidObjectException("Unknown calendar type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeHijri(ObjectOutput objectOutput) throws IOException {
        HijriCalendar hijriCalendar = (HijriCalendar)this.obj;
        objectOutput.writeUTF(hijriCalendar.getVariant());
        objectOutput.writeUTF(HijriCalendar.getVersion(hijriCalendar.getVariant()));
        objectOutput.writeInt(hijriCalendar.getYear());
        objectOutput.writeByte(hijriCalendar.getMonth().getValue());
        objectOutput.writeByte(hijriCalendar.getDayOfMonth());
    }

    private HijriCalendar readHijri(ObjectInput objectInput) throws IOException {
        String string = objectInput.readUTF();
        String string2 = objectInput.readUTF();
        if (!HijriCalendar.getVersion(string).equals(string2)) {
            throw new InvalidObjectException("Hijri calendar object with different data version not supported: " + string + "/" + string2);
        }
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return HijriCalendar.of(string, n, (int)by, (int)by2);
    }

    private void writePersian(ObjectOutput objectOutput) throws IOException {
        PersianCalendar persianCalendar = (PersianCalendar)this.obj;
        objectOutput.writeInt(persianCalendar.getYear());
        objectOutput.writeByte(persianCalendar.getMonth().getValue());
        objectOutput.writeByte(persianCalendar.getDayOfMonth());
    }

    private PersianCalendar readPersian(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return PersianCalendar.of(n, by, (int)by2);
    }

    private void writeCoptic(ObjectOutput objectOutput) throws IOException {
        CopticCalendar copticCalendar = (CopticCalendar)this.obj;
        objectOutput.writeInt(copticCalendar.getYear());
        objectOutput.writeByte(copticCalendar.getMonth().getValue());
        objectOutput.writeByte(copticCalendar.getDayOfMonth());
    }

    private CopticCalendar readCoptic(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return CopticCalendar.of(n, by, (int)by2);
    }

    private void writeEthiopianDate(ObjectOutput objectOutput) throws IOException {
        EthiopianCalendar ethiopianCalendar = (EthiopianCalendar)this.obj;
        objectOutput.writeByte(ethiopianCalendar.getEra().ordinal());
        objectOutput.writeInt(ethiopianCalendar.getYear());
        objectOutput.writeByte(ethiopianCalendar.getMonth().getValue());
        objectOutput.writeByte(ethiopianCalendar.getDayOfMonth());
    }

    private EthiopianCalendar readEthiopianDate(ObjectInput objectInput) throws IOException {
        EthiopianEra ethiopianEra = EthiopianEra.values()[objectInput.readByte()];
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return EthiopianCalendar.of(ethiopianEra, n, by, (int)by2);
    }

    private void writeEthiopianTime(ObjectOutput objectOutput) throws IOException {
        EthiopianTime ethiopianTime = (EthiopianTime)this.obj;
        int n = ethiopianTime.get(EthiopianTime.DIGITAL_HOUR_OF_DAY) * 3600 + ethiopianTime.getMinute() * 60 + ethiopianTime.getSecond();
        objectOutput.writeInt(n);
    }

    private EthiopianTime readEthiopianTime(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        int n2 = n % 60;
        int n3 = n / 60;
        int n4 = n3 % 60;
        int n5 = n3 / 60;
        PlainTime plainTime = PlainTime.of(n5, n4, n2);
        return EthiopianTime.from(plainTime);
    }

    private void writeMinguo(ObjectOutput objectOutput) throws IOException {
        MinguoCalendar minguoCalendar = (MinguoCalendar)this.obj;
        objectOutput.writeObject(minguoCalendar.toISO());
    }

    private MinguoCalendar readMinguo(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PlainDate plainDate = (PlainDate)PlainDate.class.cast(objectInput.readObject());
        return plainDate.transform(MinguoCalendar.class);
    }

    private void writeJulian(ObjectOutput objectOutput) throws IOException {
        JulianCalendar julianCalendar = (JulianCalendar)this.obj;
        objectOutput.writeInt(julianCalendar.getProlepticYear());
        objectOutput.writeInt(julianCalendar.getMonth().getValue());
        objectOutput.writeInt(julianCalendar.getDayOfMonth());
    }

    private JulianCalendar readJulian(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        int n3 = objectInput.readInt();
        HistoricEra historicEra = n >= 1 ? HistoricEra.AD : HistoricEra.BC;
        int n4 = n >= 1 ? n : MathUtils.safeSubtract(1, n);
        return JulianCalendar.of(historicEra, n4, n2, n3);
    }

    private void writeThaiSolar(ObjectOutput objectOutput) throws IOException {
        ThaiSolarCalendar thaiSolarCalendar = (ThaiSolarCalendar)this.obj;
        objectOutput.writeObject(thaiSolarCalendar.toISO());
    }

    private ThaiSolarCalendar readThaiSolar(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PlainDate plainDate = (PlainDate)PlainDate.class.cast(objectInput.readObject());
        return plainDate.transform(ThaiSolarCalendar.class);
    }

    private void writeJapanese(ObjectOutput objectOutput) throws IOException {
        JapaneseCalendar japaneseCalendar = (JapaneseCalendar)this.obj;
        objectOutput.writeInt(japaneseCalendar.getYear() - 1 + japaneseCalendar.getEra().getFirstRelatedGregorianYear());
        objectOutput.writeInt(japaneseCalendar.getDayOfYear());
    }

    private JapaneseCalendar readJapanese(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        long l = JapaneseCalendar.transform(n, n2);
        return JapaneseCalendar.axis().getCalendarSystem().transform(l);
    }

    private void writeIndian(ObjectOutput objectOutput) throws IOException {
        IndianCalendar indianCalendar = (IndianCalendar)this.obj;
        objectOutput.writeInt(indianCalendar.getYear());
        objectOutput.writeByte(indianCalendar.getMonth().getValue());
        objectOutput.writeByte(indianCalendar.getDayOfMonth());
    }

    private IndianCalendar readIndian(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return IndianCalendar.of(n, by, (int)by2);
    }

    private void writeHistoric(ObjectOutput objectOutput) throws IOException {
        HistoricCalendar historicCalendar = (HistoricCalendar)this.obj;
        objectOutput.writeUTF(historicCalendar.getHistory().getVariant());
        objectOutput.writeLong(historicCalendar.get(PlainDate.COMPONENT).getDaysSinceEpochUTC());
    }

    private HistoricCalendar readHistoric(ObjectInput objectInput) throws IOException {
        String string = objectInput.readUTF();
        long l = objectInput.readLong();
        PlainDate plainDate = PlainDate.of(l, EpochDays.UTC);
        return plainDate.transform(HistoricCalendar.family(), string);
    }

    private void writeHebrewDate(ObjectOutput objectOutput) throws IOException {
        HebrewCalendar hebrewCalendar = (HebrewCalendar)this.obj;
        objectOutput.writeInt(hebrewCalendar.getYear());
        objectOutput.writeByte(hebrewCalendar.getMonth().getValue());
        objectOutput.writeByte(hebrewCalendar.getDayOfMonth());
    }

    private HebrewCalendar readHebrewDate(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        HebrewMonth hebrewMonth = HebrewMonth.valueOf(objectInput.readByte());
        byte by = objectInput.readByte();
        return HebrewCalendar.of(n, hebrewMonth, by);
    }

    private void writeHebrewTime(ObjectOutput objectOutput) throws IOException {
        HebrewTime hebrewTime = (HebrewTime)this.obj;
        objectOutput.writeByte(hebrewTime.getDigitalHour());
        objectOutput.writeShort(hebrewTime.getPart());
    }

    private HebrewTime readHebrewTime(ObjectInput objectInput) throws IOException {
        byte by = objectInput.readByte();
        short s = objectInput.readShort();
        return HebrewTime.ofDigital(by, s);
    }

    private void writeEAC(ObjectOutput objectOutput) throws IOException {
        EastAsianCalendar eastAsianCalendar = (EastAsianCalendar)this.obj;
        objectOutput.writeByte(eastAsianCalendar.getCycle());
        objectOutput.writeByte(eastAsianCalendar.getYear().getNumber());
        objectOutput.writeByte(eastAsianCalendar.getMonth().getNumber());
        objectOutput.writeBoolean(eastAsianCalendar.getMonth().isLeap());
        objectOutput.writeByte(eastAsianCalendar.getDayOfMonth());
    }

    private ChineseCalendar readChinese(ObjectInput objectInput) throws IOException {
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        byte by3 = objectInput.readByte();
        boolean bl = objectInput.readBoolean();
        byte by4 = objectInput.readByte();
        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(by3);
        if (bl) {
            eastAsianMonth = eastAsianMonth.withLeap();
        }
        return ChineseCalendar.of(by, by2, eastAsianMonth, by4);
    }

    private KoreanCalendar readKorean(ObjectInput objectInput) throws IOException {
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        byte by3 = objectInput.readByte();
        boolean bl = objectInput.readBoolean();
        byte by4 = objectInput.readByte();
        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(by3);
        if (bl) {
            eastAsianMonth = eastAsianMonth.withLeap();
        }
        return KoreanCalendar.of(by, by2, eastAsianMonth, by4);
    }

    private VietnameseCalendar readVietnamese(ObjectInput objectInput) throws IOException {
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        byte by3 = objectInput.readByte();
        boolean bl = objectInput.readBoolean();
        byte by4 = objectInput.readByte();
        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(by3);
        if (bl) {
            eastAsianMonth = eastAsianMonth.withLeap();
        }
        return VietnameseCalendar.of(by, by2, eastAsianMonth, by4);
    }

    private void writeJuche(ObjectOutput objectOutput) throws IOException {
        JucheCalendar jucheCalendar = (JucheCalendar)this.obj;
        objectOutput.writeObject(jucheCalendar.toISO());
    }

    private JucheCalendar readJuche(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PlainDate plainDate = (PlainDate)PlainDate.class.cast(objectInput.readObject());
        return new JucheCalendar(plainDate);
    }
}

