/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.DisplayMode;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.PatternType;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;

final class StyleProcessor<T>
implements FormatProcessor<T> {
    private final ChronoFormatter<T> formatter;
    private final DisplayStyle dateStyle;
    private final DisplayStyle timeStyle;

    StyleProcessor(DisplayStyle displayStyle, DisplayStyle displayStyle2) {
        this(null, displayStyle, displayStyle2);
    }

    private StyleProcessor(ChronoFormatter<T> chronoFormatter, DisplayStyle displayStyle, DisplayStyle displayStyle2) {
        if (displayStyle == null || displayStyle2 == null) {
            throw new NullPointerException("Missing display style.");
        }
        this.dateStyle = displayStyle;
        this.timeStyle = displayStyle2;
        this.formatter = chronoFormatter;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        Set<ElementPosition> set2 = this.formatter.print(chronoDisplay, appendable, attributeQuery, set != null);
        if (set != null) {
            set.addAll(set2);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        AttributeQuery attributeQuery2;
        ChronoFormatter<T> chronoFormatter;
        if (bl) {
            chronoFormatter = this.formatter;
        } else {
            attributeQuery2 = this.formatter.getAttributes();
            TransitionStrategy transitionStrategy = attributeQuery.get(Attributes.TRANSITION_STRATEGY, attributeQuery2.get(Attributes.TRANSITION_STRATEGY, Timezone.DEFAULT_CONFLICT_STRATEGY));
            TZID tZID = attributeQuery.get(Attributes.TIMEZONE_ID, attributeQuery2.get(Attributes.TIMEZONE_ID, null));
            Timezone timezone = tZID == null ? null : Timezone.of(tZID).with(transitionStrategy);
            chronoFormatter = StyleProcessor.createFormatter(this.formatter.getChronology(), this.dateStyle, this.timeStyle, attributeQuery.get(Attributes.LANGUAGE, this.formatter.getLocale()), attributeQuery.get(Attributes.FOUR_DIGIT_YEAR, Boolean.FALSE), timezone);
        }
        attributeQuery2 = chronoFormatter.parse(charSequence, parseLog, attributeQuery);
        if (!parseLog.isError() && attributeQuery2 != null) {
            parsedEntity.setResult(attributeQuery2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StyleProcessor) {
            StyleProcessor styleProcessor = (StyleProcessor)object;
            if (this.dateStyle.equals(styleProcessor.dateStyle) && this.timeStyle.equals(styleProcessor.timeStyle)) {
                if (this.formatter == null) {
                    return styleProcessor.formatter == null;
                }
                return this.formatter.equals(styleProcessor.formatter);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.formatter == null ? 0 : this.formatter.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[date-style=");
        stringBuilder.append(this.dateStyle);
        stringBuilder.append(",time-style=");
        stringBuilder.append(this.timeStyle);
        stringBuilder.append(",delegate=");
        stringBuilder.append(this.formatter);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<T> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<T> withElement(ChronoElement<T> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<T> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        TransitionStrategy transitionStrategy = attributeQuery.get(Attributes.TRANSITION_STRATEGY, Timezone.DEFAULT_CONFLICT_STRATEGY);
        TZID tZID = attributeQuery.get(Attributes.TIMEZONE_ID, null);
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        ChronoFormatter<T> chronoFormatter2 = StyleProcessor.createFormatter(chronoFormatter.getChronology(), this.dateStyle, this.timeStyle, locale, attributeQuery.get(Attributes.FOUR_DIGIT_YEAR, Boolean.FALSE), tZID == null ? null : Timezone.of(tZID).with(transitionStrategy));
        return new StyleProcessor<T>(chronoFormatter2, this.dateStyle, this.timeStyle);
    }

    String getGeneratedPattern() {
        return this.formatter == null ? "" : this.formatter.getPattern();
    }

    private static <T> ChronoFormatter<T> createFormatter(Chronology<?> chronology, DisplayStyle displayStyle, DisplayStyle displayStyle2, Locale locale, boolean bl, Timezone timezone) {
        String string;
        if (chronology.equals(PlainDate.axis())) {
            string = CalendarText.patternForDate((DisplayMode)displayStyle, locale);
        } else if (chronology.equals(PlainTime.axis())) {
            string = CalendarText.patternForTime((DisplayMode)displayStyle2, locale);
        } else if (chronology.equals(PlainTimestamp.axis())) {
            string = CalendarText.patternForTimestamp((DisplayMode)displayStyle, (DisplayMode)displayStyle2, locale);
        } else if (chronology.equals(Moment.axis())) {
            string = CalendarText.patternForMoment((DisplayMode)displayStyle, (DisplayMode)displayStyle2, locale);
        } else if (LocalizedPatternSupport.class.isAssignableFrom(chronology.getChronoType())) {
            assert (displayStyle == displayStyle2);
            string = chronology.getFormatPattern(displayStyle, locale);
        } else {
            throw new UnsupportedOperationException("Localized format patterns not available: " + chronology);
        }
        if (bl && string.contains("yy") && !string.contains("yyy")) {
            string = string.replace("yy", "yyyy");
        }
        ChronoFormatter<?> chronoFormatter = ChronoFormatter.ofPattern(string, PatternType.CLDR, locale, chronology);
        if (timezone != null) {
            chronoFormatter = chronoFormatter.with(timezone);
        }
        return chronoFormatter;
    }
}

