/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.format.CalendarType;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatPatternProvider;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.ExtendedPatterns;
import net.time4j.format.internal.FormatUtils;
import net.time4j.i18n.IsoTextProviderSPI;
import net.time4j.i18n.PropertyBundle;

public final class CalendarText {
    private static final Set<String> RTL;
    private static final FormatPatternProvider FORMAT_PATTERN_PROVIDER;
    public static final String ISO_CALENDAR_TYPE = "iso8601";
    private static final TextProvider JDK_PROVIDER;
    private static final TextProvider ROOT_PROVIDER;
    private static final ConcurrentMap<String, CalendarText> CACHE;
    private final String provider;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> stdMonths;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> leapMonths;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> quarters;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> weekdays;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> meridiems;
    private final Map<TextWidth, TextAccessor> eras;
    private final Map<String, String> textForms;
    private final String calendarType;
    private final Locale locale;
    private final MissingResourceException mre;

    /*
     * WARNING - void declaration
     */
    private CalendarText(String string, Locale locale, TextProvider textProvider) {
        void var10_22;
        void var11_29;
        void var10_18;
        this.provider = textProvider.toString();
        this.stdMonths = Collections.unmodifiableMap(CalendarText.getMonths(string, locale, textProvider, false));
        Map<TextWidth, Map<OutputContext, TextAccessor>> map = CalendarText.getMonths(string, locale, textProvider, true);
        this.leapMonths = map == null ? this.stdMonths : Collections.unmodifiableMap(map);
        EnumMap enumMap = new EnumMap(TextWidth.class);
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> object = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                object.put(outputContext, new TextAccessor(textProvider.quarters(string, locale, textWidth, outputContext)));
            }
            enumMap.put(textWidth, object);
        }
        this.quarters = Collections.unmodifiableMap(enumMap);
        EnumMap enumMap2 = new EnumMap(TextWidth.class);
        for (TextWidth missingResourceException : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> enumMap3 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap3.put(outputContext, new TextAccessor(textProvider.weekdays(string, locale, missingResourceException, outputContext)));
            }
            enumMap2.put(missingResourceException, enumMap3);
        }
        this.weekdays = Collections.unmodifiableMap(enumMap2);
        EnumMap enumMap3 = new EnumMap(TextWidth.class);
        Object enumMap4 = TextWidth.values();
        int n = ((TextWidth[])enumMap4).length;
        boolean bl = false;
        while (var10_18 < n) {
            TextWidth textWidth = enumMap4[var10_18];
            enumMap3.put(textWidth, new TextAccessor(textProvider.eras(string, locale, textWidth)));
            ++var10_18;
        }
        this.eras = Collections.unmodifiableMap(enumMap3);
        enumMap4 = new EnumMap(TextWidth.class);
        Object hashMap = TextWidth.values();
        int n2 = ((TextWidth[])hashMap).length;
        boolean bl2 = false;
        while (var11_29 < n2) {
            TextWidth textWidth = hashMap[var11_29];
            EnumMap<OutputContext, TextAccessor> enumMap5 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap5.put(outputContext, new TextAccessor(textProvider.meridiems(string, locale, textWidth, outputContext)));
            }
            enumMap4.put(textWidth, enumMap5);
            ++var11_29;
        }
        this.meridiems = Collections.unmodifiableMap(enumMap4);
        hashMap = new HashMap();
        Object var10_20 = null;
        try {
            PropertyBundle propertyBundle = PropertyBundle.load("calendar/names/" + string + "/" + string, locale);
            for (String string2 : propertyBundle.keySet()) {
                hashMap.put(string2, propertyBundle.getString(string2));
            }
        }
        catch (MissingResourceException missingResourceException) {
            MissingResourceException missingResourceException2 = missingResourceException;
        }
        this.textForms = Collections.unmodifiableMap(hashMap);
        this.calendarType = string;
        this.locale = locale;
        this.mre = var10_22;
    }

    public static CalendarText getIsoInstance(Locale locale) {
        return CalendarText.getInstance(ISO_CALENDAR_TYPE, locale);
    }

    public static CalendarText getInstance(Chronology<?> chronology, Locale locale) {
        return CalendarText.getInstance(CalendarText.extractCalendarType(chronology), locale);
    }

    public static CalendarText getInstance(String string, Locale locale) {
        String string2;
        Object object;
        if (string == null) {
            throw new NullPointerException("Missing calendar type.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(locale.getLanguage());
        String string3 = locale.getCountry();
        if (!string3.isEmpty()) {
            stringBuilder.append('-');
            stringBuilder.append(string3);
        }
        if ((object = (CalendarText)CACHE.get(string2 = stringBuilder.toString())) == null) {
            Object object2;
            Object object3 = null;
            if (locale.getLanguage().isEmpty() && string.equals(ISO_CALENDAR_TYPE)) {
                object3 = ROOT_PROVIDER;
            } else {
                for (TextProvider textProvider : ResourceLoader.getInstance().services(TextProvider.class)) {
                    if (!textProvider.supportsCalendarType(string) || !textProvider.supportsLanguage(locale)) continue;
                    object3 = textProvider;
                    break;
                }
                if (object3 == null) {
                    object2 = JDK_PROVIDER;
                    if (object2.supportsCalendarType(string) && object2.supportsLanguage(locale)) {
                        object3 = object2;
                    }
                    if (object3 == null) {
                        object3 = ROOT_PROVIDER;
                    }
                }
            }
            object = new CalendarText(string, locale, (TextProvider)object3);
            object2 = CACHE.putIfAbsent(string2, (CalendarText)object);
            if (object2 != null) {
                object = object2;
            }
        }
        return object;
    }

    public TextAccessor getStdMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, false);
    }

    public TextAccessor getLeapMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, true);
    }

    public TextAccessor getQuarters(TextWidth textWidth, OutputContext outputContext) {
        return this.quarters.get((Object)textWidth).get((Object)outputContext);
    }

    public TextAccessor getWeekdays(TextWidth textWidth, OutputContext outputContext) {
        return this.weekdays.get((Object)textWidth).get((Object)outputContext);
    }

    public TextAccessor getEras(TextWidth textWidth) {
        return this.eras.get((Object)textWidth);
    }

    public TextAccessor getMeridiems(TextWidth textWidth, OutputContext outputContext) {
        return this.meridiems.get((Object)textWidth).get((Object)outputContext);
    }

    public Map<String, String> getTextForms() {
        return this.textForms;
    }

    public <V extends Enum<V>> TextAccessor getTextForms(ChronoElement<V> chronoElement, String ... stringArray) {
        return this.getTextForms(chronoElement.name(), chronoElement.getType(), stringArray);
    }

    public <V extends Enum<V>> TextAccessor getTextForms(String string, Class<V> clazz, String ... stringArray) {
        if (this.mre != null) {
            throw new MissingResourceException(this.mre.getMessage(), this.mre.getClassName(), this.mre.getKey());
        }
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n = enumArray.length;
        String[] stringArray2 = new String[n];
        String string2 = this.getKeyPrefix(string);
        int n2 = CalendarEra.class.isAssignableFrom(clazz) ? 0 : 1;
        for (int i = 0; i < n; ++i) {
            String string3;
            int n3 = 0;
            String string4 = null;
            while ((string3 = CalendarText.getKeyStart(string2, n3, stringArray)) != null) {
                String string5 = CalendarText.toKey(string3, i, n2);
                if (this.textForms.containsKey(string5)) {
                    string4 = string5;
                    break;
                }
                ++n3;
            }
            if (string4 == null) {
                if (this.textForms.containsKey(string)) {
                    stringArray2[i] = this.textForms.get(string);
                    continue;
                }
                stringArray2[i] = enumArray[i].name();
                continue;
            }
            stringArray2[i] = this.textForms.get(string4);
        }
        return new TextAccessor(stringArray2);
    }

    public static String patternForDate(DisplayMode displayMode, Locale locale) {
        return FORMAT_PATTERN_PROVIDER.getDatePattern(displayMode, locale);
    }

    public static String patternForTime(DisplayMode displayMode, Locale locale) {
        return FORMAT_PATTERN_PROVIDER.getTimePattern(displayMode, locale);
    }

    public static String patternForTimestamp(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        String string = FORMAT_PATTERN_PROVIDER.getDateTimePattern(displayMode, displayMode2, locale);
        return FormatUtils.removeZones(string);
    }

    public static String patternForMoment(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        return FORMAT_PATTERN_PROVIDER.getDateTimePattern(displayMode, displayMode2, locale);
    }

    public static String patternForInterval(Locale locale) {
        return FORMAT_PATTERN_PROVIDER.getIntervalPattern(locale);
    }

    public String toString() {
        return this.provider + "(" + this.calendarType + "/" + this.locale + ")";
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public static boolean isRTL(Locale locale) {
        return RTL.contains(locale.getLanguage());
    }

    static String extractCalendarType(Chronology<?> chronology) {
        while (chronology instanceof BridgeChronology) {
            chronology = chronology.preparser();
        }
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? ISO_CALENDAR_TYPE : calendarType.value();
    }

    private TextAccessor getMonths(TextWidth textWidth, OutputContext outputContext, boolean bl) {
        if (bl) {
            return this.leapMonths.get((Object)textWidth).get((Object)outputContext);
        }
        return this.stdMonths.get((Object)textWidth).get((Object)outputContext);
    }

    private static Map<TextWidth, Map<OutputContext, TextAccessor>> getMonths(String string, Locale locale, TextProvider textProvider, boolean bl) {
        EnumMap<TextWidth, Map<OutputContext, TextAccessor>> enumMap = new EnumMap<TextWidth, Map<OutputContext, TextAccessor>>(TextWidth.class);
        boolean bl2 = false;
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> enumMap2 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                Object[] objectArray = textProvider.months(string, locale, textWidth, outputContext, bl);
                if (bl && !bl2) {
                    Object[] objectArray2 = textProvider.months(string, locale, textWidth, outputContext, false);
                    bl2 = !Arrays.equals(objectArray2, objectArray);
                }
                enumMap2.put(outputContext, new TextAccessor((String[])objectArray));
            }
            enumMap.put(textWidth, enumMap2);
        }
        return !bl || bl2 ? enumMap : null;
    }

    private String getKeyPrefix(String string) {
        if (this.textForms.containsKey("useShortKeys") && "true".equals(this.textForms.get("useShortKeys"))) {
            if (string.equals("MONTH_OF_YEAR") || string.equals("DAY_OF_WEEK") || string.equals("QUARTER_OF_YEAR") || string.equals("ERA")) {
                return string.substring(0, 1);
            }
            if (string.equals("EVANGELIST")) {
                return "EV";
            }
            if (string.equals("SANSCULOTTIDES")) {
                return "S";
            }
            if (string.equals("DAY_OF_DECADE")) {
                return "D";
            }
        }
        return string;
    }

    private static String getKeyStart(String string, int n, String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray.length < n) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            boolean bl = true;
            for (int i = 0; i < stringArray.length - n; ++i) {
                if (bl) {
                    stringBuilder.append('(');
                    bl = false;
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(stringArray[i]);
            }
            if (!bl) {
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }
        return n > 0 ? null : string;
    }

    private static String toKey(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('_');
        stringBuilder.append(n + n2);
        return stringBuilder.toString();
    }

    static {
        Object object = new HashSet<String>();
        object.add("ar");
        object.add("dv");
        object.add("fa");
        object.add("ha");
        object.add("he");
        object.add("iw");
        object.add("ji");
        object.add("ps");
        object.add("sd");
        object.add("ug");
        object.add("ur");
        object.add("yi");
        RTL = Collections.unmodifiableSet(object);
        object = ResourceLoader.getInstance().services(FormatPatternProvider.class).iterator();
        FormatPatternProvider formatPatternProvider = object.hasNext() ? (FormatPatternProvider)object.next() : new IsoTextProviderSPI();
        FORMAT_PATTERN_PROVIDER = new FormatPatterns(formatPatternProvider);
        JDK_PROVIDER = new JDKTextProvider();
        ROOT_PROVIDER = new FallbackProvider();
        CACHE = new ConcurrentHashMap<String, CalendarText>();
    }

    private static class FormatPatterns
    implements FormatPatternProvider {
        private final FormatPatternProvider delegate;

        FormatPatterns(FormatPatternProvider formatPatternProvider) {
            this.delegate = formatPatternProvider;
        }

        @Override
        public String getDatePattern(DisplayMode displayMode, Locale locale) {
            if (this.delegate == null) {
                int n = FormatPatterns.getFormatStyle(displayMode);
                DateFormat dateFormat = DateFormat.getDateInstance(n, locale);
                return FormatPatterns.getFormatPattern(dateFormat);
            }
            return this.delegate.getDatePattern(displayMode, locale);
        }

        @Override
        public String getTimePattern(DisplayMode displayMode, Locale locale) {
            String string;
            if (this.delegate == null) {
                int n = FormatPatterns.getFormatStyle(displayMode);
                DateFormat dateFormat = DateFormat.getTimeInstance(n, locale);
                string = FormatPatterns.getFormatPattern(dateFormat);
            } else {
                string = this.delegate instanceof ExtendedPatterns ? ((ExtendedPatterns)ExtendedPatterns.class.cast(this.delegate)).getTimePattern(displayMode, locale, true) : this.delegate.getTimePattern(displayMode, locale);
            }
            return FormatUtils.removeZones(string);
        }

        @Override
        public String getDateTimePattern(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
            if (this.delegate == null) {
                int n = FormatPatterns.getFormatStyle(displayMode);
                int n2 = FormatPatterns.getFormatStyle(displayMode2);
                DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n2, locale);
                return FormatPatterns.getFormatPattern(dateFormat);
            }
            String string = this.delegate.getTimePattern(displayMode2, locale);
            String string2 = this.delegate.getDatePattern(displayMode, locale);
            String string3 = this.delegate.getDateTimePattern(displayMode, displayMode2, locale);
            return string3.replace("{1}", string2).replace("{0}", string);
        }

        @Override
        public String getIntervalPattern(Locale locale) {
            if (this.delegate == null) {
                if (locale.getLanguage().isEmpty() && locale.getCountry().isEmpty()) {
                    return "{0}/{1}";
                }
                return "{0} - {1}";
            }
            return this.delegate.getIntervalPattern(locale);
        }

        private static int getFormatStyle(DisplayMode displayMode) {
            switch (displayMode) {
                case FULL: {
                    return 0;
                }
                case LONG: {
                    return 1;
                }
                case MEDIUM: {
                    return 2;
                }
                case SHORT: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Unknown: " + displayMode);
        }

        private static String getFormatPattern(DateFormat dateFormat) {
            if (dateFormat instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)SimpleDateFormat.class.cast(dateFormat)).toPattern();
            }
            throw new IllegalStateException("Cannot retrieve format pattern: " + dateFormat);
        }
    }

    private static class FallbackProvider
    implements TextProvider {
        private FallbackProvider() {
        }

        @Override
        public boolean supportsCalendarType(String string) {
            return true;
        }

        @Override
        public boolean supportsLanguage(Locale locale) {
            return true;
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public Locale[] getAvailableLocales() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            if (textWidth == TextWidth.WIDE) {
                return new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13"};
            }
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"};
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"1", "2", "3", "4"};
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7"};
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"B", "A"};
            }
            return new String[]{"BC", "AD"};
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return new String[]{"AM", "PM"};
        }

        public String toString() {
            return "FallbackProvider";
        }
    }

    private static class JDKTextProvider
    implements TextProvider {
        private JDKTextProvider() {
        }

        @Override
        public boolean supportsCalendarType(String string) {
            return CalendarText.ISO_CALENDAR_TYPE.equals(string);
        }

        @Override
        public boolean supportsLanguage(Locale locale) {
            String string = locale.getLanguage();
            for (Locale locale2 : DateFormatSymbols.getAvailableLocales()) {
                if (!locale2.getLanguage().equals(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            return new String[]{CalendarText.ISO_CALENDAR_TYPE};
        }

        @Override
        public Locale[] getAvailableLocales() {
            return DateFormatSymbols.getAvailableLocales();
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            switch (textWidth) {
                case WIDE: {
                    return dateFormatSymbols.getMonths();
                }
                case ABBREVIATED: 
                case SHORT: {
                    return dateFormatSymbols.getShortMonths();
                }
                case NARROW: {
                    return JDKTextProvider.narrow(dateFormatSymbols.getShortMonths(), 12);
                }
            }
            throw new UnsupportedOperationException(textWidth.name());
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            Object object;
            String[] stringArray;
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            switch (textWidth) {
                case WIDE: {
                    stringArray = dateFormatSymbols.getWeekdays();
                    break;
                }
                case ABBREVIATED: 
                case SHORT: {
                    stringArray = dateFormatSymbols.getShortWeekdays();
                    break;
                }
                case NARROW: {
                    object = this.weekdays("", locale, TextWidth.SHORT, outputContext);
                    stringArray = JDKTextProvider.narrow(object, 7);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown text width: " + (Object)((Object)textWidth));
                }
            }
            if (stringArray.length > 7) {
                object = stringArray[1];
                String[] stringArray2 = new String[7];
                System.arraycopy(stringArray, 2, stringArray2, 0, 6);
                stringArray2[6] = object;
                stringArray = stringArray2;
            }
            return stringArray;
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            if (textWidth == TextWidth.NARROW) {
                String[] stringArray = dateFormatSymbols.getEras();
                String[] stringArray2 = new String[stringArray.length];
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = !stringArray[i].isEmpty() ? JDKTextProvider.toSingleLetter(stringArray[i]) : (i == 0 && stringArray.length == 2 ? "B" : (i == 1 && stringArray.length == 2 ? "A" : String.valueOf(i)));
                }
                return stringArray2;
            }
            return dateFormatSymbols.getEras();
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return DateFormatSymbols.getInstance(locale).getAmPmStrings();
        }

        public String toString() {
            return "JDKTextProvider";
        }

        private static String[] narrow(String[] stringArray, int n) {
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = !stringArray[i].isEmpty() ? JDKTextProvider.toSingleLetter(stringArray[i]) : String.valueOf(i + 1);
            }
            return stringArray2;
        }

        private static String toSingleLetter(String string) {
            char c = Normalizer.normalize(string, Normalizer.Form.NFD).charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return String.valueOf(c);
            }
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
                return String.valueOf(c);
            }
            if (c >= '\u0410' && c <= '\u042f') {
                return String.valueOf(c);
            }
            if (c >= '\u0430' && c <= '\u044f') {
                c = (char)(c - 32);
                return String.valueOf(c);
            }
            return string;
        }
    }
}

