/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.base.MathUtils;
import net.time4j.calendar.CyclicYear;

public abstract class EastAsianYear {
    public static EastAsianYear forGregorian(final int n) {
        return new EastAsianYear(){

            @Override
            public int getElapsedCyclicYears() {
                return MathUtils.safeAdd(n, 2636);
            }
        };
    }

    public static EastAsianYear forMinguo(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Minguo year must not be smaller than 1: " + n);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd(n, 1911));
    }

    public static EastAsianYear forDangi(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Dangi year must not be smaller than 1: " + n);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd(n, -2333));
    }

    public static EastAsianYear forJuche(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Juche year must not be smaller than 1: " + n);
        }
        return EastAsianYear.forGregorian(MathUtils.safeAdd(n, 1911));
    }

    public final int getCycle() {
        int n = this.getElapsedCyclicYears() + 1;
        return MathUtils.floorDivide(n - 1, 60) + 1;
    }

    public final CyclicYear getYearOfCycle() {
        int n = this.getElapsedCyclicYears() + 1;
        int n2 = MathUtils.floorModulo(n, 60);
        if (n2 == 0) {
            n2 = 60;
        }
        return CyclicYear.of(n2);
    }

    public abstract int getElapsedCyclicYears();
}

