/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public enum ThucydidesSystemProperty {
    WEBDRIVER_DRIVER,
    DRIVER,
    WEBDRIVER_PROVIDED_TYPE,
    WEBDRIVER_BASE_URL,
    WEBDRIVER_REMOTE_URL,
    PHANTOMJS_WEBDRIVER_PORT,
    WEBDRIVER_REMOTE_DRIVER,
    WEBDRIVER_REMOTE_BROWSER_VERSION,
    WEBDRIVER_REMOTE_OS,
    WEBDRIVER_CHROME_DRIVER,
    THUCYDIDES_PROJECT_KEY,
    THUCYDIDES_PROJECT_NAME,
    THUCYDIDES_HOME,
    THUCYDIDES_REPORT_RESOURCES,
    THUCYDIDES_REPORT_ENCODING,
    THUCYDIDES_OUTPUT_DIRECTORY("thucydides.outputDirectory"),
    THUCYDIDES_ONLY_SAVE_FAILING_SCREENSHOTS,
    THUCYDIDES_DRIVER_CAPABILITIES,
    THUCYDIDES_VERBOSE_SCREENSHOTS,
    THUCYDIDES_VERBOSE_STEPS,
    THUCYDIDES_TAKE_SCREENSHOTS,
    THUCYDIDES_REPORTS_SHOW_STEP_DETAILS,
    THUCYDIDES_REPORT_SHOW_MANUAL_TESTS,
    THUCYDIDES_REPORT_SHOW_RELEASES,
    THUCYDIDES_REPORT_SHOW_PROGRESS,
    THUCYDIDES_REPORT_SHOW_HISTORY,
    THUCYDIDES_REPORT_SHOW_TAG_MENUS,
    THUCYDIDES_RESTART_BROWSER_FREQUENCY,
    THUCYDIDES_STEP_DELAY,
    THUCYDIDES_TIMEOUT,
    REFUSE_UNTRUSTED_CERTIFICATES,
    THUCYDIDES_USE_UNIQUE_BROWSER,
    THUCYDIDES_ESTIMATED_AVERAGE_STEP_COUNT,
    THUCYDIDES_ESTIMATED_TESTS_PER_REQUIREMENT,
    THUCYDIDES_ISSUE_TRACKER_URL,
    THUCYDIDES_NATIVE_EVENTS,
    JIRA_URL,
    JIRA_PROJECT,
    JIRA_USERNAME,
    JIRA_PASSWORD,
    THUCYDIDES_HISTORY,
    THUCYDIDES_BROWSER_HEIGHT,
    THUCYDIDES_BROWSER_WIDTH,
    THUCYDIDES_RESIZED_IMAGE_WIDTH,
    THUCYDIDES_PUBLIC_URL,
    THUCYDIDES_ACTIVATE_FIREBUGS,
    SECURITY_ENABLE_JAVA("security.enable_java"),
    THUCYDIDES_ACTIVATE_HIGHLIGHTING,
    THUCYDIDES_BATCH_STRATEGY,
    THUCYDIDES_BATCH_COUNT,
    THUCYDIDES_BATCH_SIZE,
    THUCYDIDES_BATCH_NUMBER,
    THUCYDIDES_PROXY_HTTP,
    THUCYDIDES_PROXY_HTTP_PORT("thucydides.proxy.http_port"),
    THUCYDIDES_PROXY_TYPE,
    THUCYDIDES_PROXY_USER,
    THUCYDIDES_PROXY_PASSWORD,
    WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT,
    THUCYDIDES_EXT_PACKAGES,
    CHROME_SWITCHES,
    FIREFOX_PREFERENCES,
    WEBDRIVER_FIREFOX_PROFILE,
    THUCYDIDES_JQUERY_INTEGRATION,
    SAUCELABS_TARGET_PLATFORM,
    SAUCELABS_DRIVER_VERSION,
    SAUCELABS_TEST_NAME,
    SAUCELABS_URL,
    SAUCELABS_ACCESS_KEY,
    SAUCELABS_USER_ID,
    SAUCELABS_IMPLICIT_TIMEOUT,
    SAUCELABS_RECORD_SCREENSHOTS,
    THUCYDIDES_FILE_IO_RETRY_TIMEOUT,
    THUCYDIDES_LOGGING,
    THUCYDIDES_TEST_ROOT,
    THUCYDIDES_REQUIREMENTS_DIR,
    THUCYDIDES_USE_REQUIREMENTS_DIRECTORIES,
    THUCYDIDES_ANNOTATED_REQUIREMENTS_DIR,
    THUCYDIDES_LOWEST_REQUIREMENT_TYPE,
    THUCYDIDES_REQUIREMENT_TYPES,
    THUCYDIDES_REQUIREMENT_EXCLUSIONS,
    THUCYDIDES_RELEASE_TYPES,
    THUCYDIDES_LOCATOR_FACTORY,
    THUCYDIDES_DATA_DIR,
    PROPERTIES,
    THUCYDIDES_TEST_REQUIREMENTS_BASEDIR,
    THUCYDIDES_STORE_HTML_SOURCE,
    THUCYDIDES_KEEP_UNSCALED_SCREENSHOTS,
    TAGS,
    THUCYDIDES_CSV_EXTRA_COLUMNS,
    THUCYDIDES_CONSOLE_HEADINGS,
    NARRATIVE_FORMAT,
    OUTPUT_FORMATS,
    PHANTOMJS_BINARY_PATH,
    IGNORE_EMBEDDED_TABLES,
    SHOW_RELATED_TAGS,
    USE_TEST_CASE_FOR_STORY_TAG,
    SHOW_PIE_CHARTS,
    DASHBOARD_TAG_LIST,
    DASHBOARD_EXCLUDED_TAG_LIST,
    JSON_PRETTY_PRINTING,
    JSON_CHARSET,
    JUNIT_RETRY_TESTS,
    SIMPLIFIED_STACK_TRACES,
    THUCYDIDES_MAINTAIN_SESSION;

    private String propertyName;
    public static final int DEFAULT_HEIGHT = 700;
    public static final int DEFAULT_WIDTH = 960;

    private ThucydidesSystemProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    private ThucydidesSystemProperty() {
        this.propertyName = this.name().replaceAll("_", ".").toLowerCase();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return this.propertyName;
    }

    public String from(EnvironmentVariables environmentVariables) {
        return environmentVariables.getProperty(this.getPropertyName());
    }

    public String from(EnvironmentVariables environmentVariables, String defaultValue) {
        String value = environmentVariables.getProperty(this.getPropertyName());
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public boolean isDefinedIn(EnvironmentVariables environmentVariables) {
        return StringUtils.isNotEmpty((CharSequence)this.from(environmentVariables));
    }
}

