/*
 * Decompiled with CFR 0.152.
 */
package zlib_tiny;

public class CRC64 {
    private static final long poly = -3932672073523589310L;
    private static final long[] crcTable = new long[256];
    private long crc = -1L;

    public void update(byte by) {
        this.crc = crcTable[(by ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            this.crc = crcTable[(byArray[n++] ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
        }
    }

    public long getValue() {
        return this.crc ^ 0xFFFFFFFFFFFFFFFFL;
    }

    static {
        for (int i = 0; i < crcTable.length; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                if ((l & 1L) == 1L) {
                    l = l >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                l >>>= 1;
            }
            CRC64.crcTable[i] = l;
        }
    }
}

