/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.javaflow.spi.ClasspathResourceLoader;
import org.apache.commons.javaflow.spi.FastByteArrayInputStream;

public class ExtendedClasspathResourceLoader
extends ClasspathResourceLoader {
    private static final ThreadLocal<Map<String, byte[]>> IN_MEMORY_RESOURCES = new ThreadLocal();

    public ExtendedClasspathResourceLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public static void runWithInMemoryResources(final Runnable block, Map<String, byte[]> inMemoryResources) {
        ExtendedClasspathResourceLoader.runWithInMemoryResources(new Callable<Void>(){

            @Override
            public Void call() {
                block.run();
                return null;
            }
        }, inMemoryResources);
    }

    public static <V> V runWithInMemoryResources(Callable<V> block, Map<String, byte[]> inMemoryResources) {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>(inMemoryResources);
        Map<String, byte[]> previous = IN_MEMORY_RESOURCES.get();
        if (null != previous) {
            resources.putAll(previous);
        }
        IN_MEMORY_RESOURCES.set(resources);
        try {
            V v = block.call();
            return v;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != previous) {
                IN_MEMORY_RESOURCES.set(previous);
            } else {
                IN_MEMORY_RESOURCES.remove();
            }
        }
    }

    @Override
    public boolean hasResource(String name) {
        Map<String, byte[]> inMemoryResources = IN_MEMORY_RESOURCES.get();
        if (null != inMemoryResources && inMemoryResources.containsKey(name)) {
            return true;
        }
        return super.hasResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) throws IOException {
        byte[] bytecode;
        Map<String, byte[]> inMemoryResources = IN_MEMORY_RESOURCES.get();
        if (null != inMemoryResources && null != (bytecode = inMemoryResources.get(name))) {
            return new FastByteArrayInputStream(bytecode);
        }
        return super.getResourceAsStream(name);
    }
}

