/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.javaflow.spi.ClassMatcher;

public final class ClassMatchers {
    public static ClassMatcher MATCH_NONE = new ClassMatcher(){

        @Override
        public boolean matches(String name, String signature, String superName, String[] interfaces) {
            return false;
        }
    };
    public static ClassMatcher MATCH_ALL = new ClassMatcher(){

        @Override
        public boolean matches(String name, String signature, String superName, String[] interfaces) {
            return true;
        }
    };

    private ClassMatchers() {
    }

    public static ClassMatcher whenAll(ClassMatcher ... matchers) {
        return ClassMatchers.whenAll(Arrays.asList(matchers));
    }

    public static ClassMatcher whenAll(final Collection<? extends ClassMatcher> matchers) {
        return new ClassMatcher(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces) {
                for (ClassMatcher m : matchers) {
                    if (m.matches(name, signature, superName, interfaces)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ClassMatcher whenAny(ClassMatcher ... matchers) {
        return ClassMatchers.whenAny(Arrays.asList(matchers));
    }

    public static ClassMatcher whenAny(final Collection<? extends ClassMatcher> matchers) {
        return new ClassMatcher(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces) {
                for (ClassMatcher m : matchers) {
                    if (!m.matches(name, signature, superName, interfaces)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ClassMatcher negate(final ClassMatcher matcher) {
        return new ClassMatcher(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces) {
                return !matcher.matches(name, signature, superName, interfaces);
            }
        };
    }

    public static ClassMatcher byClassName(String className, final boolean namePart) {
        final String cn = ClassMatchers.className(className);
        return new ClassMatcher(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces) {
                return namePart && name.equals(cn) || name.contains(cn);
            }
        };
    }

    public static ClassMatcher byClassNamePattern(String classNamePattern) {
        final Pattern pattern = Pattern.compile("^" + classNamePattern + "$");
        return new ClassMatcher(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces) {
                return pattern.matcher(name).matches();
            }
        };
    }

    public static ClassMatcher bySuperClassName(String superClassName, boolean namePart) {
        return ClassMatchers.bySuperClass(ClassMatchers.byClassName(superClassName, namePart));
    }

    public static ClassMatcher bySuperClassNamePattern(String superClassNamePattern) {
        return ClassMatchers.bySuperClass(ClassMatchers.byClassNamePattern(superClassNamePattern));
    }

    public static ClassMatcher byInterfaceName(String interfaceName, boolean namePart) {
        return ClassMatchers.byInterface(ClassMatchers.byClassName(interfaceName, namePart));
    }

    public static ClassMatcher byInterfaceNamePattern(String interfaceNamePattern) {
        return ClassMatchers.byInterface(ClassMatchers.byClassNamePattern(interfaceNamePattern));
    }

    private static ClassMatcher bySuperClass(final ClassMatcher nested) {
        return new ClassMatcher(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces) {
                return nested.matches(superName, null, null, null);
            }
        };
    }

    private static ClassMatcher byInterface(final ClassMatcher nested) {
        return new ClassMatcher(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces) {
                if (null != interfaces) {
                    for (String intf : interfaces) {
                        if (!nested.matches(intf, null, null, null)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private static String className(String internalClassName) {
        return internalClassName != null ? internalClassName.replace('.', '/') : null;
    }
}

