/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asmx;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.tascalate.asmx.Type;
import org.apache.commons.javaflow.providers.asmx.ClassHierarchy;
import org.apache.commons.javaflow.providers.asmx.IContinuableClassInfo;
import org.apache.commons.javaflow.spi.ClassMatcher;

class SharedContinuableClassInfos {
    private final Map<String, IContinuableClassInfo> visitedClasses;
    private final Map<String, Boolean> processedAnnotations;
    private final Map<String, Boolean> continuableAnnotations;
    private final ClassHierarchy hierarhcy;
    private final ClassMatcher veto;
    private static final Type CONTINUABLE_ANNOTATION_TYPE = Type.getObjectType((String)"org/apache/commons/javaflow/api/ContinuableAnnotation");

    SharedContinuableClassInfos(ClassHierarchy hierarchy, ClassMatcher veto) {
        this.hierarhcy = hierarchy;
        this.veto = veto;
        this.visitedClasses = new ConcurrentHashMap<String, IContinuableClassInfo>();
        this.processedAnnotations = new ConcurrentHashMap<String, Boolean>();
        this.continuableAnnotations = new ConcurrentHashMap<String, Boolean>();
        this.processedAnnotations.put(CONTINUABLE_ANNOTATION_TYPE.getDescriptor(), Boolean.TRUE);
        this.continuableAnnotations.put(CONTINUABLE_ANNOTATION_TYPE.getDescriptor(), Boolean.TRUE);
    }

    IContinuableClassInfo getResolved(String classInternalName) {
        return this.visitedClasses.get(classInternalName);
    }

    boolean isProcessedAnnotation(String annotationClassDescriptor) {
        return this.processedAnnotations.containsKey(annotationClassDescriptor);
    }

    boolean isContinuableAnnotation(String annotationClassDescriptor) {
        return this.continuableAnnotations.containsKey(annotationClassDescriptor);
    }

    ClassHierarchy hierarchy() {
        return this.hierarhcy;
    }

    ClassMatcher veto() {
        return this.veto;
    }

    void mergeWith(Map<String, IContinuableClassInfo> newVisitedClasses, Set<String> newProcessedAnnotations, Set<String> newContinuableAnnotations) {
        this.visitedClasses.putAll(newVisitedClasses);
        this.continuableAnnotations.putAll(SharedContinuableClassInfos.toMap(newContinuableAnnotations));
        this.processedAnnotations.putAll(SharedContinuableClassInfos.toMap(newProcessedAnnotations));
    }

    private static Map<String, Boolean> toMap(Set<String> keys) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String key : keys) {
            result.put(key, Boolean.TRUE);
        }
        return result;
    }
}

