/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asmx;

import java.util.LinkedList;
import java.util.List;
import net.tascalate.asmx.tree.AbstractInsnNode;
import net.tascalate.asmx.tree.analysis.AnalyzerException;
import net.tascalate.asmx.tree.analysis.Frame;
import net.tascalate.asmx.tree.analysis.Interpreter;
import net.tascalate.asmx.tree.analysis.Value;

class MonitoringFrame<V extends Value>
extends Frame<V> {
    private List<Integer> monitored;

    MonitoringFrame(Frame<? extends V> frame) {
        super(frame);
    }

    MonitoringFrame(int nLocals, int nStack) {
        super(nLocals, nStack);
        this.monitored = new LinkedList<Integer>();
    }

    public void execute(AbstractInsnNode insn, Interpreter<V> interpreter) throws AnalyzerException {
        boolean never = false;
        if (never) {
            super.execute(insn, interpreter);
            return;
        }
        int insnOpcode = insn.getOpcode();
        if (insnOpcode == 194 || insnOpcode == 195) {
            Value pop = this.pop();
            interpreter.unaryOperation(insn, pop);
            int local = -1;
            for (int i = 0; i < this.getLocals(); ++i) {
                if (this.getLocal(i) != pop) continue;
                local = i;
            }
            if (local > -1) {
                if (insnOpcode == 194) {
                    this.monitorEnter(local);
                } else {
                    this.monitorExit(local);
                }
            }
        } else {
            super.execute(insn, interpreter);
        }
    }

    public Frame<V> init(Frame<? extends V> frame) {
        super.init(frame);
        if (frame instanceof MonitoringFrame) {
            MonitoringFrame mframe = (MonitoringFrame)frame;
            this.monitored = new LinkedList<Integer>(mframe.monitored);
        } else {
            this.monitored = new LinkedList<Integer>();
        }
        return this;
    }

    int[] getMonitored() {
        int[] res = new int[this.monitored.size()];
        for (int i = 0; i < this.monitored.size(); ++i) {
            res[i] = this.monitored.get(i);
        }
        return res;
    }

    private void monitorEnter(int local) {
        this.monitored.add(local);
    }

    private void monitorExit(int local) {
        int index = this.monitored.lastIndexOf(local);
        if (index != -1) {
            this.monitored.remove(index);
        }
    }
}

