/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asmx;

import net.tascalate.asmx.AnnotationVisitor;
import net.tascalate.asmx.ClassVisitor;
import net.tascalate.asmx.MethodVisitor;
import org.apache.commons.javaflow.providers.asmx.ClassHierarchy;
import org.apache.commons.javaflow.providers.asmx.ContinuableMethodNode;
import org.apache.commons.javaflow.providers.asmx.IContinuableClassInfo;
import org.apache.commons.javaflow.providers.asmx.IContinuableClassInfoResolver;
import org.apache.commons.javaflow.spi.StopException;

class ContinuableClassVisitor
extends ClassVisitor {
    private final ClassHierarchy classHierarchy;
    private final IContinuableClassInfoResolver cciResolver;
    private byte[] originalBytes;
    private String className;
    private IContinuableClassInfo classInfo;
    private boolean skipEnchancing = false;

    ContinuableClassVisitor(ClassVisitor cv, ClassHierarchy classHierarchy, IContinuableClassInfoResolver cciResolver, byte[] originalBytes) {
        super(458752, cv);
        this.classHierarchy = classHierarchy;
        this.cciResolver = cciResolver;
        this.originalBytes = originalBytes;
    }

    boolean skipEnchancing() {
        return this.skipEnchancing;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.classInfo = this.cciResolver.resolve(name, this.originalBytes);
        this.originalBytes = null;
        if (null == this.classInfo || this.classInfo.isClassProcessed() || this.cciResolver.veto().matches(name, signature, superName, interfaces)) {
            this.skipEnchancing = true;
            throw StopException.INSTANCE;
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if ("Lorg/apache/commons/javaflow/core/Skip;".equals(descriptor)) {
            this.skipEnchancing = true;
            this.classInfo.markClassProcessed();
            throw StopException.INSTANCE;
        }
        return super.visitAnnotation(descriptor, visible);
    }

    public void visitEnd() {
        AnnotationVisitor v;
        if (!this.skipEnchancing && null != (v = super.visitAnnotation("Lorg/apache/commons/javaflow/core/Skip;", true))) {
            v.visitEnd();
        }
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean skip;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        boolean bl = skip = this.skipEnchancing || null == this.classInfo || mv == null || (access & 0x500) > 0 || "<init>".equals(name) || !this.classInfo.isContinuableMethod(access, name, desc, signature);
        if (skip) {
            return mv;
        }
        return new ContinuableMethodNode(access, name, desc, signature, exceptions, this.className, this.classHierarchy, this.cciResolver, mv);
    }
}

