/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asmx;

import java.util.Collection;
import net.tascalate.asmx.ClassReader;
import net.tascalate.asmx.ClassVisitor;
import org.apache.commons.javaflow.providers.asmx.ClassHierarchy;
import org.apache.commons.javaflow.providers.asmx.ContinuableClassVisitor;
import org.apache.commons.javaflow.providers.asmx.IContinuableClassInfoResolver;
import org.apache.commons.javaflow.providers.asmx.OfflineClassWriter;
import org.apache.commons.javaflow.spi.AbstractResourceTransformer;
import org.apache.commons.javaflow.spi.StopException;

class ContinuableClassTransformer
extends AbstractResourceTransformer {
    private final ClassHierarchy classHierarchy;
    private final IContinuableClassInfoResolver cciResolver;

    ContinuableClassTransformer(ClassHierarchy classHierarchy, IContinuableClassInfoResolver cciResolver) {
        this.classHierarchy = classHierarchy;
        this.cciResolver = cciResolver;
    }

    public byte[] transform(byte[] original, Collection<String> retransformClasses) {
        ClassReader reader = new ClassReader(original);
        OfflineClassWriter writer = new OfflineClassWriter(this.classHierarchy, reader, 2);
        ContinuableClassVisitor visitor = new ContinuableClassVisitor((ClassVisitor)writer, this.classHierarchy, this.cciResolver, original);
        this.cciResolver.reset(retransformClasses);
        try {
            reader.accept((ClassVisitor)visitor, 4);
        }
        catch (StopException ex) {
            return null;
        }
        if (visitor.skipEnchancing()) {
            return null;
        }
        byte[] bytecode = writer.toByteArray();
        return bytecode;
    }

    public void release() {
        this.cciResolver.release();
    }
}

