/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.javaflow;

import java.io.Serializable;
import java.util.NoSuchElementException;
import net.tascalate.javaflow.CloseableIterator;
import net.tascalate.javaflow.Continuations;
import net.tascalate.javaflow.function.SuspendableRunnable;
import org.apache.commons.javaflow.api.Continuation;

public class ContinuationIterator<E>
implements CloseableIterator<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean advance;
    private Continuation cc;

    public ContinuationIterator(Runnable code) {
        this.cc = Continuation.startSuspendedWith((Runnable)code);
        this.advance = null != this.cc;
    }

    public ContinuationIterator(SuspendableRunnable code) {
        this(Continuations.toRunnable(code));
    }

    public ContinuationIterator(Continuation cc) {
        this(cc, false);
    }

    public ContinuationIterator(Continuation cc, boolean useCurrentValue) {
        this.cc = cc;
        this.advance = !useCurrentValue && null != cc;
    }

    @Override
    public boolean hasNext() {
        this.advanceIfNecessary();
        return this.cc != null;
    }

    @Override
    public E next() {
        this.advanceIfNecessary();
        if (this.cc == null) {
            throw new NoSuchElementException();
        }
        Object result = this.cc.value();
        this.advance = true;
        return (E)result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        try {
            if (null != this.cc) {
                this.cc.terminate();
            }
        }
        finally {
            this.cc = null;
            this.advance = false;
        }
    }

    protected void advanceIfNecessary() {
        if (this.advance) {
            this.cc = this.cc.resume();
        }
        this.advance = false;
    }
}

