/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.delays;

import java.time.Duration;
import java.util.Random;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.delays.DurationCalcs;
import net.tascalate.concurrent.delays.RandomDelayPolicy;

public class UniformRandomDelayPolicy
extends RandomDelayPolicy {
    public static final long DEFAULT_RANDOM_RANGE_MILLIS = 100L;
    private final Duration range;

    public UniformRandomDelayPolicy(DelayPolicy target) {
        this(target, 100L);
    }

    public UniformRandomDelayPolicy(DelayPolicy target, Random random) {
        this(target, 100L, random);
    }

    public UniformRandomDelayPolicy(DelayPolicy target, long range) {
        this(target, Duration.ofMillis(range));
    }

    public UniformRandomDelayPolicy(DelayPolicy target, Duration range) {
        super(target);
        if (!DelayPolicy.isValid(range)) {
            throw new IllegalArgumentException("Range must be positive but was: " + range);
        }
        this.range = range;
    }

    public UniformRandomDelayPolicy(DelayPolicy target, long range, Random random) {
        this(target, Duration.ofMillis(range), random);
    }

    public UniformRandomDelayPolicy(DelayPolicy target, Duration range, Random random) {
        super(target, random);
        if (!DelayPolicy.isValid(range)) {
            throw new IllegalArgumentException("Range must be positive but was: " + range);
        }
        this.range = range;
    }

    @Override
    long addRandomJitter(long amount, double randomizer, int dimIdx) {
        long rangeNormalized = DurationCalcs.safeExtractAmount(this.range, dimIdx);
        double uniformRandom = (1.0 - randomizer * 2.0) * (double)rangeNormalized;
        return Math.max(0L, (long)((double)amount + uniformRandom));
    }

    @Override
    boolean checkBounds(long amount, double randomizer, int dimIdx) {
        long rangeNormalized = DurationCalcs.safeExtractAmount(this.range, dimIdx);
        double uniformRandom = (1.0 - randomizer * 2.0) * (double)rangeNormalized;
        if (uniformRandom < 0.0) {
            return (double)(-9223372036854775807L + Math.abs(amount)) < uniformRandom;
        }
        return (double)(Long.MAX_VALUE - Math.abs(amount)) > uniformRandom;
    }
}

