/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.delays;

import java.time.Duration;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.delays.DelayPolicyWrapper;

public class BoundedMinDelayPolicy
extends DelayPolicyWrapper {
    public static final long DEFAULT_MIN_DELAY_MILLIS = 100L;
    private final Duration minDelay;

    public BoundedMinDelayPolicy(DelayPolicy target) {
        this(target, 100L);
    }

    public BoundedMinDelayPolicy(DelayPolicy target, long minDelayMillis) {
        this(target, Duration.ofMillis(minDelayMillis));
    }

    public BoundedMinDelayPolicy(DelayPolicy target, Duration minDelay) {
        super(target);
        if (!DelayPolicy.isValid(minDelay)) {
            throw new IllegalArgumentException("MinDelay must be positive but was: " + minDelay);
        }
        this.minDelay = minDelay;
    }

    @Override
    public Duration delay(RetryContext context) {
        return BoundedMinDelayPolicy.max(this.target.delay(context), this.minDelay);
    }
}

