/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class SharedFunctions {
    private SharedFunctions() {
    }

    static Throwable unwrapCompletionException(Throwable ex) {
        Throwable nested = ex;
        while (nested instanceof CompletionException) {
            nested = nested.getCause();
        }
        return null == nested ? ex : nested;
    }

    static CompletionException wrapCompletionException(Throwable e) {
        if (e instanceof CompletionException) {
            return (CompletionException)e;
        }
        return new CompletionException(e);
    }

    static Throwable unwrapExecutionException(Throwable ex) {
        Throwable nested = ex;
        while (nested instanceof ExecutionException) {
            nested = nested.getCause();
        }
        return null == nested ? ex : nested;
    }

    static ExecutionException wrapExecutionException(Throwable e) {
        if (e instanceof ExecutionException) {
            return (ExecutionException)e;
        }
        return new ExecutionException(e);
    }

    static boolean cancelPromise(CompletionStage<?> promise, boolean mayInterruptIfRunning) {
        if (promise instanceof Future) {
            Future future = (Future)((Object)promise);
            return future.cancel(mayInterruptIfRunning);
        }
        Method m = SharedFunctions.completeExceptionallyMethodOf(promise);
        if (null != m) {
            try {
                return (Boolean)m.invoke(promise, new CancellationException());
            }
            catch (ReflectiveOperationException ex) {
                return false;
            }
        }
        return false;
    }

    private static Method completeExceptionallyMethodOf(CompletionStage<?> promise) {
        try {
            Class<?> clazz = promise.getClass();
            return clazz.getMethod("completeExceptionally", Throwable.class);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            return null;
        }
    }
}

