/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.Timeouts;

public class RetryPolicy {
    public static final Outcome DONT_RETRY = new Outcome(){

        @Override
        public boolean shouldExecute() {
            return false;
        }

        @Override
        public Duration backoffDelay() {
            return Timeouts.NEGATIVE_DURATION;
        }

        @Override
        public Duration timeout() {
            return Timeouts.NEGATIVE_DURATION;
        }
    };
    private static final Predicate<RetryContext> PREDICATE_TRUE = ctx -> true;
    private static final Predicate<RetryContext> PREDICATE_FALSE = ctx -> false;
    public static final RetryPolicy DEFAULT = new RetryPolicy().retryOn(Exception.class);
    private final int maxRetries;
    private final Set<Class<? extends Throwable>> retryOn;
    private final Set<Class<? extends Throwable>> abortOn;
    private final Predicate<RetryContext> retryPredicate;
    private final Predicate<RetryContext> abortPredicate;
    private final DelayPolicy backoff;
    private final DelayPolicy timeout;

    @SafeVarargs
    public final RetryPolicy retryOn(Class<? extends Throwable> ... retryOnThrowables) {
        return this.retryOn(Arrays.asList(retryOnThrowables));
    }

    public RetryPolicy retryOn(Collection<Class<? extends Throwable>> retryOnThrowables) {
        return new RetryPolicy(this.maxRetries, RetryPolicy.setPlusElems(this.retryOn, retryOnThrowables), this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    @SafeVarargs
    public final RetryPolicy abortOn(Class<? extends Throwable> ... abortOnThrowables) {
        return this.abortOn(Arrays.asList(abortOnThrowables));
    }

    public RetryPolicy abortOn(Collection<Class<? extends Throwable>> abortOnThrowables) {
        return new RetryPolicy(this.maxRetries, this.retryOn, RetryPolicy.setPlusElems(this.abortOn, abortOnThrowables), this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy abortIf(Predicate<RetryContext> abortPredicate) {
        return new RetryPolicy(this.maxRetries, this.retryOn, this.abortOn, this.retryPredicate, abortPredicate.or(abortPredicate), this.backoff, this.timeout);
    }

    public RetryPolicy retryIf(Predicate<RetryContext> retryPredicate) {
        return new RetryPolicy(this.maxRetries, this.retryOn, this.abortOn, this.retryPredicate.or(retryPredicate), this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy dontRetry() {
        return new RetryPolicy(0, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy withMaxRetries(int maxRetries) {
        return new RetryPolicy(maxRetries, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, this.timeout);
    }

    public RetryPolicy withBackoff(DelayPolicy backoff) {
        return new RetryPolicy(this.maxRetries, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, backoff, this.timeout);
    }

    public RetryPolicy withTimeout(DelayPolicy timeout) {
        return new RetryPolicy(this.maxRetries, this.retryOn, this.abortOn, this.retryPredicate, this.abortPredicate, this.backoff, timeout);
    }

    public RetryPolicy(int maxRetries, Set<Class<? extends Throwable>> retryOn, Set<Class<? extends Throwable>> abortOn, Predicate<RetryContext> retryPredicate, Predicate<RetryContext> abortPredicate, DelayPolicy backoff, DelayPolicy timeout) {
        this.maxRetries = maxRetries;
        this.retryOn = retryOn;
        this.abortOn = abortOn;
        this.retryPredicate = retryPredicate;
        this.abortPredicate = abortPredicate;
        this.backoff = backoff;
        this.timeout = timeout;
    }

    public RetryPolicy() {
        this(Integer.MAX_VALUE, DelayPolicy.DEFAULT);
    }

    public RetryPolicy(long backoff) {
        this(Integer.MAX_VALUE, backoff);
    }

    public RetryPolicy(int maxRetries, long backoff) {
        this(maxRetries, DelayPolicy.fixedInterval(backoff).withFirstRetryNoDelay());
    }

    public RetryPolicy(int maxRetries, long backoff, long timeout) {
        this(maxRetries, DelayPolicy.fixedInterval(backoff).withFirstRetryNoDelay(), DelayPolicy.fixedInterval(timeout));
    }

    public RetryPolicy(int maxRetries, DelayPolicy backoff) {
        this(maxRetries, backoff, DelayPolicy.INVALID);
    }

    public RetryPolicy(int maxRetries, DelayPolicy backoff, DelayPolicy timeout) {
        this(maxRetries, Collections.emptySet(), Collections.emptySet(), PREDICATE_TRUE, PREDICATE_FALSE, backoff, timeout);
    }

    public Outcome shouldContinue(RetryContext context) {
        boolean result = this.tooManyRetries(context) ? false : (this.abortPredicate.test(context) ? false : (this.retryPredicate.test(context) ? true : this.exceptionClassRetryable(context)));
        return result ? new PositiveOutcome(this.backoff.delay(context), this.timeout.delay(context)) : DONT_RETRY;
    }

    private boolean tooManyRetries(RetryContext context) {
        return context.getRetryCount() > this.maxRetries;
    }

    private boolean exceptionClassRetryable(RetryContext context) {
        if (context.getLastThrowable() == null) {
            return true;
        }
        Class<?> e = context.getLastThrowable().getClass();
        return !RetryPolicy.matches(e, this.abortOn) && RetryPolicy.matches(e, this.retryOn);
    }

    private static boolean matches(Class<? extends Throwable> throwable, Set<Class<? extends Throwable>> set) {
        return set.stream().anyMatch(c -> c.isAssignableFrom(throwable));
    }

    private static <T> Set<T> setPlusElems(Set<T> initial, Collection<T> newElement) {
        HashSet<T> copy = new HashSet<T>(initial);
        copy.addAll(newElement);
        return Collections.unmodifiableSet(copy);
    }

    private static class PositiveOutcome
    implements Outcome {
        private final Duration backoffDelay;
        private final Duration timeoutDelay;

        PositiveOutcome(Duration backoffDelay, Duration timeoutDelay) {
            this.backoffDelay = backoffDelay;
            this.timeoutDelay = timeoutDelay;
        }

        @Override
        public boolean shouldExecute() {
            return true;
        }

        @Override
        public Duration backoffDelay() {
            return this.backoffDelay;
        }

        @Override
        public Duration timeout() {
            return this.timeoutDelay;
        }
    }

    public static interface Outcome {
        public boolean shouldExecute();

        public Duration backoffDelay();

        public Duration timeout();
    }
}

