/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.tascalate.concurrent.AggregatingPromise;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.CompletableTask;
import net.tascalate.concurrent.CompletionStageWrapper;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.ExecutorBoundCompletionStage;
import net.tascalate.concurrent.LinkedCompletion;
import net.tascalate.concurrent.MultitargetException;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.RetryPolicy;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.Timeouts;

public class Promises {
    private static final Object IGNORE = new Object();

    private Promises() {
    }

    public static <T> Promise<T> success(T value) {
        return new CompletableFutureWrapper<T>(CompletableFuture.completedFuture(value));
    }

    public static <T> Promise<T> failure(Throwable exception) {
        CompletableFuture delegate = new CompletableFuture();
        delegate.completeExceptionally(exception);
        return new CompletableFutureWrapper(delegate);
    }

    public static <T> Promise<T> from(CompletionStage<T> stage) {
        if (stage instanceof Promise) {
            return (Promise)stage;
        }
        if (stage instanceof CompletableFuture) {
            return new CompletableFutureWrapper((CompletableFuture)stage);
        }
        return CompletionStageWrapper.from(stage);
    }

    public static <T> CompletionStage<T> withDefaultExecutor(CompletionStage<T> stage, Executor executor) {
        return new ExecutorBoundCompletionStage<T>(stage, executor);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> all(CompletionStage<? extends T> ... promises) {
        return Promises.all(Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> all(List<? extends CompletionStage<? extends T>> promises) {
        return Promises.all(true, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> all(boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.all(cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> all(boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(null != promises ? promises.size() : 0, 0, cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<T> any(CompletionStage<? extends T> ... promises) {
        return Promises.any(Arrays.asList(promises));
    }

    public static <T> Promise<T> any(List<? extends CompletionStage<? extends T>> promises) {
        return Promises.any(true, promises);
    }

    @SafeVarargs
    public static <T> Promise<T> any(boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.any(cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<T> any(boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        int size = null == promises ? 0 : promises.size();
        switch (size) {
            case 0: {
                return Promises.insufficientNumberOfArguments(1, 0);
            }
            case 1: {
                CompletionStage<? extends T> singleResult = promises.get(0);
                return Promises.transform(singleResult, Function.identity(), Promises::wrapMultitargetException);
            }
        }
        return Promises.transform(Promises.atLeast(1, size - 1, cancelRemaining, promises), Promises::extractFirstNonNull, Function.identity());
    }

    @SafeVarargs
    public static <T> Promise<T> anyStrict(CompletionStage<? extends T> ... promises) {
        return Promises.anyStrict(Arrays.asList(promises));
    }

    public static <T> Promise<T> anyStrict(List<? extends CompletionStage<? extends T>> promises) {
        return Promises.anyStrict(true, promises);
    }

    @SafeVarargs
    public static <T> Promise<T> anyStrict(boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.anyStrict(cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<T> anyStrict(boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        int size = null == promises ? 0 : promises.size();
        switch (size) {
            case 0: {
                return Promises.insufficientNumberOfArguments(1, 0);
            }
            case 1: {
                CompletionStage<? extends T> singleResult = promises.get(0);
                return Promises.from(singleResult);
            }
        }
        return Promises.transform(Promises.atLeast(1, 0, cancelRemaining, promises), Promises::extractFirstNonNull, Promises::unwrapMultitargetException);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeast(int minResultsCount, CompletionStage<? extends T> ... promises) {
        return Promises.atLeast(minResultsCount, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeast(int minResultsCount, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, true, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeast(int minResultsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeast(minResultsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeast(int minResultsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, (promises == null ? 0 : promises.size()) - minResultsCount, cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeastStrict(int minResultsCount, CompletionStage<? extends T> ... promises) {
        return Promises.atLeastStrict(minResultsCount, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeastStrict(int minResultsCount, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeastStrict(minResultsCount, true, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeastStrict(int minResultsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeast(minResultsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeastStrict(int minResultsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        return Promises.atLeast(minResultsCount, 0, cancelRemaining, promises);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> atLeast(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, CompletionStage<? extends T> ... promises) {
        return Promises.atLeast(minResultsCount, maxErrorsCount, cancelRemaining, Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> atLeast(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        int size;
        int n = size = null == promises ? 0 : promises.size();
        if (minResultsCount > size) {
            Promise<List<T>> result = Promises.insufficientNumberOfArguments(minResultsCount, size);
            if (cancelRemaining && size > 0) {
                promises.stream().forEach(p -> SharedFunctions.cancelPromise(p, true));
            }
            return result;
        }
        if (minResultsCount == 0) {
            return Promises.success(Collections.emptyList());
        }
        if (size == 1) {
            CompletionStage<? extends T> stage = promises.get(0);
            return Promises.transform(stage, Collections::singletonList, Promises::wrapMultitargetException);
        }
        return new AggregatingPromise(minResultsCount, maxErrorsCount, cancelRemaining, promises);
    }

    public static Promise<Void> retry(Runnable codeBlock, Executor executor, RetryPolicy retryPolicy) {
        Promise wrappedResult = Promises.pollOptional(() -> {
            codeBlock.run();
            return Optional.of(IGNORE);
        }, executor, retryPolicy);
        return wrappedResult.dependent().thenApply(v -> null, true).raw();
    }

    public static <T> Promise<T> retry(Callable<? extends T> codeBlock, Executor executor, RetryPolicy retryPolicy) {
        Promise<T> wrappedResult = Promises.pollOptional(() -> Optional.of(new ObjectRef(codeBlock.call())), executor, retryPolicy);
        return wrappedResult.dependent().thenApply(ObjectRef::dereference, true).raw();
    }

    public static <T> Promise<T> poll(Callable<T> codeBlock, Executor executor, RetryPolicy retryPolicy) {
        return Promises.pollOptional(() -> Optional.ofNullable(codeBlock.call()), executor, retryPolicy);
    }

    public static <T> Promise<T> pollOptional(Callable<Optional<? extends T>> codeBlock, Executor executor, RetryPolicy retryPolicy) {
        CompletableFuture result = new CompletableFuture();
        AtomicReference callPromiseRef = new AtomicReference();
        result.whenComplete((r, e) -> Optional.of(callPromiseRef).map(AtomicReference::get).ifPresent(p -> p.cancel(true)));
        Consumer<Promise<?>> changeCallPromiseRef = p -> {
            callPromiseRef.set(p);
            if (result.isDone()) {
                p.cancel(true);
            }
        };
        RetryContext ctx = RetryContext.initial(retryPolicy);
        Promises.pollOnce(codeBlock, executor, ctx, result, changeCallPromiseRef);
        return new CompletableFutureWrapper(result).defaultAsyncOn(executor);
    }

    private static <T> void pollOnce(Callable<Optional<? extends T>> codeBlock, Executor executor, RetryContext ctx, CompletableFuture<T> resultPromise, Consumer<Promise<?>> changeCallPromiseRef) {
        if (resultPromise.isDone()) {
            return;
        }
        RetryPolicy.Outcome answer = ctx.shouldContinue();
        if (answer.shouldExecute()) {
            Runnable doCall = () -> {
                long startTime = System.nanoTime();
                try {
                    Optional result;
                    ctx.enter();
                    try {
                        result = (Optional)codeBlock.call();
                    }
                    finally {
                        ctx.exit();
                    }
                    if (result.isPresent()) {
                        resultPromise.complete(result.get());
                    } else {
                        long finishTime = System.nanoTime();
                        RetryContext nextCtx = ctx.nextRetry(Duration.ofNanos(finishTime - startTime));
                        Promises.pollOnce(codeBlock, executor, nextCtx, resultPromise, changeCallPromiseRef);
                    }
                }
                catch (Exception ex) {
                    long finishTime = System.nanoTime();
                    RetryContext nextCtx = ctx.nextRetry(Duration.ofNanos(finishTime - startTime), ex);
                    Promises.pollOnce(codeBlock, executor, nextCtx, resultPromise, changeCallPromiseRef);
                }
            };
            Supplier<Promise> submittedCall = () -> {
                Promise<Void> p = CompletableTask.runAsync(doCall, executor);
                Duration timeout = answer.timeout();
                if (DelayPolicy.isValid(timeout)) {
                    p.orTimeout(timeout);
                }
                return p;
            };
            Duration backoffDelay = answer.backoffDelay();
            if (DelayPolicy.isValid(backoffDelay)) {
                Promise<Duration> backoff = Timeouts.delay(backoffDelay);
                backoff.thenAccept(d -> changeCallPromiseRef.accept((Promise<?>)submittedCall.get()));
                changeCallPromiseRef.accept(backoff);
            } else {
                changeCallPromiseRef.accept(submittedCall.get());
            }
        } else {
            resultPromise.completeExceptionally(ctx.asFailure());
        }
    }

    private static <T, U> Promise<T> transform(CompletionStage<U> original, Function<? super U, ? extends T> resultMapper, Function<? super Throwable, ? extends Throwable> errorMapper) {
        LinkedCompletion.StageCompletion result = new LinkedCompletion.StageCompletion().dependsOn(original);
        original.whenComplete((r, e) -> {
            if (null == e) {
                result.complete(resultMapper.apply((Object)r));
            } else {
                result.completeExceptionally((Throwable)errorMapper.apply((Throwable)e));
            }
        });
        return result.toPromise();
    }

    private static <T> T extractFirstNonNull(Collection<? extends T> collection) {
        return (T)collection.stream().filter(Objects::nonNull).findFirst().get();
    }

    private static <E extends Throwable> Throwable unwrapMultitargetException(E exception) {
        Throwable targetException = SharedFunctions.unwrapCompletionException(exception);
        if (targetException instanceof MultitargetException) {
            return ((MultitargetException)targetException).getFirstException().get();
        }
        return targetException;
    }

    private static <E extends Throwable> MultitargetException wrapMultitargetException(E exception) {
        if (exception instanceof MultitargetException) {
            return (MultitargetException)exception;
        }
        return MultitargetException.of(exception);
    }

    private static <T> Promise<T> insufficientNumberOfArguments(int minResultCount, int size) {
        String message = String.format("The number of futures supplied (%d) is less than a number of futures to await (%d)", size, minResultCount);
        throw new IllegalArgumentException(message);
    }

    private static class ObjectRef<T> {
        private final T reference;

        ObjectRef(T reference) {
            this.reference = reference;
        }

        T dereference() {
            return this.reference;
        }
    }
}

