/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.tascalate.concurrent.DependentPromise;
import net.tascalate.concurrent.PromiseOrigin;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.Timeouts;
import net.tascalate.concurrent.decorators.ExecutorBoundPromise;

public interface Promise<T>
extends Future<T>,
CompletionStage<T> {
    default public T getNow(T valueIfAbsent) throws CancellationException, CompletionException {
        return (T)this.getNow(() -> valueIfAbsent);
    }

    default public T getNow(Supplier<? extends T> valueIfAbsent) throws CancellationException, CompletionException {
        if (this.isDone()) {
            try {
                return (T)this.get();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                throw SharedFunctions.wrapCompletionException(SharedFunctions.unwrapExecutionException(ex));
            }
        }
        return valueIfAbsent.get();
    }

    default public T join() throws CancellationException, CompletionException {
        try {
            return (T)this.get();
        }
        catch (InterruptedException ex) {
            throw new CompletionException(ex);
        }
        catch (ExecutionException ex) {
            throw SharedFunctions.wrapCompletionException(SharedFunctions.unwrapExecutionException(ex));
        }
    }

    default public Promise<T> delay(long timeout, TimeUnit unit) {
        return this.delay(timeout, unit, true);
    }

    default public Promise<T> delay(long timeout, TimeUnit unit, boolean delayOnError) {
        return this.delay(Timeouts.toDuration(timeout, unit), delayOnError);
    }

    default public Promise<T> delay(Duration duration) {
        return this.delay(duration, true);
    }

    default public Promise<T> delay(Duration duration, boolean delayOnError) {
        CompletableFuture delayed = new CompletableFuture();
        this.whenComplete(Timeouts.configureDelay(this, delayed, duration, delayOnError));
        return this.dependent().thenCombineAsync(delayed, (? super T r, ? super U d) -> r, PromiseOrigin.PARAM_ONLY).raw();
    }

    default public Promise<T> orTimeout(long timeout, TimeUnit unit) {
        return this.orTimeout(timeout, unit, true);
    }

    default public Promise<T> orTimeout(long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.orTimeout(Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    default public Promise<T> orTimeout(Duration duration) {
        return this.orTimeout(duration, true);
    }

    default public Promise<T> orTimeout(Duration duration, boolean cancelOnTimeout) {
        Promise timeout = Timeouts.failAfter(duration);
        DependentPromise result = this.dependent().applyToEitherAsync(timeout, Function.identity(), PromiseOrigin.PARAM_ONLY);
        result.whenComplete(Timeouts.timeoutsCleanup(this, timeout, cancelOnTimeout));
        return result.raw();
    }

    default public Promise<T> onTimeout(T value, long timeout, TimeUnit unit) {
        return this.onTimeout(value, timeout, unit, true);
    }

    default public Promise<T> onTimeout(T value, long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.onTimeout(value, Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    default public Promise<T> onTimeout(T value, Duration duration) {
        return this.onTimeout(value, duration, true);
    }

    default public Promise<T> onTimeout(T value, Duration duration, boolean cancelOnTimeout) {
        return this.onTimeout(() -> value, duration, cancelOnTimeout);
    }

    default public Promise<T> onTimeout(Supplier<? extends T> supplier, long timeout, TimeUnit unit) {
        return this.onTimeout(supplier, timeout, unit, true);
    }

    default public Promise<T> onTimeout(Supplier<? extends T> supplier, long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.onTimeout(supplier, Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    default public Promise<T> onTimeout(Supplier<? extends T> supplier, Duration duration) {
        return this.onTimeout(supplier, duration, true);
    }

    default public Promise<T> onTimeout(Supplier<? extends T> supplier, Duration duration, boolean cancelOnTimeout) {
        Function<Object, Supplier> valueToSupplier = v -> () -> v;
        DependentPromise<Supplier> timeout = Timeouts.delay(duration).dependent().thenApply(d -> supplier, true);
        DependentPromise<Object> result = this.dependent().thenApply(valueToSupplier, false).applyToEitherAsync(timeout, Supplier::get, PromiseOrigin.ALL);
        result.whenComplete(Timeouts.timeoutsCleanup(this, timeout, cancelOnTimeout));
        return result.raw();
    }

    default public DependentPromise<T> dependent() {
        return DependentPromise.from(this);
    }

    default public DependentPromise<T> dependent(Set<PromiseOrigin> defaultEnlistOptions) {
        return DependentPromise.from(this, defaultEnlistOptions);
    }

    default public Promise<T> defaultAsyncOn(Executor executor) {
        return new ExecutorBoundPromise(this, executor);
    }

    default public <D> D as(Function<? super Promise<T>, D> decoratorFactory) {
        return decoratorFactory.apply(this);
    }

    default public Promise<T> raw() {
        return this;
    }

    @Override
    public <U> Promise<U> thenApply(Function<? super T, ? extends U> var1);

    @Override
    public <U> Promise<U> thenApplyAsync(Function<? super T, ? extends U> var1);

    @Override
    public <U> Promise<U> thenApplyAsync(Function<? super T, ? extends U> var1, Executor var2);

    public Promise<Void> thenAccept(Consumer<? super T> var1);

    public Promise<Void> thenAcceptAsync(Consumer<? super T> var1);

    public Promise<Void> thenAcceptAsync(Consumer<? super T> var1, Executor var2);

    public Promise<Void> thenRun(Runnable var1);

    public Promise<Void> thenRunAsync(Runnable var1);

    public Promise<Void> thenRunAsync(Runnable var1, Executor var2);

    @Override
    public <U, V> Promise<V> thenCombine(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    @Override
    public <U, V> Promise<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    @Override
    public <U, V> Promise<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2, Executor var3);

    public <U> Promise<Void> thenAcceptBoth(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U> Promise<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U> Promise<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2, Executor var3);

    public Promise<Void> runAfterBoth(CompletionStage<?> var1, Runnable var2);

    public Promise<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2);

    public Promise<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> Promise<U> applyToEither(CompletionStage<? extends T> var1, Function<? super T, U> var2);

    @Override
    public <U> Promise<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2);

    @Override
    public <U> Promise<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2, Executor var3);

    public Promise<Void> acceptEither(CompletionStage<? extends T> var1, Consumer<? super T> var2);

    public Promise<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2);

    public Promise<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2, Executor var3);

    public Promise<Void> runAfterEither(CompletionStage<?> var1, Runnable var2);

    public Promise<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2);

    public Promise<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> Promise<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> var1);

    @Override
    public <U> Promise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1);

    @Override
    public <U> Promise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1, Executor var2);

    @Override
    public Promise<T> exceptionally(Function<Throwable, ? extends T> var1);

    @Override
    public Promise<T> whenComplete(BiConsumer<? super T, ? super Throwable> var1);

    @Override
    public Promise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1);

    @Override
    public Promise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1, Executor var2);

    @Override
    public <U> Promise<U> handle(BiFunction<? super T, Throwable, ? extends U> var1);

    @Override
    public <U> Promise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1);

    @Override
    public <U> Promise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1, Executor var2);
}

