/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.SharedFunctions;

abstract class LinkedCompletion<T, F>
extends CompletableFuture<T> {
    protected F dependency;

    LinkedCompletion() {
    }

    LinkedCompletion<T, F> dependsOn(F dependency) {
        this.dependency = dependency;
        return this;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelDependency(mayInterruptIfRunning)) {
            return super.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    final Promise<T> toPromise() {
        return new CompletableFutureWrapper(this);
    }

    abstract boolean cancelDependency(boolean var1);

    static final class StageCompletion<T>
    extends LinkedCompletion<T, CompletionStage<?>> {
        StageCompletion() {
        }

        @Override
        boolean cancelDependency(boolean mayInterruptIfRunning) {
            return SharedFunctions.cancelPromise((CompletionStage)this.dependency, mayInterruptIfRunning);
        }

        StageCompletion<T> dependsOn(CompletionStage<?> dependency) {
            return (StageCompletion)super.dependsOn(dependency);
        }
    }

    static final class FutureCompletion<T>
    extends LinkedCompletion<T, Future<?>> {
        FutureCompletion() {
        }

        @Override
        boolean cancelDependency(boolean mayInterruptIfRunning) {
            return ((Future)this.dependency).cancel(mayInterruptIfRunning);
        }

        FutureCompletion<T> dependsOn(Future<?> dependency) {
            return (FutureCompletion)super.dependsOn(dependency);
        }
    }
}

