/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.Promises;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.decorators.AbstractCompletionStageDecorator;
import net.tascalate.concurrent.decorators.BlockingCompletionStageDecorator;

public class CompletionStageWrapper<T>
extends AbstractCompletionStageDecorator<T, CompletionStage<T>>
implements Promise<T> {
    private final CountDownLatch whenDone = new CountDownLatch(1);
    private volatile T result = null;
    private volatile Throwable fault = null;

    protected CompletionStageWrapper(CompletionStage<T> delegate) {
        super(delegate);
        delegate.whenComplete((? super T r, ? super Throwable e) -> {
            this.result = r;
            this.fault = e;
            this.whenDone.countDown();
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return SharedFunctions.cancelPromise(this.delegate, mayInterruptIfRunning);
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.whenDone.await();
        if (null == this.fault) {
            return this.result;
        }
        if (this.fault instanceof CancellationException) {
            throw (CancellationException)this.fault;
        }
        throw SharedFunctions.wrapExecutionException(SharedFunctions.unwrapCompletionException(this.fault));
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.whenDone.await(timeout, unit);
        if (null == this.fault) {
            return this.result;
        }
        if (this.fault instanceof CancellationException) {
            throw (CancellationException)this.fault;
        }
        throw SharedFunctions.wrapExecutionException(SharedFunctions.unwrapCompletionException(this.fault));
    }

    public boolean isCompletedExceptionally() {
        return this.isDone() && this.fault != null;
    }

    @Override
    public boolean isCancelled() {
        return this.isDone() && this.fault instanceof CancellationException;
    }

    @Override
    public boolean isDone() {
        return this.whenDone.getCount() == 0L;
    }

    @Override
    public T join() {
        try {
            this.whenDone.await();
        }
        catch (InterruptedException ex) {
            throw new CompletionException(ex);
        }
        if (null == this.fault) {
            return this.result;
        }
        if (this.fault instanceof CancellationException) {
            throw (CancellationException)this.fault;
        }
        throw SharedFunctions.wrapCompletionException(this.fault);
    }

    @Override
    protected <U> Promise<U> wrap(CompletionStage<U> original) {
        return Promises.from(original);
    }

    public static <T> Promise<T> from(CompletionStage<T> stage) {
        if (stage instanceof Future) {
            return BlockingCompletionStageDecorator.from(stage);
        }
        return new CompletionStageWrapper<T>(stage);
    }
}

