/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.MultitargetException;
import net.tascalate.concurrent.SharedFunctions;

class AggregatingPromise<T>
extends CompletableFutureWrapper<List<T>> {
    private final List<T> results;
    private final List<Throwable> errors;
    private final AtomicIntegerArray completions;
    private final AtomicInteger resultsCount = new AtomicInteger(0);
    private final AtomicInteger errorsCount = new AtomicInteger(0);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final int minResultsCount;
    private final int maxErrorsCount;
    private final boolean cancelRemaining;
    private final List<? extends CompletionStage<? extends T>> promises;
    private static final int PENDING = 0;
    private static final int COMPLETED_RESULT = 1;
    private static final int COMPLETED_ERROR = 2;
    private static final int COMPLETED_CANCEL = -1;

    AggregatingPromise(int minResultsCount, int maxErrorsCount, boolean cancelRemaining, List<? extends CompletionStage<? extends T>> promises) {
        if (null == promises || promises.isEmpty()) {
            throw new IllegalArgumentException("There are should be at least one promise specified");
        }
        int size = promises.size();
        this.promises = promises;
        this.minResultsCount = minResultsCount < 0 ? size : Math.max(1, Math.min(size, minResultsCount));
        this.maxErrorsCount = maxErrorsCount < 0 ? promises.size() - minResultsCount : Math.max(0, Math.min(maxErrorsCount, size - minResultsCount));
        this.cancelRemaining = cancelRemaining;
        this.results = AggregatingPromise.newList(size);
        this.errors = AggregatingPromise.newList(size);
        this.completions = new AtomicIntegerArray(size);
        this.setupCompletionHandlers();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.done.compareAndSet(false, true)) {
            this.markRemainingCancelled();
            this.cancelPromises();
            return super.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    void onComplete(int idx, T result, Throwable error) {
        if (!this.completions.compareAndSet(idx, 0, null == error ? 1 : 2)) {
            return;
        }
        if (null == error) {
            int c = this.resultsCount.incrementAndGet();
            if (c <= this.minResultsCount) {
                this.results.set(idx, result);
                if (c == this.minResultsCount && this.done.compareAndSet(false, true)) {
                    this.markRemainingCancelled();
                    ((CompletableFuture)this.delegate).complete(Collections.unmodifiableList(this.results));
                    if (this.cancelRemaining) {
                        this.cancelPromises();
                    }
                }
            }
        } else {
            int c = this.errorsCount.getAndIncrement();
            if (c <= this.maxErrorsCount) {
                this.errors.set(idx, error);
                if (c == this.maxErrorsCount && this.done.compareAndSet(false, true)) {
                    this.markRemainingCancelled();
                    ((CompletableFuture)this.delegate).completeExceptionally(new MultitargetException(Collections.unmodifiableList(this.errors)));
                    if (this.cancelRemaining) {
                        this.cancelPromises();
                    }
                }
            }
        }
    }

    private void markRemainingCancelled() {
        for (int idx = this.completions.length() - 1; idx >= 0; --idx) {
            this.completions.compareAndSet(idx, 0, -1);
        }
    }

    private void setupCompletionHandlers() {
        int i = 0;
        for (CompletionStage<Object> completionStage : this.promises) {
            int idx = i++;
            completionStage.whenComplete((? super T r, ? super Throwable e) -> this.onComplete(idx, (T)r, (Throwable)e));
        }
    }

    private void cancelPromises() {
        int i = 0;
        for (CompletionStage<? extends T> completionStage : this.promises) {
            int idx;
            if (this.completions.get(idx = i++) != -1) continue;
            SharedFunctions.cancelPromise(completionStage, true);
        }
    }

    private static <T> List<T> newList(int length) {
        ArrayList<Object> result = new ArrayList<Object>(length);
        for (int i = length - 1; i >= 0; --i) {
            result.add(null);
        }
        return result;
    }
}

