/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.tascalate.concurrent.CallbackRegistry;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseAdapter;
import net.tascalate.concurrent.SharedFunctions;

abstract class AbstractCompletableTask<T>
extends PromiseAdapter<T>
implements Promise<T> {
    private final CallbackRegistry<T> callbackRegistry = new CallbackRegistry();
    protected final RunnableFuture<T> task;
    protected final Callable<T> action;
    private CompletionStage<?>[] cancellableOrigins;
    private Object cancellableOriginsLock = new Object();

    protected AbstractCompletableTask(Executor defaultExecutor, Callable<T> action) {
        super(defaultExecutor);
        this.action = action;
        this.task = new StageTransition(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCancellableOrigins(CompletionStage<?> ... origins) {
        Object object = this.cancellableOriginsLock;
        synchronized (object) {
            this.cancellableOrigins = origins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelOrigins(boolean mayInterruptIfRunning) {
        Object object = this.cancellableOriginsLock;
        synchronized (object) {
            if (null == this.cancellableOrigins) {
                return;
            }
            Arrays.stream(this.cancellableOrigins).forEach(p -> SharedFunctions.cancelPromise(p, mayInterruptIfRunning));
        }
    }

    abstract void fireTransition(Callable<T> var1);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.task.cancel(mayInterruptIfRunning)) {
            this.onError(new CancellationException());
            this.cancelOrigins(mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return (T)this.task.get();
        }
        catch (ExecutionException ex) {
            throw AbstractCompletableTask.rewrapExecutionException(ex);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (T)this.task.get(timeout, unit);
        }
        catch (ExecutionException ex) {
            throw AbstractCompletableTask.rewrapExecutionException(ex);
        }
    }

    boolean onSuccess(T result) {
        return this.callbackRegistry.success(result);
    }

    boolean onError(Throwable ex) {
        return this.callbackRegistry.failure(ex);
    }

    @Override
    public <U> Promise<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        AbstractCompletableTask<U> nextStage = this.internalCreateCompletionStage(executor);
        this.addCallbacks(nextStage, fn, executor);
        return nextStage;
    }

    @Override
    public Promise<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.thenApplyAsync(AbstractCompletableTask.consumerAsFunction(action), executor);
    }

    @Override
    public Promise<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.thenApplyAsync(AbstractCompletableTask.runnableAsFunction(action), executor);
    }

    @Override
    public <U, V> Promise<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.thenCompose((T result1) -> other.thenApplyAsync((? super T result2) -> fn.apply(result1, result2), executor));
    }

    @Override
    public <U> Promise<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.thenCombineAsync((CompletionStage)other, (T t, U u) -> {
            action.accept(t, u);
            return null;
        }, executor);
    }

    @Override
    public Promise<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.thenCombineAsync(other, (T t, U r) -> {
            action.run();
            return null;
        }, executor);
    }

    @Override
    public <U> Promise<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.doApplyToEitherAsync(this, other, fn, executor);
    }

    @Override
    public Promise<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.applyToEitherAsync((CompletionStage)other, AbstractCompletableTask.consumerAsFunction(action), executor);
    }

    @Override
    public Promise<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.doApplyToEitherAsync(this, other, AbstractCompletableTask.runnableAsFunction(action), executor);
    }

    @Override
    public <U> Promise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        AbstractCompletableTask<U> tempStage = this.internalCreateCompletionStage(executor);
        AbstractCompletableTask nextStage = this.internalCreateCompletionStage(executor);
        nextStage.resetCancellableOrigins(tempStage);
        Consumer onResult = super.runTransition(Function.identity());
        Consumer<Throwable> onError = super.runTransition(AbstractCompletableTask::forwardException);
        this.addCallbacks(tempStage, AbstractCompletableTask.consumerAsFunction(r -> {
            try {
                CompletionStage returned = (CompletionStage)fn.apply(r);
                nextStage.resetCancellableOrigins(returned);
                if (nextStage.isCancelled()) {
                    nextStage.cancelOrigins(true);
                } else {
                    returned.whenComplete(AbstractCompletableTask.biConsumer(onResult, onError));
                }
            }
            catch (Throwable ex) {
                nextStage.resetCancellableOrigins(new CompletionStage[]{null});
                onError.accept(ex);
            }
        }), AbstractCompletableTask.consumerAsFunction(onError), executor);
        return nextStage;
    }

    private <U> Consumer<? super U> runTransition(Function<? super U, ? extends T> converter) {
        return u -> this.fireTransition(() -> converter.apply((Object)u));
    }

    @Override
    public Promise<T> exceptionally(Function<Throwable, ? extends T> fn) {
        AbstractCompletableTask nextStage = this.internalCreateCompletionStage(this.getDefaultExecutor());
        this.addCallbacks(nextStage, Function.identity(), fn, SAME_THREAD_EXECUTOR);
        return nextStage;
    }

    @Override
    public Promise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        AbstractCompletableTask nextStage = this.internalCreateCompletionStage(executor);
        this.addCallbacks(nextStage, (? super T result) -> {
            try {
                action.accept(result, null);
            }
            catch (Throwable e) {
                return AbstractCompletableTask.forwardException(e);
            }
            return result;
        }, (Throwable failure) -> {
            try {
                action.accept((Object)null, (Throwable)failure);
            }
            catch (Throwable e) {
                failure.addSuppressed(e);
            }
            return AbstractCompletableTask.forwardException(failure);
        }, executor);
        return nextStage;
    }

    @Override
    public <U> Promise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        AbstractCompletableTask<U> nextStage = this.internalCreateCompletionStage(executor);
        this.addCallbacks(nextStage, (? super T result) -> {
            try {
                return fn.apply(result, null);
            }
            catch (Throwable e) {
                return AbstractCompletableTask.forwardException(e);
            }
        }, (Throwable failure) -> {
            try {
                return fn.apply((Object)null, (Throwable)failure);
            }
            catch (Throwable e) {
                return AbstractCompletableTask.forwardException(e);
            }
        }, executor);
        return nextStage;
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture completableFuture = new CompletableFuture();
        Consumer<Callable> setup = c -> {
            try {
                c.call();
            }
            catch (Throwable ex) {
                completableFuture.completeExceptionally(ex);
            }
        };
        this.addCallbacks(setup, AbstractCompletableTask.consumerAsFunction(completableFuture::complete), AbstractCompletableTask.consumerAsFunction(completableFuture::completeExceptionally), SAME_THREAD_EXECUTOR);
        return completableFuture;
    }

    protected abstract <U> AbstractCompletableTask<U> createCompletionStage(Executor var1);

    private <R, U> Promise<U> doApplyToEitherAsync(CompletionStage<? extends R> first, CompletionStage<? extends R> second, Function<? super R, U> fn, Executor executor) {
        AbstractCompletableTask nextStage = this.internalCreateCompletionStage(executor);
        BiConsumer<Object, Throwable> action = (result, failure) -> {
            if (failure == null) {
                nextStage.onSuccess(result);
            } else {
                nextStage.onError((Throwable)AbstractCompletableTask.forwardException(failure));
            }
        };
        first.whenComplete(action);
        second.whenComplete(action);
        return nextStage.thenApplyAsync(fn, executor);
    }

    private <U> AbstractCompletableTask<U> internalCreateCompletionStage(Executor executor) {
        return this.createCompletionStage(executor == SAME_THREAD_EXECUTOR ? this.getDefaultExecutor() : executor);
    }

    private static <V, R> Function<V, R> consumerAsFunction(Consumer<? super V> action) {
        return result -> {
            action.accept((Object)result);
            return null;
        };
    }

    private static <R> Function<R, Void> runnableAsFunction(Runnable action) {
        return result -> {
            action.run();
            return null;
        };
    }

    private static <U, V> BiConsumer<U, V> biConsumer(Consumer<? super U> onResult, Consumer<? super V> onError) {
        return (u, v) -> {
            if (null == v) {
                onResult.accept((Object)u);
            } else {
                onError.accept((Object)v);
            }
        };
    }

    private static <U> U forwardException(Throwable e) {
        throw SharedFunctions.wrapCompletionException(e);
    }

    private static ExecutionException rewrapExecutionException(ExecutionException ex) {
        return SharedFunctions.wrapExecutionException(SharedFunctions.unwrapCompletionException(SharedFunctions.unwrapExecutionException(ex)));
    }

    private <U> void addCallbacks(AbstractCompletableTask<U> targetStage, Function<? super T, ? extends U> successCallback, Executor executor) {
        this.addCallbacks(targetStage, successCallback, AbstractCompletableTask::forwardException, executor);
    }

    private <U> void addCallbacks(AbstractCompletableTask<U> targetStage, Function<? super T, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
        this.addCallbacks(targetStage::fireTransition, successCallback, failureCallback, executor);
    }

    private <U> void addCallbacks(Consumer<? super Callable<U>> stageTransition, Function<? super T, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
        this.callbackRegistry.addCallbacks(stageTransition, successCallback, failureCallback, executor);
    }

    class StageTransition
    extends FutureTask<T> {
        StageTransition(Callable<T> callable) {
            super(callable);
        }

        @Override
        protected void set(T v) {
            super.set(v);
            AbstractCompletableTask.this.onSuccess(v);
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
            AbstractCompletableTask.this.onError(t);
        }
    }
}

