/*
 * Decompiled with CFR 0.152.
 */
package net.steamcrafted.materialiconlib;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.InflateException;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.steamcrafted.materialiconlib.MaterialDrawableBuilder;
import net.steamcrafted.materialiconlib.MaterialIconUtils;
import net.steamcrafted.materialiconlib.R;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MaterialMenuInflater {
    private static final String XML_MENU = "menu";
    private static final String XML_GROUP = "group";
    private static final String XML_ITEM = "item";
    private final Context mContext;
    private final MenuInflater mInflater;
    private int mDefaultColor;

    private MaterialMenuInflater(Context context, MenuInflater inflater) {
        this.mContext = context;
        this.mInflater = inflater;
        this.mDefaultColor = this.getDefaultColor();
    }

    public static MaterialMenuInflater with(Context context) {
        return new MaterialMenuInflater(context, context instanceof Activity ? ((Activity)context).getMenuInflater() : new MenuInflater(context));
    }

    public static MaterialMenuInflater with(Context context, MenuInflater inflater) {
        return new MaterialMenuInflater(context, inflater);
    }

    public MaterialMenuInflater setDefaultColor(int color) {
        this.mDefaultColor = color;
        return this;
    }

    public MaterialMenuInflater setDefaultColorResource(int colorRes) {
        this.mDefaultColor = MaterialIconUtils.getColorResource(this.mContext, colorRes);
        return this;
    }

    public void inflate(int menuRes, Menu menu) {
        menu.clear();
        this.mInflater.inflate(menuRes, menu);
        this.afterInflate(menuRes, menu);
    }

    private void afterInflate(int menuRes, Menu menu) {
        IconData root = new IconData(0, 0, 0);
        XmlResourceParser parser = null;
        try {
            parser = this.mContext.getResources().getLayout(menuRes);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            this.parseMenu((XmlPullParser)parser, attrs, root);
        }
        catch (XmlPullParserException e) {
            throw new InflateException("Error inflating menu XML", (Throwable)e);
        }
        catch (IOException e) {
            throw new InflateException("Error inflating menu XML", (Throwable)e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            this.populateIcons(menu, root, this.mDefaultColor);
        }
    }

    private int getDefaultColor() {
        TypedValue outValue = new TypedValue();
        this.mContext.getTheme().resolveAttribute(R.attr.materialIconColor, outValue, true);
        if (outValue.resourceId != 0 && outValue.type == 2) {
            ColorStateList stateList = null;
            stateList = Build.VERSION.SDK_INT >= 23 ? this.mContext.getResources().getColorStateList(outValue.resourceId, this.mContext.getTheme()) : this.mContext.getResources().getColorStateList(outValue.resourceId);
            if (stateList != null) {
                return stateList.getDefaultColor();
            }
        }
        if (outValue.type <= 31 && outValue.type >= 28) {
            return outValue.data;
        }
        return -16777216;
    }

    private void populateIcons(Menu menu, IconData root, int defaultIconColor) {
        for (int i = 0; i < menu.size(); ++i) {
            MenuItem m = menu.getItem(i);
            IconData d = root.children.get(i);
            if (m.hasSubMenu()) {
                this.populateIcons((Menu)m.getSubMenu(), d, defaultIconColor);
            }
            if (d.itemIconResId < 0) continue;
            m.setIcon(MaterialDrawableBuilder.with(this.mContext).setIcon(MaterialDrawableBuilder.IconValue.values()[d.itemIconResId]).setColor(d.itemColor != -1 ? d.itemColor : defaultIconColor).setToActionbarSize().build());
        }
    }

    private void parseMenu(XmlPullParser parser, AttributeSet attrs, IconData menu) throws XmlPullParserException, IOException {
        String tagName;
        MenuState menuState = new MenuState(menu);
        int eventType = parser.getEventType();
        boolean lookingForEndOfUnknownTag = false;
        String unknownTagName = null;
        do {
            if (eventType != 2) continue;
            tagName = parser.getName();
            if (tagName.equals(XML_MENU)) {
                eventType = parser.next();
                break;
            }
            throw new RuntimeException("Expecting menu, got " + tagName);
        } while ((eventType = parser.next()) != 1);
        boolean reachedEndOfMenu = false;
        while (!reachedEndOfMenu) {
            switch (eventType) {
                case 2: {
                    if (lookingForEndOfUnknownTag) break;
                    tagName = parser.getName();
                    if (tagName.equals(XML_GROUP)) {
                        menuState.readGroup(attrs);
                        break;
                    }
                    if (tagName.equals(XML_ITEM)) {
                        menuState.readItem(attrs);
                        break;
                    }
                    if (tagName.equals(XML_MENU)) {
                        IconData subMenu = menuState.addSubMenuItem();
                        this.parseMenu(parser, attrs, subMenu);
                        break;
                    }
                    lookingForEndOfUnknownTag = true;
                    unknownTagName = tagName;
                    break;
                }
                case 3: {
                    tagName = parser.getName();
                    if (lookingForEndOfUnknownTag && tagName.equals(unknownTagName)) {
                        lookingForEndOfUnknownTag = false;
                        unknownTagName = null;
                        break;
                    }
                    if (tagName.equals(XML_GROUP)) {
                        menuState.resetGroup();
                        break;
                    }
                    if (tagName.equals(XML_ITEM)) {
                        if (menuState.hasAddedItem()) break;
                        menuState.addItem();
                        break;
                    }
                    if (!tagName.equals(XML_MENU)) break;
                    reachedEndOfMenu = true;
                    break;
                }
                case 1: {
                    throw new RuntimeException("Unexpected end of document");
                }
            }
            eventType = parser.next();
        }
    }

    private class MenuState {
        static final int USER_MASK = 65535;
        static final int USER_SHIFT = 0;
        static final int CATEGORY_MASK = -65536;
        static final int CATEGORY_SHIFT = 16;
        final int[] sCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
        private static final int defaultItemCategory = 0;
        private static final int defaultItemOrder = 0;
        private boolean itemAdded;
        private int itemIconResId;
        private int itemIconColor;
        private int categoryOrder;
        private int groupCategory;
        private int groupOrder;
        private IconData menu;

        public MenuState(IconData menu) {
            this.menu = menu;
            this.resetGroup();
        }

        public void resetGroup() {
            this.groupCategory = 0;
            this.groupOrder = 0;
        }

        public void readGroup(AttributeSet attrs) {
            TypedArray a = MaterialMenuInflater.this.mContext.obtainStyledAttributes(attrs, R.styleable.MaterialMenuGroup);
            this.groupCategory = a.getInt(R.styleable.MaterialMenuGroup_android_menuCategory, 0);
            this.groupOrder = a.getInt(R.styleable.MaterialMenuGroup_android_orderInCategory, 0);
            a.recycle();
        }

        public void readItem(AttributeSet attrs) {
            TypedArray a = MaterialMenuInflater.this.mContext.getApplicationContext().obtainStyledAttributes(attrs, R.styleable.MaterialIconViewFormat);
            this.itemIconResId = a.getInt(R.styleable.MaterialIconViewFormat_materialIcon, -1);
            this.itemIconColor = a.getColor(R.styleable.MaterialIconViewFormat_materialIconColor, -1);
            a.recycle();
            a = MaterialMenuInflater.this.mContext.obtainStyledAttributes(attrs, R.styleable.MaterialMenuItem);
            int category = a.getInt(R.styleable.MaterialMenuGroup_android_menuCategory, this.groupCategory);
            int order = a.getInt(R.styleable.MaterialMenuGroup_android_orderInCategory, this.groupOrder);
            this.categoryOrder = category & 0xFFFF0000 | order & 0xFFFF;
            a.recycle();
            this.itemAdded = false;
        }

        public IconData addItem() {
            this.itemAdded = true;
            int ordering = this.getOrdering(this.categoryOrder);
            IconData item = new IconData(this.itemIconResId, this.itemIconColor, ordering);
            this.menu.children.add(this.findInsertIndex(this.menu.children, ordering), item);
            return item;
        }

        public IconData addSubMenuItem() {
            return this.addItem();
        }

        public boolean hasAddedItem() {
            return this.itemAdded;
        }

        private int getOrdering(int categoryOrder) {
            int index = (categoryOrder & 0xFFFF0000) >> 16;
            if (index < 0 || index >= this.sCategoryToOrder.length) {
                throw new IllegalArgumentException("order does not contain a valid category.");
            }
            return this.sCategoryToOrder[index] << 16 | categoryOrder & 0xFFFF;
        }

        private int findInsertIndex(List<IconData> items, int ordering) {
            for (int i = items.size() - 1; i >= 0; --i) {
                IconData item = items.get(i);
                if (item.categoryOrder > ordering) continue;
                return i + 1;
            }
            return 0;
        }
    }

    private class IconData {
        public int itemIconResId;
        public int itemColor;
        public int categoryOrder;
        public List<IconData> children = new ArrayList<IconData>();

        public IconData(int itemIconResId, int itemColor, int categoryOrder) {
            this.itemIconResId = itemIconResId;
            this.itemColor = itemColor;
            this.categoryOrder = categoryOrder;
        }
    }
}

