/*
 * Decompiled with CFR 0.152.
 */
package net.steamcrafted.materialiconlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import net.steamcrafted.materialiconlib.MaterialDrawableBuilder;
import net.steamcrafted.materialiconlib.MaterialIconUtils;
import net.steamcrafted.materialiconlib.R;

public class MaterialIconView
extends ImageView {
    private MaterialDrawableBuilder mBuilder;
    private Drawable mDrawable;
    private MaterialDrawableBuilder.IconValue mIcon;
    private int mOverruledSize = -1;
    private static final int ACTIONBAR_HEIGHT_DP = 24;

    public MaterialIconView(Context context) {
        super(context);
        this.init();
    }

    public MaterialIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaterialIconView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mDrawable == null) {
            int size = MaterialIconUtils.convertDpToPx(this.getContext(), 24.0f);
            int width = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int height = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int paddinghori = this.getPaddingLeft() + this.getPaddingRight();
            int paddingvert = this.getPaddingTop() + this.getPaddingBottom();
            if (width != 0 || height != 0) {
                size = width == 0 ? View.MeasureSpec.getSize((int)heightMeasureSpec) - paddingvert : (height == 0 ? View.MeasureSpec.getSize((int)widthMeasureSpec) - paddinghori : Math.min(View.MeasureSpec.getSize((int)heightMeasureSpec) - paddingvert, View.MeasureSpec.getSize((int)widthMeasureSpec) - paddinghori));
            }
            size = Math.max(0, size);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.regenerateDrawable();
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void init() {
        this.mBuilder = MaterialDrawableBuilder.with(this.getContext());
    }

    private void init(Context context, AttributeSet attrs) {
        this.init();
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.MaterialIconViewFormat);
        try {
            int type = array.getInt(R.styleable.MaterialIconViewFormat_materialIcon, 0);
            if (type >= 0) {
                this.setIcon(type);
            }
        }
        catch (Exception type) {
            // empty catch block
        }
        try {
            int color = array.getColor(R.styleable.MaterialIconViewFormat_materialIconColor, -16777216);
            this.setColor(color);
        }
        catch (Exception color) {
            // empty catch block
        }
        try {
            int size = array.getDimensionPixelSize(R.styleable.MaterialIconViewFormat_materialIconSize, -1);
            if (size >= 0) {
                this.setSizePx(size);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        array.recycle();
    }

    private void setIcon(int iconIndex) {
        this.setIcon(MaterialDrawableBuilder.IconValue.values()[iconIndex]);
    }

    public void setIcon(MaterialDrawableBuilder.IconValue iconValue) {
        this.mIcon = iconValue;
        this.mBuilder.setIcon(iconValue);
        this.regenerateDrawable();
    }

    public void setToActionbarSize() {
        this.setSizeDp(24);
    }

    public void setSizeResource(int dimenRes) {
        this.mBuilder.setSizeResource(dimenRes);
        this.mOverruledSize = this.getContext().getResources().getDimensionPixelSize(dimenRes);
        this.regenerateDrawable();
    }

    public void setSizeDp(int size) {
        this.mBuilder.setSizeDp(size);
        this.mOverruledSize = MaterialIconUtils.convertDpToPx(this.getContext(), size);
        this.regenerateDrawable();
    }

    public void setSizePx(int size) {
        this.mBuilder.setSizePx(size);
        this.mOverruledSize = size;
        this.regenerateDrawable();
    }

    public void setColor(int color) {
        this.mBuilder.setColor(color);
        this.regenerateDrawable();
    }

    public void setColorResource(int colorRes) {
        this.mBuilder.setColorResource(colorRes);
        this.regenerateDrawable();
    }

    public void setStyle(Paint.Style style) {
        this.mBuilder.setStyle(style);
        this.regenerateDrawable();
    }

    private void regenerateDrawable() {
        if (this.mIcon != null) {
            this.mDrawable = this.mBuilder.build();
            super.setImageDrawable(this.mDrawable);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        int scaledWidth = this.getMeasuredWidth();
        int scaledHeight = this.getMeasuredHeight();
        int scaleddimen = this.mOverruledSize >= 0 ? this.mOverruledSize : Math.min(scaledHeight, scaledWidth);
        boolean redraw = false;
        if (this.mDrawable == null) {
            redraw = true;
        } else {
            int initialdimen = Math.min(this.mDrawable.getIntrinsicHeight(), this.mDrawable.getIntrinsicHeight());
            if (initialdimen != scaleddimen) {
                redraw = true;
            }
        }
        if (redraw) {
            if (this.mOverruledSize >= 0) {
                this.mBuilder.setSizePx(this.mOverruledSize);
            } else {
                this.mBuilder.setSizePx(scaleddimen);
            }
            this.regenerateDrawable();
        }
        super.onDraw(canvas);
    }
}

