/*
 * Decompiled with CFR 0.152.
 */
package net.steamcrafted.materialiconlib;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class MaterialIconUtils {
    private static final String mFontPath = "materialdesignicons-webfont.ttf";
    private static Typeface materialFont;

    private MaterialIconUtils() {
    }

    static Typeface getTypeFace(Context context) {
        if (materialFont == null) {
            materialFont = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)mFontPath);
        }
        return materialFont;
    }

    static int convertDpToPx(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static String getIconString(int iconIndex) {
        return new String(Character.toChars(61441 + iconIndex));
    }

    public static int getColorResource(Context context, int colorResource) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getResources().getColor(colorResource, context.getTheme());
        }
        return context.getResources().getColor(colorResource);
    }
}

