/*
 * Decompiled with CFR 0.152.
 */
package net.steamcrafted.loadtoast;

import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import net.steamcrafted.loadtoast.LoadToastView;

public class LoadToast {
    private String mText = "";
    private Context mContext;
    private LoadToastView mView;

    public LoadToast(Context context) {
        this.mContext = context;
        this.mView = new LoadToastView(context);
        final ViewGroup vg = (ViewGroup)((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
        vg.addView((View)this.mView, new ViewGroup.LayoutParams(-2, -2));
        vg.postDelayed(new Runnable(){

            @Override
            public void run() {
                LoadToast.this.mView.setTranslationX((vg.getWidth() - LoadToast.this.mView.getWidth()) / 2);
                LoadToast.this.mView.setTranslationY(-LoadToast.this.mView.getHeight());
            }
        }, 1L);
    }

    public LoadToast setText(String message) {
        this.mText = message;
        this.mView.setText(this.mText);
        return this;
    }

    public LoadToast setTextColor(int color2) {
        this.mView.setTextColor(color2);
        return this;
    }

    public LoadToast setBackgroundColor(int color2) {
        this.mView.setBackgroundColor(color2);
        return this;
    }

    public LoadToast setProgressColor(int color2) {
        this.mView.setProgressColor(color2);
        return this;
    }

    public LoadToast show() {
        this.mView.show();
        this.mView.setAlpha(0.0f);
        this.mView.setTranslationY(-this.mView.getHeight());
        this.mView.animate().alpha(1.0f).translationY(25.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration(300L).setStartDelay(0L).start();
        return this;
    }

    public void success() {
        this.mView.success();
        this.slideUp();
    }

    public void error() {
        this.mView.error();
        this.slideUp();
    }

    private void slideUp() {
        this.mView.animate().setStartDelay(1000L).alpha(0.0f).translationY((float)(-this.mView.getHeight())).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(300L).start();
    }
}

