/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.repository;

import com.staxnet.appserver.utils.XmlHelper;
import com.staxnet.appserver.utils.ZipHelper;
import com.staxnet.utils.FileHelper;
import com.staxnet.utils.FileInputHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LocalRepository {
    public static File DEFAULT_REPO_DIR = new File(System.getProperty("user.home"), ".bees");
    private File repo_dir;
    private File urlcache_dir;
    private String app_template_xml_url = "http://cloudbees-downloads.s3.amazonaws.com/sdk/cloudbees-sdk-config.xml";
    private File sdk_config = null;
    private boolean resolveResources = true;

    public LocalRepository() {
        this.repo_dir = System.getenv("BEES_REPO") != null ? new File(System.getenv("BEES_REPO")) : (System.getProperty("bees.repo") != null ? new File(System.getProperty("bees.repo")) : DEFAULT_REPO_DIR);
        this.urlcache_dir = new File(this.repo_dir, "urlcache");
    }

    public LocalRepository(File repoDir) {
        this.repo_dir = repoDir;
        this.urlcache_dir = new File(this.repo_dir, "urlcache");
    }

    public String getRepositoryPath() {
        return this.repo_dir.getAbsolutePath();
    }

    public void setSdkConfigUrl(String url) {
        this.app_template_xml_url = url;
    }

    private File getSdkConfig() throws Exception {
        if (this.sdk_config == null) {
            this.sdk_config = this.getURLAsFile(this.app_template_xml_url, "sdk/cloudbees-sdk-config.xml", "CloudBees SDK configuration");
        }
        return this.sdk_config;
    }

    public File getURLAsFile(String urlStr, String localCachePath, String description) throws Exception {
        return this.installURLAsFile(urlStr, localCachePath, "install", description);
    }

    public File getApplicationTemplateZip(String templateId) throws Exception {
        File templateFile = null;
        Document doc = XmlHelper.readXMLFromFile(this.getSdkConfig().getCanonicalPath());
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Element e = doc.getDocumentElement();
        NodeList templates = (NodeList)xpath.evaluate("application-templates/application-template", e, XPathConstants.NODESET);
        for (int i = 0; i < templates.getLength() && templateFile == null; ++i) {
            Element element = (Element)templates.item(i);
            String id = element.getAttribute("id");
            String templateUrl = element.getAttribute("href");
            if (!id.equals(templateId)) continue;
            String localPath = String.format("templates/%s.zip", templateId);
            String description = templateId + " application template";
            templateFile = this.installURLAsFile(templateUrl, localPath, "unzip", description);
        }
        return templateFile;
    }

    public File getModuleZip(String group, String name, String rev) throws Exception {
        File moduleFile = null;
        Document doc = XmlHelper.readXMLFromFile(this.getSdkConfig().getCanonicalPath());
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Element e = doc.getDocumentElement();
        NodeList modules = (NodeList)xpath.evaluate("modules/module", e, XPathConstants.NODESET);
        for (int i = 0; i < modules.getLength() && moduleFile == null; ++i) {
            Element element = (Element)modules.item(i);
            String mUrl = element.getAttribute("href");
            String mGroup = element.getAttribute("group");
            String mName = element.getAttribute("name");
            String mRev = element.getAttribute("rev");
            if (!group.equals(mGroup) || !name.equals(mName) || !rev.equals(mRev)) continue;
            String modulePath = String.format("modules/%s/%s/%s-%s", mGroup, mName, mName, mRev);
            String description = String.format("%s/%s module", mGroup, mName);
            moduleFile = this.installURLAsFile(mUrl, modulePath, "unzip", description);
        }
        return moduleFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File installURLAsFile(String urlStr, String localCachePath, String installAction, String description) throws Exception {
        File file;
        block30: {
            URL url = new URL(urlStr);
            if (localCachePath == null) {
                localCachePath = url.getHost() + url.getPath();
                file = new File(this.urlcache_dir, localCachePath);
            } else {
                file = new File(this.repo_dir, localCachePath);
            }
            if (!this.resolveResources) {
                if (!file.exists()) {
                    throw new Exception(String.format("Missing local resource " + file.getAbsolutePath(), new Object[0]));
                }
                return file;
            }
            try {
                HttpURLConnection connection;
                boolean fileNeedsRefresh;
                File file_cache = new File(this.urlcache_dir, localCachePath + ".cache");
                final Properties settings = new Properties();
                boolean settings_dirty = false;
                if (file_cache.exists()) {
                    FileHelper.readFile(file_cache, new FileInputHandler(){

                        public void read(InputStream in) throws IOException {
                            settings.load(in);
                        }
                    });
                }
                RepositorySettings repoSettings = new RepositorySettings(settings);
                boolean bl = fileNeedsRefresh = !file.exists();
                if (!fileNeedsRefresh) {
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("HEAD");
                    if (repoSettings.hasLastModified()) {
                        connection.setRequestProperty("If-Modified-Since", repoSettings.getLastModified());
                    }
                    connection.connect();
                    fileNeedsRefresh = connection.getResponseCode() != 304;
                }
                try {
                    if (!fileNeedsRefresh) break block30;
                    description = description != null ? description : localCachePath;
                    this.log("Downloading %s from %s", description, urlStr);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    if (connection.getResponseCode() == 200) {
                        if (file.exists()) {
                            this.log("Deleting %s", file.getAbsolutePath());
                            FileHelper.deleteAll(file);
                        }
                        boolean unzip = installAction != null && installAction.equals("unzip");
                        File saveFile = !unzip ? file : new File(file.getCanonicalPath() + ".tmp");
                        saveFile.getParentFile().mkdirs();
                        byte[] bytes = new byte[262144];
                        InputStream input = connection.getInputStream();
                        try {
                            FileOutputStream out = new FileOutputStream(saveFile);
                            try {
                                int numRead = input.read(bytes);
                                while (numRead != -1) {
                                    out.write(bytes, 0, numRead);
                                    this.print(".", new String[0]);
                                    numRead = input.read(bytes);
                                }
                                this.log("", new Object[0]);
                                this.log("download completed", new Object[0]);
                            }
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            input.close();
                        }
                        if (unzip) {
                            file.mkdirs();
                            ZipHelper.unzipFile((InputStream)new FileInputStream(saveFile), file, true);
                            saveFile.delete();
                        }
                        String lastModifieds = connection.getHeaderField("Last-Modified");
                        repoSettings.setLastModified(lastModifieds);
                        connection.disconnect();
                        settings_dirty = true;
                        break block30;
                    }
                    if (file.exists()) {
                        this.log("An error occured while downloading %s, using local copy instead", description);
                        this.log("download error details: %d %s", connection.getResponseCode(), connection.getResponseMessage());
                        break block30;
                    }
                    throw new Exception(String.format("File download failed: %d %s", connection.getResponseCode(), connection.getResponseMessage()));
                }
                finally {
                    if (settings_dirty) {
                        file_cache.getParentFile().mkdirs();
                        FileOutputStream fout = new FileOutputStream(file_cache);
                        try {
                            settings.store(fout, "cache settings");
                        }
                        finally {
                            fout.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                if (file != null && file.exists()) {
                    System.out.println(String.format("Failed to download updated resource, using cached version: %s", urlStr));
                }
                throw new Exception(String.format("Unable to download required resource %s", urlStr), e);
            }
        }
        return file;
    }

    public void log(String message, Object ... args) {
        if (args.length > 0) {
            System.out.println(String.format(message, args));
        } else {
            System.out.println(message);
        }
    }

    public void print(String message, String ... args) {
        if (args.length > 0) {
            System.out.print(String.format(message, args));
        } else {
            System.out.print(message);
        }
    }

    static class Settings {
        private Properties properties;

        public Settings(Properties properties) {
            this.properties = properties;
        }

        public int getInteger(String name, int defaultValue) {
            String value = this.getString(name, Integer.valueOf(defaultValue).toString());
            return Integer.parseInt(value);
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            String value = this.getString(name, Boolean.valueOf(defaultValue).toString());
            return new Boolean(value);
        }

        public boolean exists(String name) {
            return this.properties.containsKey(name);
        }

        public void set(String name, String value) {
            this.properties.setProperty(name, value);
        }

        public void remove(String name) {
            this.properties.remove(name);
        }

        public String getString(String name, String defaultValue) {
            String value = this.properties.getProperty(name);
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }
    }

    static class RepositorySettings
    extends Settings {
        private static String KEY_LASTMODIFIED = "lastmodified";

        public RepositorySettings(Properties properties) {
            super(properties);
        }

        public boolean hasLastModified() {
            return this.exists(KEY_LASTMODIFIED);
        }

        public String getLastModified() {
            return this.getString(KEY_LASTMODIFIED, null);
        }

        public void setLastModified(String value) {
            if (value == null) {
                this.remove(KEY_LASTMODIFIED);
            } else {
                this.set(KEY_LASTMODIFIED, value);
            }
        }
    }
}

