/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.utils;

import com.staxnet.appserver.utils.StreamHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    private static int BUFFER = 2048;

    public static final void addFileToZip(File file, String entryName, ZipOutputStream zos) throws IOException {
        byte[] buffer = new byte[8192];
        int read = 0;
        FileInputStream in = new FileInputStream(file);
        ZipEntry entry = new ZipEntry(entryName);
        zos.putNextEntry(entry);
        while (-1 != (read = in.read(buffer))) {
            zos.write(buffer, 0, read);
        }
        in.close();
    }

    public static final void addFileToZip(InputStream in, String entryName, ZipOutputStream zos) throws IOException {
        byte[] buffer = new byte[8192];
        int read = 0;
        ZipEntry entry = new ZipEntry(entryName);
        zos.putNextEntry(entry);
        while (-1 != (read = in.read(buffer))) {
            zos.write(buffer, 0, read);
        }
        in.close();
    }

    public static final void addDirectoryToZip(File directory, File base, String dirPrefix, ZipOutputStream zos) throws IOException {
        if (base == null) {
            base = directory;
        }
        if (dirPrefix == null) {
            dirPrefix = "";
        }
        if (!base.equals(directory) && directory.list().length == 0) {
            String dirEntryPath = dirPrefix + directory.getPath().substring(base.getPath().length() + 1).replace('\\', '/');
            ZipEntry dirEntry = new ZipEntry(dirEntryPath.endsWith("/") ? dirEntryPath : dirEntryPath + "/");
            zos.putNextEntry(dirEntry);
        }
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isHidden()) continue;
            if (files[i].isDirectory()) {
                ZipHelper.addDirectoryToZip(files[i], base, dirPrefix, zos);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            ZipEntry entry = new ZipEntry(dirPrefix + files[i].getPath().substring(base.getPath().length() + 1).replace('\\', '/'));
            entry.setTime(files[i].lastModified());
            zos.putNextEntry(entry);
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
        }
    }

    public static InputStream getZipEntry(InputStream zipFile, final String entryName) throws IOException {
        final ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipHelper.unzipFile(zipFile, new ZipEntryHandler(){
            private boolean unzipped = false;

            public void unzip(ZipEntry entry, InputStream zis) throws IOException {
                if (!this.unzipped && entry.getName().equals(entryName)) {
                    StreamHelper.transferStream(zis, bout);
                    this.unzipped = true;
                }
            }
        }, false);
        return new ByteArrayInputStream(bout.toByteArray());
    }

    public static void unzipFile(InputStream fis, ZipEntryHandler zipHandler, boolean closeStream) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        while ((entry = zis.getNextEntry()) != null) {
            zipHandler.unzip(entry, StreamHelper.createNoCloseInputStream(zis));
        }
        if (closeStream) {
            zis.close();
        }
    }

    public static void unzipFile(InputStream fis, File targetDir, boolean closeStream) throws IOException {
        ZipHelper.unzipFile(fis, new UnzipToDirEntryHandler(targetDir), closeStream);
    }

    private static File unzipEntryToFolder(ZipEntry entry, InputStream zis, File destFolder) throws FileNotFoundException, IOException {
        int count;
        if (entry.isDirectory()) {
            File destFile = new File(destFolder, entry.getName());
            destFile.mkdirs();
            return destFile;
        }
        byte[] data = new byte[BUFFER];
        File destFile = new File(destFolder, entry.getName());
        File parentFolder = destFile.getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
        while ((count = zis.read(data, 0, BUFFER)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
        if (entry.getTime() > -1L) {
            destFile.setLastModified(entry.getTime());
        }
        return destFile;
    }

    private static class UnzipToDirEntryHandler
    implements ZipEntryHandler {
        private File targetDir;

        public UnzipToDirEntryHandler(File targetDir) {
            this.targetDir = targetDir;
        }

        public void unzip(ZipEntry entry, InputStream zis) throws IOException {
            ZipHelper.unzipEntryToFolder(entry, zis, this.targetDir);
        }
    }

    public static interface ZipEntryHandler {
        public void unzip(ZipEntry var1, InputStream var2) throws IOException;
    }
}

