/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.utils;

import com.staxnet.appserver.IAppConfiguration;
import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppServerConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.HttpConfig;
import com.staxnet.appserver.config.ParamConfig;
import com.staxnet.appserver.config.RealmConfig;
import com.staxnet.appserver.config.ResourceConfig;
import com.staxnet.appserver.config.ServerParams;
import com.staxnet.appserver.config.SessionConfig;
import com.staxnet.appserver.config.WebConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppServerConfiguration
implements IAppServerConfiguration,
IAppConfiguration {
    protected AppServerConfig appServerConfig;
    protected AppConfig appConfig;
    protected static Logger logger = Logger.getLogger(AppServerConfiguration.class.getName());

    protected AppServerConfiguration() {
    }

    @Override
    public IAppConfiguration getAppConfiguration() {
        return this;
    }

    @Override
    public RealmConfig getRealm() {
        return this.appConfig.getRealm();
    }

    @Override
    public List<ResourceConfig> getResources() {
        return this.appConfig.getResources();
    }

    @Override
    public void addOrUpdateResource(ResourceConfig resource) {
        this.appConfig.addOrUpdateResource(resource);
    }

    @Override
    public List<WebConfig> getWebConfigs() {
        return this.appConfig.getWebConfigs();
    }

    @Override
    public String getApplicationId() {
        return this.appConfig.getApplicationId();
    }

    @Override
    public String getSessionDataSource() {
        return this.appConfig.getSessionDataSource();
    }

    @Override
    public SessionConfig getSessionPersistence() {
        return this.appServerConfig.getSessionPersistence();
    }

    @Override
    public List<ResourceConfig> getServerResources() {
        return this.appServerConfig.getResources();
    }

    @Override
    public String getServerCallbackAuthToken() {
        return this.appServerConfig.getServerCallbackAuthToken();
    }

    @Override
    public String getServerCallbackUrl() {
        return this.appServerConfig.getServerCallbackUrl();
    }

    @Override
    public List<DependencyConfig> getDependencies() {
        return this.appConfig.getDependencies();
    }

    @Override
    public String getDriverCallbackBaseUrl() {
        return this.appServerConfig.getDriverCallbackBaseUrl();
    }

    @Override
    public int getStatusInterval() {
        return this.appServerConfig.getStatusInterval();
    }

    @Override
    public String getColdFusionLicense() {
        return this.appServerConfig.getColdFusionLicense();
    }

    @Override
    public ServerParams getServerParams() {
        return this.appServerConfig.getServerParams();
    }

    @Override
    public boolean isAdminEngineEnabled() {
        return this.appServerConfig.isAdminEngineEnabled();
    }

    @Override
    public boolean isReloadEnabled() {
        return this.appServerConfig.isReloadEnabled();
    }

    @Override
    public HttpConfig getHttpConfig() {
        return this.appServerConfig.getHttpConfig();
    }

    @Override
    public boolean isPrivate() {
        return "private".equals(this.appServerConfig.getSecurityMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAppServerConfig(File configFile) {
        this.appServerConfig = new AppServerConfig();
        InputStream input = null;
        if (configFile != null && configFile.exists()) {
            try {
                logger.info("loading app config: " + configFile.getAbsolutePath());
                File xmlFile = configFile;
                input = new FileInputStream(xmlFile);
            }
            catch (FileNotFoundException e1) {
                // empty catch block
            }
        }
        if (input == null) {
            if (configFile != null && !configFile.exists()) {
                logger.log(Level.WARNING, "server config file does not exist: " + configFile.getAbsolutePath());
            }
            input = this.getClass().getResourceAsStream("/conf/appserver.xml");
        }
        try {
            this.appServerConfig = AppServerConfig.load(input);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing config file", e);
            }
        }
    }

    protected void mergeResources() {
        HashMap<String, ResourceConfig> applicationResources = new HashMap<String, ResourceConfig>();
        List<ResourceConfig> resources = this.getAppConfiguration().getResources();
        for (ResourceConfig resourceConfig : resources) {
            applicationResources.put(resourceConfig.getName(), resourceConfig);
            ResourceConfig serverResourceConfig = this.getResourceConfig(resourceConfig.getName(), this.getServerResources());
            if (serverResourceConfig == null) continue;
            resourceConfig = this.mergeResourceConfig(resourceConfig, serverResourceConfig);
            this.getAppConfiguration().addOrUpdateResource(resourceConfig);
        }
        for (ResourceConfig resourceConfig : this.getServerResources()) {
            if (applicationResources.get(resourceConfig.getName()) != null) continue;
            this.getAppConfiguration().addOrUpdateResource(resourceConfig);
        }
        for (WebConfig wc : this.getWebConfigs()) {
            Map<String, String> existingParameters = wc.getParametersMap();
            for (ResourceConfig resourceConfig : resources) {
                if (resourceConfig.getType() == null || !resourceConfig.getType().startsWith("context") || existingParameters.get(resourceConfig.getName()) != null) continue;
                String[] parts = resourceConfig.getType().split(":");
                if (parts.length > 1) {
                    if (!wc.getContextRoot().equals(parts[1])) continue;
                    wc.setParameter(resourceConfig.getName(), resourceConfig.getValue(), null);
                    continue;
                }
                wc.setParameter(resourceConfig.getName(), resourceConfig.getValue(), null);
            }
        }
    }

    private ResourceConfig getResourceConfig(String name, List<ResourceConfig> resources) {
        for (ResourceConfig config : resources) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        return null;
    }

    private ResourceConfig mergeResourceConfig(ResourceConfig from, ResourceConfig to) {
        if (from.getAuth() != null) {
            to.setAuth(from.getAuth());
        }
        if (from.getType() != null) {
            to.setType(from.getType());
        }
        if (from.getScope() != null) {
            to.setScope(from.getScope());
        }
        if (from.getValue() != null) {
            to.setValue(from.getValue());
        }
        if (from.getDelim() != null) {
            to.setDelim(from.getDelim());
        }
        for (ParamConfig param : from.getParameters()) {
            to.setParameter(param.getName(), param.getValue());
        }
        from.setParameters(to.getParameters());
        return from;
    }
}

