/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ResourceConfig;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXML {
    List<ResourceConfig> resourceReferences = new ArrayList<ResourceConfig>();

    public List<ResourceConfig> getResourceReferences() {
        return this.resourceReferences;
    }

    public void load(String file) {
        Document doc = this.readXML(new InputSource(file));
        if (doc == null) {
            return;
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            Element e = doc.getDocumentElement();
            NodeList nodes = (NodeList)xpath.evaluate("resource-ref", e, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String refName = this.getNodeValue(node, xpath, "res-ref-name");
                String resType = this.getNodeValue(node, xpath, "res-type");
                String resAuth = this.getNodeValue(node, xpath, "res-auth");
                ResourceConfig resourceConfig = new ResourceConfig(refName, resType);
                resourceConfig.setAuth(resAuth);
                this.resourceReferences.add(resourceConfig);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private String getNodeValue(Node node, XPath xpath, String expression) throws XPathExpressionException {
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        if (n == null) {
            return null;
        }
        String nodeValue = xpath.evaluate("text()", n);
        return nodeValue.trim();
    }

    private Document readXML(InputSource input) {
        DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
        dBF.setIgnoringComments(true);
        dBF.setValidating(false);
        Document doc = null;
        try {
            dBF.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = dBF.newDocumentBuilder();
            doc = builder.parse(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }
}

