/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ContextParamConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.ParamConfig;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="web")
public class WebConfig {
    @XStreamAlias(value="web-uri")
    private String webUri;
    @XStreamAlias(value="run-uri")
    private String runUri;
    @XStreamAlias(value="context-root")
    private String contextRoot;
    @XStreamImplicit(itemFieldName="context-param")
    private List<ContextParamConfig> parameters;
    @XStreamImplicit(itemFieldName="sysprop")
    private List<ParamConfig> systemProperties = new ArrayList<ParamConfig>();
    @XStreamAlias(value="dependencies")
    private List<DependencyConfig> dependencies = new ArrayList<DependencyConfig>();
    @XStreamOmitField
    private Map<String, String> paramMap;

    public WebConfig(String contextRoot) {
        this.contextRoot = contextRoot;
        this.parameters = new ArrayList<ContextParamConfig>();
        this.paramMap = ContextParamConfig.getParametersMap(this.parameters);
    }

    public WebConfig(String webUri, String contextRoot, List<ContextParamConfig> parameters) {
        this.webUri = webUri;
        this.contextRoot = contextRoot;
        this.parameters = parameters;
    }

    public String getWebUri() {
        return this.webUri;
    }

    public void setWebUri(String webUri) {
        this.webUri = webUri;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public List<DependencyConfig> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<DependencyConfig> dependencies) {
        this.dependencies = dependencies;
    }

    public void setSystemProperties(List<ParamConfig> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public List<ContextParamConfig> getParameters() {
        return this.parameters;
    }

    public void setParameter(String name, String value, String description) {
        if (this.paramMap.containsKey(name)) {
            ContextParamConfig paramConfig = this.getContextParam(name);
            paramConfig.setValue(value);
            paramConfig.setDescription(description);
            this.paramMap.put(name, value);
        } else {
            this.parameters.add(new ContextParamConfig(name, value, description));
            this.paramMap.put(name, value);
        }
    }

    public Map<String, String> getParametersMap() {
        return this.paramMap;
    }

    private ContextParamConfig getContextParam(String name) {
        for (ContextParamConfig param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextRoot == null ? 0 : this.contextRoot.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : ((Object)this.dependencies).hashCode());
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.systemProperties == null ? 0 : ((Object)this.systemProperties).hashCode());
        result = 31 * result + (this.runUri == null ? 0 : this.runUri.hashCode());
        result = 31 * result + (this.webUri == null ? 0 : this.webUri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebConfig other = (WebConfig)obj;
        if (this.contextRoot == null ? other.contextRoot != null : !this.contextRoot.equals(other.contextRoot)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !((Object)this.dependencies).equals(other.dependencies)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        if (this.systemProperties == null ? other.systemProperties != null : !((Object)this.systemProperties).equals(other.systemProperties)) {
            return false;
        }
        if (this.runUri == null ? other.runUri != null : !this.runUri.equals(other.runUri)) {
            return false;
        }
        return !(this.webUri == null ? other.webUri != null : !this.webUri.equals(other.webUri));
    }
}

