/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ParamConfig;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="resource")
public class ResourceConfig {
    @XStreamAsAttribute
    private String value;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String auth;
    @XStreamAsAttribute
    private String type;
    @XStreamAsAttribute
    private String delim;
    @XStreamAsAttribute
    private String scope;
    @XStreamImplicit(itemFieldName="param")
    private List<ParamConfig> parameters;

    public ResourceConfig(String name) {
        this.name = name;
    }

    public ResourceConfig(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ResourceConfig(String name, String value, String type) {
        this.value = value;
        this.name = name;
        this.type = type;
    }

    public ResourceConfig(String name, String auth, String type, List<ParamConfig> parameters) {
        this.name = name;
        this.auth = auth;
        this.type = type;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDelim() {
        return this.delim;
    }

    public void setDelim(String delim) {
        this.delim = delim;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public List<ParamConfig> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParamConfig>();
        }
        return this.parameters;
    }

    public void setParameters(List<ParamConfig> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String name, String value) {
        ParamConfig paramConfig = this.getParameter(name);
        if (paramConfig != null) {
            paramConfig.setValue(value);
        } else {
            this.addParameter(new ParamConfig(name, value));
        }
    }

    private void addParameter(ParamConfig param) {
        this.getParameters().add(param);
    }

    public ParamConfig getParameter(String name) {
        for (ParamConfig param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.auth == null ? 0 : this.auth.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.delim == null ? 0 : this.delim.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceConfig other = (ResourceConfig)obj;
        if (this.auth == null ? other.auth != null : !this.auth.equals(other.auth)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.delim == null ? other.delim != null : !this.delim.equals(other.delim)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
    }

    public String toString() {
        return "ResourceConfig{value='" + this.value + '\'' + ", name='" + this.name + '\'' + ", auth='" + this.auth + '\'' + ", type='" + this.type + '\'' + ", delim='" + this.delim + '\'' + ", scope='" + this.scope + '\'' + ", parameters=" + this.parameters + '}';
    }

    public ResourceConfig copy() {
        ResourceConfig res = new ResourceConfig(this.getName(), this.getValue(), this.getType());
        res.setAuth(this.getAuth());
        for (ParamConfig param : this.getParameters()) {
            ParamConfig p = new ParamConfig(param.getName(), param.getValue());
            res.addParameter(p);
        }
        return res;
    }
}

