/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.ParamConfig;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="http-connector")
public class HttpConfig {
    @XStreamAlias(value="protocol")
    @XStreamAsAttribute
    private String protocol;
    @XStreamImplicit(itemFieldName="param")
    private List<ParamConfig> parameters;

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = "org.apache.coyote.http11.Http11Protocol";
        }
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public List<ParamConfig> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParamConfig>();
        }
        return this.parameters;
    }

    public void setParameter(String name, String value) {
        ParamConfig paramConfig = this.getParam(name);
        if (paramConfig != null) {
            paramConfig.setValue(value);
        } else {
            this.addParameter(new ParamConfig(name, value));
        }
    }

    private ParamConfig getParam(String name) {
        for (ParamConfig param : this.getParameters()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    private void addParameter(ParamConfig param) {
        this.getParameters().add(param);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpConfig other = (HttpConfig)obj;
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }
}

